﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.MovieComment.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.MovieComment.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		switch (Request.QueryString["KeywordType"])
		{
			case "MovieName":
				condition.Append(and + Alias.MovieComment.MovieName + " LIKE '%" + keyword + "%'");
				break;
			case "MovieID":
				condition.Append(and + Alias.MovieComment.MovieID + "=" + keyword);
				break;
			case "MovieInnerID":
				condition.Append(and + Alias.MovieComment.MovieInnerID + "=" + keyword);
				break;
			case "Content":
				condition.Append(and + Alias.MovieComment.Content + " LIKE '%" + keyword + "%'");
				break;
		}
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.MovieComment.CreateTime + " DESC";
			break;
		case "2":
			sort = Alias.MovieComment.CreateTime + " ASC";
			break;
		default:
			sort = Alias.MovieComment.CreateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<ilghar:List ID="List" Object="MovieComment" Page="PageNumber" PageSize="5" Condition="Condition()" Sort="Sort()">
	<ilghar:Record>
		<div id="Record<%=InnerID%>">
			<ul class="Title">
				<li class="Left"></li>
				<li class="Middle">
					<span class="MiddleLeft <%=ContentLang%>Font"><%=MovieName%></span>
					<span class="MiddleRight"><%=Creator%> 发布于：<%=CreateTime%> <a href="edit.aspx?ID=<%=InnerID%>">编辑</a><input type="checkbox" name="Sel" value="<%=InnerID%>" /></span>
				</li>
				<li class="Right"></li>
			</ul>
			<p class="<%=ContentLang%>Font"><%=Content%></p>
		</div>
	</ilghar:Record>
</ilghar:List>
<ilghar:Pagination Page="PageNumber" PageSize="5" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>