﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	condition.Append(Alias.Music.IsDeleted + "=false");
	condition.Append(" AND " + Alias.Music.IsChecked + "=true");

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubCategory"]))
		{
			condition.Append(" AND " + Alias.Music.IncludeSubCategory + "=" + categoryID);
		}
		else
		{
			if (categoryID == "0")
				condition.Append(" AND " + Alias.Music.CategoryID + " IS NULL");
			else
				condition.Append(" AND " + Alias.Music.CategoryID + "=" + categoryID);
		}
	}
	#endregion

	#region 地区
	string regionID = Request.QueryString["RegionID"];
	if (!String.IsNullOrEmpty(regionID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubRegion"]))
		{
			condition.Append(" AND " + Alias.Music.IncludeSubRegion + "=" + regionID);
		}
		else
		{
			if (regionID == "0")
				condition.Append(" AND " + Alias.Music.RegionID + " IS NULL");
			else
				condition.Append(" AND " + Alias.Music.RegionID + "=" + regionID);
		}
	}
	#endregion

	#region 语言
	string languageID = Request.QueryString["LanguageID"];
	if (!String.IsNullOrEmpty(languageID))
	{
		if (languageID == "0")
			condition.Append(" AND " + Alias.Music.LanguageID + " IS NULL");
		else
			condition.Append(" AND " + Alias.Music.LanguageID + "=" + languageID);
	}
	#endregion

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		switch (Request.QueryString["KeywordType"])
		{
			case "Name":
				condition.Append(" AND " + Alias.Music.Name + " LIKE '%" + keyword + "%'");
				break;
			case "AlbumName":
				condition.Append(" AND " + Alias.Music.AlbumNames + " LIKE '%" + keyword + "%'");
				break;
			case "PersonName":
				condition.Append(" AND " + Alias.Music.PersonNames + " LIKE '%" + keyword + "%'");
				break;
			case "TagName":
				condition.Append(" AND " + Alias.Music.TagNames + " LIKE '%" + keyword + "%'");
				break;
		}
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Music.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Music.UpdateTime + " ASC";
			break;
		case "3":
			sort = Alias.Music.HitCount + " DESC";
			break;
		case "4":
			sort = Alias.Music.HitCount + " ASC";
			break;
		case "5":
			sort = Alias.Music.Recommend + " DESC";
			break;
		case "6":
			sort = Alias.Music.Recommend + " ASC";
			break;
		case "7":
			sort = Alias.Music.Hold + " DESC";
			break;
		case "8":
			sort = Alias.Music.Hold + " ASC";
			break;
		default:
			sort = Alias.Music.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1">
	<thead>
		<tr><th colspan="4">结果</th></tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Music" Page="PageNumber" PageSize="24" Condition="Condition()" Sort="Sort()">
			<ilghar:Row MaxCol="4">
				<tr>
					<ilghar:Col MaxRecord="1">
						<ilghar:Record>
							<td><a href="" ID="<%=ID%>" Name="<%=Name%>" InnerID="<%=InnerID%>"><%=Name%></a></td>
						</ilghar:Record>
					</ilghar:Col>
				</tr>
			</ilghar:Row>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="24" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>