﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Register TagPrefix="IlgharUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="IlgharUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<base target="_self" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="pragma" content="no-cache" />
<meta http-equiv="Cache-Control" content="no-cache" />
<meta http-equiv="Expires" content="Mon,1 Fab 1979 23:36:05 GMT" />
<title>选择音乐</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<ilgharUC:Ime Ime="true" Eot="true" runat="server" />
<style type="text/css">
.Block{width:96%}
</style>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	condition.Append(Alias.Music.IsDeleted + "=false");
	condition.Append(" AND " + Alias.Music.IsChecked + "=true");

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubCategory"]))
		{
			condition.Append(" AND " + Alias.Music.IncludeSubCategory + "=" + categoryID);
		}
		else
		{
			if (categoryID == "0")
				condition.Append(" AND " + Alias.Music.CategoryID + " IS NULL");
			else
				condition.Append(" AND " + Alias.Music.CategoryID + "=" + categoryID);
		}
	}
	#endregion

	#region 地区
	string regionID = Request.QueryString["RegionID"];
	if (!String.IsNullOrEmpty(regionID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubRegion"]))
		{
			condition.Append(" AND " + Alias.Music.IncludeSubRegion + "=" + regionID);
		}
		else
		{
			if (regionID == "0")
				condition.Append(" AND " + Alias.Music.RegionID + " IS NULL");
			else
				condition.Append(" AND " + Alias.Music.RegionID + "=" + regionID);
		}
	}
	#endregion

	#region 语言
	string languageID = Request.QueryString["LanguageID"];
	if (!String.IsNullOrEmpty(languageID))
	{
		if (languageID == "0")
			condition.Append(" AND " + Alias.Music.LanguageID + " IS NULL");
		else
			condition.Append(" AND " + Alias.Music.LanguageID + "=" + languageID);
	}
	#endregion

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		switch (Request.QueryString["KeywordType"])
		{
			case "Name":
				condition.Append(" AND " + Alias.Music.Name + " LIKE '%" + keyword + "%'");
				break;
			case "AlbumName":
				condition.Append(" AND " + Alias.Music.AlbumNames + " LIKE '%" + keyword + "%'");
				break;
			case "PersonName":
				condition.Append(" AND " + Alias.Music.PersonNames + " LIKE '%" + keyword + "%'");
				break;
			case "TagName":
				condition.Append(" AND " + Alias.Music.TagNames + " LIKE '%" + keyword + "%'");
				break;
		}
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Music.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Music.UpdateTime + " ASC";
			break;
		case "3":
			sort = Alias.Music.HitCount + " DESC";
			break;
		case "4":
			sort = Alias.Music.HitCount + " ASC";
			break;
		case "5":
			sort = Alias.Music.Recommend + " DESC";
			break;
		case "6":
			sort = Alias.Music.Recommend + " ASC";
			break;
		case "7":
			sort = Alias.Music.Hold + " DESC";
			break;
		case "8":
			sort = Alias.Music.Hold + " ASC";
			break;
		default:
			sort = Alias.Music.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = "music_select";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
</script>
</head>
<body>
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">选择音乐</li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="RegionID" class="<%=ContentLang%>Font">
			<option value="">所有地区</option>
			<option value="0">未指定地区</option>
			<ilghar:Tree Object="Region">
				<ilghar:Control>
					<ilghar:Space>&nbsp;&nbsp;</ilghar:Space>
					<ilghar:Line>│</ilghar:Line>
					<ilghar:TopOpen>┌</ilghar:TopOpen>
					<ilghar:Top>┌</ilghar:Top>
					<ilghar:MiddleOpen>├</ilghar:MiddleOpen>
					<ilghar:Middle>├</ilghar:Middle>
					<ilghar:BottomOpen>└</ilghar:BottomOpen>
					<ilghar:Bottom>└</ilghar:Bottom>
				</ilghar:Control>
				<ilghar:Record>
					<option value="<%=ID%>"><%=Control%><%=Name%></option>
					<%=ChildRecords%>
				</ilghar:Record>
			</ilghar:Tree>
		</select>
		<input type="checkbox" id="IncludeSubRegion" /><label for="IncludeSubRegion">子区</label>
		<select id="LanguageID" class="<%=ContentLang%>Font">
			<option value="">所有语言</option>
			<option value="0">未指定语言</option>
			<ilghar:List Object="Language">
				<ilghar:Record>
					<option value="<%=ID%>"><%=Name%></option>
				</ilghar:Record>
			</ilghar:List>
		</select>
		<select id="CategoryID" class="<%=ContentLang%>Font">
			<option value="">所有类别</option>
			<option value="0">未指定类别</option>
			<ilghar:Tree Object="MusicCategory">
				<ilghar:Control>
					<ilghar:Space>&nbsp;&nbsp;</ilghar:Space>
					<ilghar:Line>│</ilghar:Line>
					<ilghar:TopOpen>┌</ilghar:TopOpen>
					<ilghar:Top>┌</ilghar:Top>
					<ilghar:MiddleOpen>├</ilghar:MiddleOpen>
					<ilghar:Middle>├</ilghar:Middle>
					<ilghar:BottomOpen>└</ilghar:BottomOpen>
					<ilghar:Bottom>└</ilghar:Bottom>
				</ilghar:Control>
				<ilghar:Record>
					<option value="<%=ID%>"><%=Control%><%=Name%></option>
					<%=ChildRecords%>
				</ilghar:Record>
			</ilghar:Tree>
		</select>
		<input type="checkbox" id="IncludeSubCategory" /><label for="IncludeSubCategory">子类</label>
	</div>
	<div class="ToolBar">
		<select id="Sort">
			<option value="1">更新日期↓</option>
			<option value="2">更新日期↑</option>
			<option value="3">人气↓</option>
			<option value="4">人气↑</option>
			<option value="5">推荐↓</option>
			<option value="6">推荐↑</option>
			<option value="7">置顶↓</option>
			<option value="8">置顶↑</option>
		</select>
		<input id="Keyword" tabindex="1" class="Text <%=ContentLang%>Font" />
		<select id="KeywordType">
			<option value="Name">名称</option>
			<option value="AlbumName">专辑名称</option>
			<option value="PersonName">歌手名称</option>
			<option value="TagName">标签名称</option>
		</select>
		<input type="button" id="Search" value="搜索" class="Button" />
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr><th colspan="4">结果</th></tr>
			</thead>
			<tbody>
				<ilghar:List ID="List" Object="Music" Page="PageNumber" PageSize="24" Condition="Condition()" Sort="Sort()">
					<ilghar:Row MaxCol="4">
						<tr>
							<ilghar:Col MaxRecord="1">
								<ilghar:Record>
									<td><a href="" ID="<%=ID%>" Name="<%=Name%>" InnerID="<%=InnerID%>"><%=Name%></a></td>
								</ilghar:Record>
							</ilghar:Col>
						</tr>
					</ilghar:Row>
				</ilghar:List>
			</tbody>
		</table>
		<ilghar:Pagination Page="PageNumber" PageSize="24" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ilghar:FirstPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:FirstPage>
					<ilghar:CurrentPage Range="5">
						<ilghar:Yes>
							<span class="Current"><%=Index%></span>						
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ilghar:No>
					</ilghar:CurrentPage>
					<ilghar:LastPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:LastPage>
				</div>
			</div>
		</ilghar:Pagination>
	</div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=JsPath%>music.js"></script>
</body>
</html>