﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	switch (Request.QueryString["State"])
	{
		case "1":
			condition.Append(Alias.Order.IsConfirmed + "=false AND " + Alias.Order.IsArchived + "=false AND " + Alias.Order.IsCanceled + "=false");
			break;
		case "2":
			condition.Append(Alias.Order.IsConfirmed + "=true AND " + Alias.Order.IsArchived + "=false AND " + Alias.Order.IsCanceled + "=false");
			break;
		case "3":
			condition.Append(Alias.Order.IsCanceled + "=true");
			break;
		case "4":
			condition.Append(Alias.Order.IsArchived + "=true");
			break;
		default:
			break;
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Number")
			condition.Append(and + Alias.Order.Number + "='" + keyword + "'");
		else if (Request.QueryString["KeywordType"] == "Member")
			condition.Append(and + Alias.Order.Member + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "OrdererName")
			condition.Append(and + Alias.Order.OrdererName + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "ReceiverName")
			condition.Append(and + Alias.Order.ReceiverName + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Order.OrderTime + " DESC";
			break;
		case "2":
			sort = Alias.Order.OrderTime + " ASC";
			break;
		case "3":
			sort = Alias.Order.Price + " DESC";
			break;
		case "4":
			sort = Alias.Order.Price + " ASC";
			break;
		default:
			sort = Alias.Order.OrderTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1">
<thead>
	<tr>
		<th>操作</th>
		<th width="120">订单号</th>
		<th>订单总额</th>
		<th>会员</th>
		<th>收货人</th>
		<th>下单日期</th>
		<th>订单状态</th>
		<th>归档/取消</th>
	</tr>
</thead>
<tbody>
	<ilghar:List ID="List" Object="Order" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
		<ilghar:Record>
			<tr>
				<td>
					<%If !Convert.ToBoolean(IsArchived) && !Convert.ToBoolean(IsCanceled)%>
						<%If Convert.ToBoolean(IsConfirmed)%>
							<%If Int32.Equals(IsPayed, 1)%>
								<input type="button" value="付款" id="Payment_<%=InnerID%>" />
							<%ElseIf Int32.Equals(IsPayed, 2)%>
								<input type="button" value="付款" id="Payment_<%=InnerID%>" />
								<input type="button" value="退款" id="Refund_<%=InnerID%>" />
							<%ElseIf Int32.Equals(IsPayed, 3)%>
								<input type="button" value="退款" id="Refund_<%=InnerID%>" />
							<%ElseIf Int32.Equals(IsPayed, 4)%>
								<input type="button" value="付款" id="Payment_<%=InnerID%>" />
								<input type="button" value="退款" id="Refund_<%=InnerID%>" />
							<%ElseIf Int32.Equals(IsPayed, 5)%>
								<input type="button" value="付款" id="Payment_<%=InnerID%>" />
							<%EndIf%>
							
							<%If Int32.Equals(IsDelivered, 1)%>
								<input type="button" value="发货" id="Delivery_<%=InnerID%>" />
							<%ElseIf Int32.Equals(IsDelivered, 2)%>
								<input type="button" value="发货" id="Delivery_<%=InnerID%>" />
								<input type="button" value="退货" id="Return_<%=InnerID%>" />
							<%ElseIf Int32.Equals(IsDelivered, 3)%>
								<input type="button" value="退货" id="Return_<%=InnerID%>" />
							<%ElseIf Int32.Equals(IsDelivered, 4)%>
								<input type="button" value="发货" id="Delivery_<%=InnerID%>" />
								<input type="button" value="退货" id="Return_<%=InnerID%>" />
							<%ElseIf Int32.Equals(IsDelivered, 5)%>
								<input type="button" value="发货" id="Delivery_<%=InnerID%>" />
							<%EndIf%>										
						<%Else%>
							<input type="button" value="确认" id="Confirm_<%=InnerID%>" />
						<%EndIf%>
					<%EndIf%>
				</td>
				<td>
					<%If !Convert.ToBoolean(IsArchived) && !Convert.ToBoolean(IsCanceled) && !Convert.ToBoolean(IsConfirmed)%>
						<a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Number%></a>
					<%Else%>
						<a href="view.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Number%></a>
					<%EndIf%>
				</td>
				<td><%=Sum%></td>
				<td><%=Member%></td>
				<td><%=ReceiverName%></td>
				<td><%=OrderTime%></td>
				<td>
					<%If Int32.Equals(IsPayed, 1)%>
						未付款
					<%ElseIf Int32.Equals(IsPayed, 2)%>
						部分付款
					<%ElseIf Int32.Equals(IsPayed, 3)%>
						已付款
					<%ElseIf Int32.Equals(IsPayed, 4)%>
						部分退款
					<%ElseIf Int32.Equals(IsPayed, 5)%>
						已退款
					<%EndIf%>
					，
					<%If Int32.Equals(IsDelivered, 1)%>
						未发货
					<%ElseIf Int32.Equals(IsDelivered, 2)%>
						部分发货
					<%ElseIf Int32.Equals(IsDelivered, 3)%>
						已发货
					<%ElseIf Int32.Equals(IsDelivered, 4)%>
						部分退货
					<%ElseIf Int32.Equals(IsDelivered, 5)%>
						已退货
					<%EndIf%>
					
					<%If Convert.ToBoolean(IsArchived)%>
						，已归档
					<%EndIf%>
					
					<%If Convert.ToBoolean(IsCanceled)%>
						，已取消
					<%EndIf%>
				</td>
				<td>
					<%If !Convert.ToBoolean(IsArchived) && !Convert.ToBoolean(IsCanceled)%>
						<input type="button" value="归档" id="Archive_<%=InnerID%>" />
						<input type="button" value="取消" id="Cancel_<%=InnerID%>" />									
					<%ElseIf Convert.ToBoolean(IsArchived) || Convert.ToBoolean(IsCanceled)%>
						<input type="button" value="删除" id="Delete_<%=InnerID%>" />
					<%EndIf%>
				</td>
			</tr>
		</ilghar:Record>
	</ilghar:List>
</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>