﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Register TagPrefix="IlgharUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="ThisChannel" Object="Channel" InnerID="Request.QueryString['ID']" Validate="True" />
<ilghar:List ID="ChannelTable" Object="Channel" />
<ilghar:List ID="ExtraInstanceTable" Object="Channel.ExtraInstance" Condition="ChannelID=ThisChannel[ID]" />
<ilghar:List ID="ModuleTable" Object="Module" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>栏目绑定</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<ilgharUC:Ime Ime="false" Eot="true" runat="server" />
<script language="c#" runat="server">
private DataRow _channelRow;
private string _languageAb;
private string _templatePath;
protected override void OnLoad(EventArgs e)
{
	base.OnLoad(e);
	
	if (Convert.IsDBNull(ThisChannel[Alias.Channel.TemplatePath]))
		throw new Exception("没有邦定模板！");
	
	_channelRow = Manager.Channels.Select(Alias.Channel.ID + "='" + ThisChannel[Alias.Channel.ID] + "'")[0];
	_languageAb = _channelRow[Alias.Channel.Lang].ToString();
	_templatePath = _channelRow[Alias.Channel.TemplatePath].ToString();
}

protected string GetModuleName(DataRow record)
{
	DataRow[] rows = ModuleTable.Select(Alias.Module.ID + "='" + record[Alias.Template.Module.ModuleID] + "'");
	if( rows.Length != 0)
		return rows[0][Alias.Module.Name].ToString();
	else
		return String.Empty;
}

Guid _selectedInstanceID = Guid.Empty;
Guid _selectedChannelID = Guid.Empty;
protected StringBuilder WriteBindingInstanceOptions(DataRow record)
{
	DataRow[] rows = ExtraInstanceTable.Select(Alias.Channel.ExtraInstance.Mark + "='" + record[Alias.Template.Module.Mark] + "'");
	if (rows.Length != 0)
	{
		_selectedInstanceID = (Guid)rows[0][Alias.Channel.ExtraInstance.BindingInstanceID];
		_selectedChannelID = (Guid)rows[0][Alias.Channel.ExtraInstance.BindingChannelID];
		if (_selectedInstanceID == Guid.Empty)
			_selectedInstanceID = (Guid)Manager.Channels.Select(Alias.Channel.ID + "='" + _selectedChannelID + "'")[0][Alias.Instance.ID];
	}

	StringBuilder result = new StringBuilder();	
	rows = Manager.Instances.Select(Alias.Instance.ModuleID + "='" + record[Alias.Template.Module.ModuleID] + "'");
	foreach (DataRow row in rows)
	{
		if (Guid.Equals(row[Alias.Instance.ID], _selectedInstanceID))
			result.Append("<option value=\"" + row[Alias.Instance.ID] + "\" selected=\"selected\">" + row[Alias.Instance.Name + PageLang] + "</option>");
		else
			result.Append("<option value=\"" + row[Alias.Instance.ID] + "\">" + row[Alias.Instance.Name + PageLang] + "</option>");
	}
	
	return result;
}

protected StringBuilder WriteBindingChannelOptions(DataRow record)
{
	StringBuilder result = new StringBuilder();	
	DataRow[] rows = ChannelTable.Select(Alias.Channel.InstanceID + "='" + _selectedInstanceID + "' AND " + Alias.Channel.Lang + "='" + ThisChannel[Alias.Channel.Lang] + "'");
	foreach (DataRow r in rows)
	{
		string name = r[Alias.Channel.Name].ToString();
		DataRow parent = r;
		while (!Guid.Equals(parent[Alias.Channel.ParentID], Guid.Empty))
		{
			parent = ChannelTable.Select(Alias.Channel.ID + "='" + parent[Alias.Channel.ParentID] + "'")[0];
			name = parent[Alias.Channel.Name] + " → " + name;
		}

		if (Guid.Equals(r[Alias.Channel.ID], _selectedChannelID))
			result.Append("<option value=\"" + r[Alias.Channel.ID] + "\" selected=\"selected\">" + name + "</option>");
		else
			result.Append("<option value=\"" + r[Alias.Channel.ID] + "\">" + name + "</option>");
	}
	
	return result;
}

protected string GetExtraInstanceInnerID(DataRow record)
{
	DataRow[] rows = ExtraInstanceTable.Select(Alias.Channel.ExtraInstance.Mark + "='" + record[Alias.Template.Module.Mark] + "'");
	if (rows.Length != 0)
		return rows[0][Alias.Channel.ExtraInstance.InnerID].ToString();
	else
		return String.Empty;
}
</script>
<script type="text/javascript">
var _page = "channel_extra_instance";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _channelLang = "<%=ThisChannel[Lang]%>";
var _channelID = "<%=ThisChannel[ID]%>";
var _xmlChannel;
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
var _lang_select_channel = "请选择要邦定的栏目！";
var _lang_loading_channel_list = "正在加载栏目列表...";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<div class="Title"><a href="list.aspx?Lang=<%=ContentLang%>">栏目列表</a> → <span class="<%=ContentLang%>Font"><%=ThisChannel[Name]%></span></div>
	<div class="Right"></div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left"></li>
		<li class="Middle"><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=Request.QueryString["ID"]%>">编辑</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="change_template.aspx?Lang=<%=ContentLang%>&amp;ID=<%=Request.QueryString["ID"]%>">更换模板</a></li>
		<li class="Right"></li>
		<li class="Left Selected"></li>
		<li class="Middle Selected">栏目绑定</li>
		<li class="Right Selected"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
			<thead>
				<tr>
					<th>模板</th>
					<th>模块</th>
					<th>标志</th>
					<th>邦定的栏目</th>
					<th>设置</th>
				</tr>
			</thead>
			<tbody>
				<ilghar:List Object="Template.Module" Condition="TemplatePath=_templatePath">
					<ilghar:Record>
						<%If Convert.ToString(Mark) != ""%>
							<form>
								<tr>
									<td><%=_templatePath%></td>
									<td><%=GetModuleName(Record)%></td>
									<td><%=Mark%></td>
									<td>
										<select name="BindingInstanceID" class="<%=ContentLang%>Font">
											<option>--</option>
											<%=WriteBindingInstanceOptions(Record)%>
										</select>
										<%If !Convert.ToBoolean(JustData)%>
											<select name="BindingChannelID" class="<%=ContentLang%>Font">
												<option>--</option>
												<%=WriteBindingChannelOptions(Record)%>
											</select>
										<%EndIf%>
									</td>
									<td>
										<input type="image" src="<%=ImagePath%>modify.gif" />
										<input type="hidden" name="Mark" value="<%=Mark%>" />
										<input type="hidden" name="ID" value="<%=GetExtraInstanceInnerID(Record)%>" />
									</td>
								</tr>
							</form>
						<%EndIf%>
					</ilghar:Record>
				</ilghar:List>
			</tbody>
		</table>
	</div>
	<div class="Footer"></div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=Manager.GetModulePath(null)%><%=Instance[IlgharCMS.SystemModule.Alias.Module.Namespace]%>/alias.js"></script>
<script type="text/javascript" src="<%=CommonPath%>xmldom.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=JsPath%>system.js"></script>
</body>
</html>