﻿function BuildHeader()
{
	if (_page == "info_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "category_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsDisplay=" + $("#IsDisplay").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&Sort=" + $("#Sort").val();
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			SetStatusMessage();

			if (typeof(SetupIme) == "function")
				SetupIme();
			
			if (_page == "info_list")
			{
		        var action = "";
		        if ($("#IsRecommended")[0].selectedIndex == 2 && ($("#Sort").val() == "5" || $("#Sort").val() == "6"))
			        action = "MoveRecommend";
		        else if ($("#IsHeld")[0].selectedIndex == 2 && ($("#Sort").val() == "7" || $("#Sort").val() == "8"))
			        action = "MoveHold";
		        if (action != "")
			        g_action = action;
				
				MakeButton();
			}
			else if (_page == "category_list")
			{
				MakeButton();
			}
		}
	});
}

function MakeButton()
{
	var buttons = "";

	if (_page == "info_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateInfo('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateInfo('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateInfo('Recover')\" >" + _lang_recover + "</button>";
	    }
    	
	    //审核
	    var obj = $("#IsChecked")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateInfo('Check')\" >" + _lang_check + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateInfo('UnCheck')\" >" + _lang_uncheck + "</button>";
    	
	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateInfo('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateInfo('UnHold')\" >" + _lang_unhold + "</button>";
    	
	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateInfo('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateInfo('UnRecommend')\" >" + _lang_unrecommend + "</button>";
	}	
	else if (_page == "category_list")
	{
	    //显示
	    var obj = $("#IsDisplay")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateCategory('Display')\" >" + _lang_display + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateCategory('UnDisplay')\" >" + _lang_undisplay + "</button>";
    	
	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateCategory('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateCategory('UnHold')\" >" + _lang_unhold + "</button>";
    	
	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateCategory('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateCategory('UnRecommend')\" >" + _lang_unrecommend + "</button>";
	}
		
	$("#ExtraButton").html(buttons);
}

function ShowSelectFileDialog(type)
{
	var path = _adminPath + "IlgharCMS.SystemModule/file_manager/select.aspx?Lang=" + _lang + "&Type=" + type + "&ListByPicture=";
	switch (type)
	{
		case "Thumbnail":
			path += "true&Root=" + _thumbnailRoot;
			break;
		default:
			path += "true&Root=" + _pictureRoot;
			break;
	}
	
	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=900px;dialogHeight=600px;center=1;help=0;resizable=1;scroll=0");
	else
		window.open(path,null,"width=900,height=600,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no,modal=yes");
}

function Style_OnChange()
{
    if ($("#Custom")[0].checked)
    {
        if (this.id == "Custom")
            $("[name=CustomStyle]").show();

        return;
    }
    else
    {
        $("[name=CustomStyle]").hide();
    }

    var result = "";

    if ($("#Bold")[0].checked)
        result = "font-weight:bold";

    if ($("#Italic")[0].checked)
    {
        if (result != "")
            result += ";";

        result += "font-style:italic";
    }

    if ($.trim($("#Color").val()) != "")
    {
        if (result != "")
            result += ";";

        result += "color:" + $("#Color").val();
    }
    
    $("[name=CustomStyle]").val(result);
}

function Property_OnChange()
{
    switch (this.value)
    {
        case "RegionID":
            SetStatusMessage(_lang_working);
        	
            $.ajax(
            {
                url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=List",
                type : "GET",
                error : function(request)
                {
	                Alert(_lang_operation_fail);
	                SetStatusMessage();
                },
                success : function(data)
                {
	                _xmlDoc.loadXML(data);
	                var childNodes = _xmlDoc.documentElement.childNodes;
        			
	                var from = "<select name=\"From\" class=\"" + _lang + "Font\">";
	                var to = "<select name=\"To\" class=\"" + _lang + "Font\">";
	                for (var i = 0; i < childNodes.length; i++)
	                {
						if (typeof (childNodes[i].selectSingleNode) == "undefined")
							continue;
				
	                    var id = childNodes[i].selectSingleNode(IlgharCMS.ClassifiedsModule.Region.ID).text;
	                    var name = childNodes[i].selectSingleNode(IlgharCMS.ClassifiedsModule.Region.Name).text;
		                var option = "<option value=\"" + id + "\">" + name + "</option>";
		                from += option;
		                to += option;
	                }
	                from += "</select>";
	                to += "</select>";
        			
	                $("#FromTd").html(from);
	                $("#ToTd").html(to);
	                SetStatusMessage();
                }
            });
	        break;
        case "CategoryID":
            SetStatusMessage(_lang_working);
        	
            $.ajax(
            {
                url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=List",
                type : "GET",
                error : function(request)
                {
	                Alert(_lang_operation_fail);
	                SetStatusMessage();
                },
                success : function(data)
                {
	                _xmlDoc.loadXML(data);
	                var childNodes = _xmlDoc.documentElement.childNodes;
        			
	                var from = "<select name=\"From\" class=\"" + _lang + "Font\">";
	                var to = "<select name=\"To\" class=\"" + _lang + "Font\">";
	                for (var i = 0; i < childNodes.length; i++)
	                {
						if (typeof (childNodes[i].selectSingleNode) == "undefined")
							continue;
				
	                    var id = childNodes[i].selectSingleNode(IlgharCMS.ClassifiedsModule.Category.ID).text;
	                    var name = childNodes[i].selectSingleNode(IlgharCMS.ClassifiedsModule.Category.Name).text;
		                var option = "<option value=\"" + id + "\">" + name + "</option>";
		                from += option;
		                to += option;
	                }
	                from += "</select>";
	                to += "</select>";
        			
	                $("#FromTd").html(from);
	                $("#ToTd").html(to);
	                SetStatusMessage();
                }
            });
	        break;
        case "Title":
        case "Content":
	        $("#FromTd").html("<input type=\"text\" name=\"From\" class=\"Text " + _lang + "Font\" />");
	        $("#ToTd").html("<input type=\"text\" name=\"To\" class=\"Text " + _lang + "Font\" />");
	        break;
        default:
	        $("#FromTd").html("<input type=\"text\" name=\"From\" size=\"40\" class=\"Text\" />");
	        $("#ToTd").html("<input type=\"text\" name=\"To\" size=\"40\" class=\"Text\" />");
	        break;
    }
}

//-------------------------------------------------
//Start : 信息管理
function AddInfo()
{
	if (this.Title.value == "")
	{
		Alert(_lang_title_empty, function(){this.Title.select();}, this);
		return false;
	}

	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + form.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}
	
	var region = $("[name=RegionID] option:selected");
	var category = $("[name=CategoryID] option:selected");

	SetCookie("RegionID", region.val(), 10*360*24*60);	
	SetCookie("CategoryID", category.val(), 10*360*24*60);	
	SetCookie("MakeThumbnail", $("#MakeThumbnail")[0].checked, 10*360*24*60);
	
	_createTime = new Date();
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Title=" + encodeURIComponent(this.Title.value);
	data += "&CreateTime=" + FormatDate(_createTime, "YYYY-MM-DD hh:mm:ss.SSS");
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Content=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&QQ=" + encodeURIComponent(this.QQ.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Mobile=" + encodeURIComponent(this.Mobile.value);
	data += "&ExpirationTime=" + encodeURIComponent(this.ExpirationTime.value);
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(FormatDate(new Date(), "YYYYMMDDhhmmssSSS"));
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	data += "&HitCount=" + this.HitCount.value;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Info&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddInfo_GetInnerID();
		}
	});
	
	return false;	
}

function AddInfo_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Info&Operation=GetInnerIDFromGuid&ID=" + _guid,
		type : "GET",
		error : function(request)
		{
			Alert(_lang_innerid_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddInfo_SetPageID();
		}
	});
}

function AddInfo_SetPageID()
{
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
	_pageID = _pageID.replace(/\{ID\}/g, _id);
	_pageID = _pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	_pageID = _pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Info&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_pageID),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Info_UploadPicture();
		}
	});
}

function EditInfo()
{
	if (this.Title.value == "")
	{
		Alert(_lang_title_empty, function(){this.Title.select();}, this);
		return false;
	}

	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + form.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.UpdateTime.value))
	{
	    Alert(_lang_update_time_incorrect, function(){this.UpdateTime.select();}, this);
		return false;
	}
	
	var region = $("[name=RegionID] option:selected");
	var category = $("[name=CategoryID] option:selected");
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	pageID = pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	pageID = pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));
	
	var data = "Title=" + encodeURIComponent(this.Title.value);
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Content=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&QQ=" + encodeURIComponent(this.QQ.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Mobile=" + encodeURIComponent(this.Mobile.value);
	data += "&ExpirationTime=" + encodeURIComponent(this.ExpirationTime.value);
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	data += "&UpdateTime=" + encodeURIComponent(this.UpdateTime.value);
	data += "&HitCount=" + this.HitCount.value;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Info&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Info_UploadPicture();
		}
	});
	
	return false;
}

function Info_UploadPicture()
{
    if (!_uploadPicture)
    {
        Info_UploadThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_picture);
    _uploader.Init({Status:_lang_uploading_picture,Params:"Lang=" + _lang + "&Object=Info&Operation=UploadPicture&ID=" + _id + "&MakeThumbnail=" + $("#MakeThumbnail")[0].checked + "&AddWaterMark=" + $("#AddWaterMarkToPicture")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Info_UploadThumbnail();
    	}
    });
}

function Info_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Lang=" + _lang + "&Object=Info&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToThumbnail")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function UpdateInfo(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateInfo(action, id);}, this);
		else
			UpdateInfo(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Info&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
			}
		});
	}
}

function MoveInfo(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Info&Operation=" + g_action + "&From=" + from + "&To=" + to + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
		}
	});
}

function ReplaceInfo()
{
	if (this.From.type == "text" && this.From.value == "")
	{
		Alert(_lang_from_empty, function(){this.From.select();}, this);
		return false;
	}
	
	var data = "Property=" + this.Property.value;
	data += "&From=" + encodeURIComponent(this.From.value);
	data += "&To=" + encodeURIComponent(this.To.value);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Info&Operation=Replace",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}
//End : 信息管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 类别管理
function AddCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(FormatDate(new Date(), "YYYYMMDDhhmmssSSS"));
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddCategory_GetInnerID();
		}
	});
	
	return false;	
}

function AddCategory_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddCategory_SetPageID();
		}
	});
}

function AddCategory_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Category_UploadPicture();
		}
	});
}

function Category_UploadPicture()
{
    if (!_uploadPicture)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Category&Operation=UploadPicture&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function EditCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Category_UploadPicture();
		}
	});
	
	return false;	
}

function ModifyCategory(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteCategory(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}

function MoveCategory(from, to)
{
	if (from == to)
		return;
	
	var action = "Move";
	var sort = $("#Sort").val();
	if (sort == "2" || sort == "3")
	    action = "MoveRecommend";
	else if (sort == "4" || sort == "5")
	    action = "MoveHold";

	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=" + action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function UpdateCategory(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}

		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateCategory(action, id);}, this);
		else
			UpdateCategory(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Category&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));	
			}
		});
	}
}
//End：类别管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 区域管理
function AddRegion()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";
	
	var data = "ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(FormatDate(new Date(), "YYYYMMDDhhmmssSSS"));
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);

	$(":submit").attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			 _guid = data;
			AddRegion_GetInnerID();
		}
	});
	
	return false;	
}

function AddRegion_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddRegion_SetPageID();
		}
	});
}
function AddRegion_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function EditRegion()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	
	var data = "ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);

	$(":submit").attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function ModifyRegion(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteRegion(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}

function MoveRegion(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}
//End : 区域管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 栏目设置
function SetBasicSettings()
{
	if (this.InfoThumbnailFolder.value.length > 0 && this.InfoThumbnailFolder.value.indexOf("/") != 0)
	{
		Alert(_lang_thumbnail_folder_starts_slash, function(){this.ThumbnailFolder.select();}, this);
		return false;
	}
	
	if (this.InfoPictureFolder.value.length > 0 && this.InfoPictureFolder.value.indexOf("/") != 0)
	{
		Alert(_lang_picture_folder_starts_slash, function(){this.PictureFolder.select();}, this);
		return false;
	}
	
	if (!this.InfoThumbnailWidth.value.match(/^\d*$/))
	{
		Alert(_lang_thumbnail_width_incorrect, function(){this.ThumbnailWidth.select();}, this);
		return false;
	}	
	
	if (!this.InfoThumbnailHeight.value.match(/^\d*$/))
	{
		Alert(_lang_thumbnail_height_incorrect, function(){this.ThumbnailHeight.select();}, this);
		return false;
	}	
	
	var data = "&InfoThumbnailFolder=" +  encodeURIComponent(this.InfoThumbnailFolder.value);
	data += "&InfoPictureFolder=" +  encodeURIComponent(this.InfoPictureFolder.value);
	data += "&InfoThumbnailWidth=" + this.InfoThumbnailWidth.value;
	data += "&InfoThumbnailHeight=" + this.InfoThumbnailHeight.value;
	data += "&EnableComment=" + this.EnableComment.checked;
	data += "&CheckComment=" + this.CheckComment.checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=InstanceConfig&Operation=SetBasicSettings",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}
//End : 栏目设置
//-------------------------------------------------

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "info_add")
	{
	    var form = $("form")[0];
	    CheckAndSelect(form.RegionID, GetCookie("RegionID"));
	    CheckAndSelect(form.CategoryID, GetCookie("CategoryID"));
    	
	    if (GetCookie("MakeThumbnail") == "false")
	    {
		    $("#MakeThumbnail")[0].checked = false;
		    $("#ThumbnailRow").show();
	    }
	    else
	    {
		    $("#MakeThumbnail")[0].checked = true;
		    $("#ThumbnailRow").hide();
		}

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
		
		$("form:first").submit(AddInfo);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		$("[name=ExpirationTime]").focus(function(){new DatePicker(this);});
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "info_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;
				
		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
		
		$("form:first").submit(EditInfo);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		$("[name=ExpirationTime]").focus(function(){new DatePicker(this);});
		$("#Now").click(function(){$("[name=UpdateTime]").val(FormatDate(new Date(), "YYYY-MM-DD hh:mm:ss"));return false;});
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "info_list")
	{
		MakeButton();
		
		var list = $("#List");

		list.delegate("[sort]", "mouseover", function(){this.className += " Move_MouseOver";});
		list.delegate("[sort]", "mouseout", function(){this.className="Move";});
		
		CheckAndSelect($("#KeywordType")[0], _keywordType);
		InitMove(null, "Move", null, MoveInfo);
		
		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "info_replace")
	{
		_xmlDoc = CreateXmlDom();

		$("form").submit(ReplaceInfo);
		$("[name=Property]").change(Property_OnChange);
	}
	else if (_page == "category_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form:first").submit(AddCategory);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "category_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;
		
		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}

		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form:first").submit(EditCategory);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "category_list")
	{
		MakeButton();

		var list = $("#List");

		list.delegate("form", "submit", function()
		{
			var id = $(this).parent().attr("ItemID");
			ModifyCategory(this, id);
			return false;
		});
		
		list.delegate("[sort]", "mouseover", function(){this.className += " Move_MouseOver";});
		list.delegate("[sort]", "mouseout", function(){this.className="Move";});
		
		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("ItemID");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteCategory(id);}, this);
			return false;
		});

		InitMove(null,"Move", null, MoveCategory);
		
		$("#IsDisplay,#IsRecommended,#IsHeld,#Sort").change(Search);
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "region_add")
	{
		$("form").submit(AddRegion);
	}
	else if (_page == "region_edit")
	{
		$("form").submit(EditRegion);
	}
	else if (_page == "region_list")
	{
		var list = $("table");

		list.delegate("form", "submit", function()
		{
			var id = $(this).closest("tr").attr("ItemID");
			ModifyRegion(this, id);
			return false;
		});
		
		list.delegate("[sort]", "mouseover", function(){this.className += " Move_MouseOver";});
		list.delegate("[sort]", "mouseout", function(){this.className="Move";});
		
		list.delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("ItemID");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteRegion(id);}, this);
			return false;
		});
		
		InitMove(null,"Move", null, MoveRegion);
	}
	else if (_page == "config_basic")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("DefaultThumbnail", "DefaultThumbnailTextbox", "DefaultThumbnailBrowse");

		$("form:first").submit(SetBasicSettings);
	}
}
Init();