﻿function BuildHeader()
{
	if (_page == "movie_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&RegionID=" + $("#RegionID").val() + "&IncludeSubRegion=" + $("#IncludeSubRegion")[0].checked + "&LanguageID=" + $("#LanguageID").val() + "&CategoryID=" + $("#CategoryID").val() + "&IncludeSubCategory=" + $("#IncludeSubCategory")[0].checked + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&ListByPicture=" + $("#ListByPicture")[0].checked + "&Page=" + _pageNumber;
	else if (_page == "company_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "movie_url_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&MovieID=" + _movieInnerID + ($("[name=CategoryID]")[0].selectedIndex == 0 ? "" : "&CategoryID=" + $("[name=CategoryID]").val());
	else if (_page == "movie_comment_list" || _page == "person_comment_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsChecked=" + $("#IsChecked").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "person_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&RegionID=" + $("#RegionID").val() + "&IncludeSubRegion=" + $("#IncludeSubRegion")[0].checked + "&LanguageID=" + $("#LanguageID").val() + "&SexID=" + $("#SexID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&ListByPicture=" + $("#ListByPicture")[0].checked + "&Page=" + _pageNumber;
	else if (_page == "tag_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "tag_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "person_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&RegionID=" + $("#RegionID").val() + "&IncludeSubRegion=" + $("#IncludeSubRegion")[0].checked + "&LanguageID=" + $("#LanguageID").val() + "&SexID=" + $("#SexID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "movie_category_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsDisplay=" + $("#IsDisplay").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&Sort=" + $("#Sort").val();
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
		    if (_page == "movie_comment_list" || _page == "person_comment_list")
			    $("#RecordList").html(HandleFake404(data, "text"));
			else
			    $("#List").html(HandleFake404(data, "text"));
			Init();
			SetStatusMessage();

			if (typeof(SetupIme) == "function")
				SetupIme();
			
			if (_page == "movie_list" || _page == "person_list")
			{
		        var action = "";
		        if ($("#IsRecommended")[0].selectedIndex == 2 && ($("#Sort").val() == "5" || $("#Sort").val() == "6"))
			        action = "MoveRecommend";
		        else if ($("#IsHeld")[0].selectedIndex == 2 && ($("#Sort").val() == "7" || $("#Sort").val() == "8"))
			        action = "MoveHold";
		        if (action != "")
			        g_action = action;
			}
		}
	});
}

function MakeButton()
{
	var buttons = "";
	
	if (_page == "movie_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateMovie('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateMovie('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateMovie('Recover')\" >" + _lang_recover + "</button>";
	    }
    	
	    //审核
	    var obj = $("#IsChecked")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMovie('Check')\" >" + _lang_check + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMovie('UnCheck')\" >" + _lang_uncheck + "</button>";
    	
	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMovie('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMovie('UnRecommend')\" >" + _lang_unrecommend + "</button>";
    	
	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMovie('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMovie('UnHold')\" >" + _lang_unhold + "</button>";
	}
	if (_page == "person_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Recover')\" >" + _lang_recover + "</button>";
	    }
    	
	    //审核
	    var obj = $("#IsChecked")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Check')\" >" + _lang_check + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('UnCheck')\" >" + _lang_uncheck + "</button>";
    	
	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('UnRecommend')\" >" + _lang_unrecommend + "</button>";
    	
	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('UnHold')\" >" + _lang_unhold + "</button>";
	}
	else if (_page == "movie_comment_list")
	{	
		if ($("#IsChecked")[0].selectedIndex == 1)
			buttons += "<button class=\"Button\" onclick=\"UpdateMovieComment('Check')\" >" + _lang_check + "</button>";
		else if ($("#IsChecked")[0].selectedIndex == 2)
			buttons += "<button class=\"Button\" onclick=\"UpdateMovieComment('UnCheck')\" >" + _lang_uncheck + "</button>";
	}
	else if (_page == "person_comment_list")
	{	
		if ($("#IsChecked")[0].selectedIndex == 1)
			buttons += "<button class=\"Button\" onclick=\"UpdatePersonComment('Check')\" >" + _lang_check + "</button>";
		else if ($("#IsChecked")[0].selectedIndex == 2)
			buttons += "<button class=\"Button\" onclick=\"UpdatePersonComment('UnCheck')\" >" + _lang_uncheck + "</button>";
	}
    else if (_page == "movie_category_list")
    {
        //显示
        var obj = $("#IsDisplay")[0];
        if (obj.selectedIndex == 1)
            buttons += "<button class=\"Button\" onclick=\"UpdateMovieCategory('Display')\" >" + _lang_display + "</button>";
        else if (obj.selectedIndex == 2)
            buttons += "<button class=\"Button\" onclick=\"UpdateMovieCategory('UnDisplay')\" >" + _lang_undisplay + "</button>";

        //置顶
        var obj = $("#IsHeld")[0];
        if (obj.selectedIndex == 1)
            buttons += "<button class=\"Button\" onclick=\"UpdateMovieCategory('Hold')\" >" + _lang_hold + "</button>";
        else if (obj.selectedIndex == 2)
            buttons += "<button class=\"Button\" onclick=\"UpdateMovieCategory('UnHold')\" >" + _lang_unhold + "</button>";

        //推荐
        var obj = $("#IsRecommended")[0];
        if (obj.selectedIndex == 1)
            buttons += "<button class=\"Button\" onclick=\"UpdateMovieCategory('Recommend')\" >" + _lang_recommend + "</button>";
        else if (obj.selectedIndex == 2)
            buttons += "<button class=\"Button\" onclick=\"UpdateMovieCategory('UnRecommend')\" >" + _lang_unrecommend + "</button>";
    }

	$("#ExtraButton").html(buttons);
}

function ShowSelectFileDialog(type)
{
	var path = _adminPath + "IlgharCMS.SystemModule/file_manager/select.aspx?Lang=" + _lang + "&Type=" + type + "&ListByPicture=";
	switch (type)
	{
		case "Picture":
			path += "true&Root=" + _pictureRoot;
			break;
		case "Thumbnail":
			path += "true&Root=" + _thumbnailRoot;
			break;
		case "URL":
			path += "false&Root=" + _urlRoot;
			break;
		case "Download":
			path += "false&Root=" + _downloadRoot;
			break;
	}
	
	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=900px;dialogHeight=600px;center=1;help=0;resizable=1;scroll=0");
	else
		window.open(path,null,"width=900,height=600,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no,modal=yes");
}

function ShowSelectDialog(type)
{
	var path;
	if (type == "Tag")
		path = "../tag/select.aspx?Lang=" + _lang;
	else if (type == "Actor" || type == "Director")
		path = "../person/select.aspx?Lang=" + _lang + "&Type=" + type;

	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=500px;dialogHeight=500px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=500,height=500,dialog=yes,modal=yes,maximize=no,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no");
}

function SelectFile(type, path)
{
	var form = document.forms[0];
	switch (type)
	{
		case "Picture":
			form.Picture.value = path;
			$("#PictureView").attr("src", path);
			break;
		case "Thumbnail":
			form.Thumbnail.value = path;
			$("#ThumbnailView").attr("src", path);
			break;
		case "URL":
		    if (_page == "movie_url_edit")
    			form.URL.value = path;
    		else
    			form.UrlTemplate.value = path;
			break;
		case "Download":
		    if (_page == "movie_url_edit")
    			form.Download.value = path;
    		else
    			form.DownloadTemplate.value = path;
			break;
	}	
}

function SelectTag(tag, checked)
{
	var tags = $("[name=Tag]");
	for (var i = 0; i < tags.length; i++)
	{
		if (tags[i].id == tag.ID)
		{
			tags[i].checked = checked;
			return;
		}
	}
	
	var tagContainer = $("#TagDiv");
	var br = "";
	if (tags.length > 0 && tags.length % 5 == 0) br = "<br />";
	tagContainer.html(tagContainer.html() + br + "<input type='checkbox' checked='checked' name='Tag' id='" + tag.ID + "' value='" + tag.Name + "' PageGenerate='" + tag.PageGenerate + "' PageTemplate='" + tag.PageTemplate + "'' PageID='" + tag.PageID + "'' PageExtension='" + tag.PageExtension + "' /><label class='" + _lang + "Font' for='" + tag.ID + "'>" + tag.Name + "</label>");
}

function SelectPerson(person, checked, type)
{
	var persons = $("[name=" + type + "]");
	for (var i = 0; i < persons.length; i++)
	{
		if (persons[i].id == person.ID)
		{
			persons[i].checked = checked;
			return;
		}
	}
	
	var personContainer = $("#" + type + "Div");
	var br = "";
	if (persons.length > 0 && persons.length % 5 == 0) br = "<br />";
	personContainer.html(personContainer.html() + br + "<input type='checkbox' checked='checked' name='" + type + "' id='" + person.ID + "' value='" + person.Name + "' PageGenerate='" + person.PageGenerate + "' PageTemplate='" + person.PageTemplate + "'' PageID='" + person.PageID + "'' PageExtension='" + person.PageExtension + "' /><label class='" + _lang + "Font' for='" + person.ID + "'>" + person.Name + "</label>");
}

function PrepareTag()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var tags = $("[name=Tag]");
	
	if (typeof(_tagIndex) != "undefined")
	{
	    _tagIndex = 0;
	}
	else
	{
	    _tagAddIndex = 0;
	    _tagDeleteIndex = 0;
	    _tagAddList.length = 0;
	    _tagDeleteList.length = 0;
    	    	
	    tags.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
					    break;
			    }
			    if (j >= _tags.length)
				    _tagAddList[_tagAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
				    {
					    _tagDeleteList[_tagDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_tags.length = 0;
	tags.each(function()
	{
		if (!this.checked)
		    return false;

		_tags[_tags.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

function PrepareActor()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var actors = $("[name=Actor]");
	
	if (typeof(_actorIndex) != "undefined")
	{
	    _actorIndex = 0;
	}
	else
	{
	    _actorAddIndex = 0;
	    _actorDeleteIndex = 0;
	    _actorAddList.length = 0;
	    _actorDeleteList.length = 0;
    	    	
	    actors.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _actors.length; j++)
			    {
				    if (this.id == _actors[j] || this.id == _actors[j].ID)
					    break;
			    }
			    if (j >= _actors.length)
				    _actorAddList[_actorAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _actors.length; j++)
			    {
				    if (this.id == _actors[j] || this.id == _actors[j].ID)
				    {
					    _actorDeleteList[_actorDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_actors.length = 0;
	actors.each(function()
	{
		if (!this.checked)
		    return false;

		_actors[_actors.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

function PrepareDirector()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var directors = $("[name=Director]");
	
	if (typeof(_directorIndex) != "undefined")
	{
	    _directorIndex = 0;
	}
	else
	{
	    _directorAddIndex = 0;
	    _directorDeleteIndex = 0;
	    _directorAddList.length = 0;
	    _directorDeleteList.length = 0;
    	    	
	    directors.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _directors.length; j++)
			    {
				    if (this.id == _directors[j] || this.id == _directors[j].ID)
					    break;
			    }
			    if (j >= _directors.length)
				    _directorAddList[_directorAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _directors.length; j++)
			    {
				    if (this.id == _directors[j] || this.id == _directors[j].ID)
				    {
					    _directorDeleteList[_directorDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_directors.length = 0;
	directors.each(function()
	{
		if (!this.checked)
		    return false;

		_directors[_directors.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

function Style_OnChange()
{
    if ($("#Custom")[0].checked)
    {
        if (this.id == "Custom")
            $("[name=CustomStyle]").show();

        return;
    }
    else
    {
        $("[name=CustomStyle]").hide();
    }

    var result = "";

    if ($("#Bold")[0].checked)
        result = "font-weight:bold";

    if ($("#Italic")[0].checked)
    {
        if (result != "")
            result += ";";

        result += "font-style:italic";
    }

    if ($.trim($("#Color").val()) != "")
    {
        if (result != "")
            result += ";";

        result += "color:" + $("#Color").val();
    }
    
    $("[name=CustomStyle]").val(result);
}

//-------------------------------------------------
//Start : 类别管理
function UpdateMovieCategory(action, id)
{
    if (id == null)
    {
        id = "";
        $("[name=Sel]:checked").each(function () { id += id == "" ? this.value : "|" + this.value; });
        if (id == "")
        {
            Alert(_lang_selection_empty);
            return;
        }

        if (action == "Delete")
            Confirm(_lang_confirm_delete, function (returnValue) { if (returnValue) UpdateMovieCategory(action, id); }, this);
        else
            UpdateMovieCategory(action, id);
    }
    else
    {
        SetStatusMessage(_lang_working);

        $.ajax(
		{
		    url: _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MovieCategory&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		    data: {},
		    type: "POST",
		    error: function (request)
		    {
		        Alert(_lang_operation_fail);
		        SetStatusMessage();
		    },
		    success: function (data)
		    {
		        Alert(_lang_operation_success);
		        SetStatusMessage();

		        $("#List").html(HandleFake404(data, "text"));
		        Init();
		    }
		});
    }
}

function AddMovieCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MovieCategory&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddMovieCategory_GetInnerID();
		}
	});
	
	return false;	
}

function AddMovieCategory_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MovieCategory&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddMovieCategory_SetPageID();
		}
	});
}

function AddMovieCategory_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MovieCategory&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			MovieCategory_UploadPicture();
		}
	});
}

function EditMovieCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MovieCategory&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    MovieCategory_UploadPicture();
		}
	});
	
	return false;	
}

function MovieCategory_UploadPicture()
{
    if (!_uploadPicture)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=MovieCategory&Operation=UploadPicture&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function MoveMovieCategory(from, to)
{
	if (from == to)
		return;
	
	var action = "Move";
	var sort = $("#Sort").val();
	if (sort == "2" || sort == "3")
	    action = "MoveRecommend";
	else if (sort == "4" || sort == "5")
	    action = "MoveHold";

	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MovieCategory&Operation=" + action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function ModifyMovieCategory(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MovieCategory&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteMovieCategory(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MovieCategory&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}
//End : 类别管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 标签管理
function AddTag()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddTag_GetInnerID();
		}
	});
	
	return false;	
}

function AddTag_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddTag_SetPageID();
		}
	});
}

function AddTag_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function ModifyTag(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditTag()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteTag()
{
	var id = GetChecked("Sel");
	if(id == "")
	{
		Alert(_lang_no_selection);
		return;
	}
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			$("#List").html(HandleFake404(data, "text"));
			Init();

			if (typeof(SetupIme) == "function")
				SetupIme();			
		}
	});
}	
//End : 标签管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 地区管理
function AddRegion()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit").attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit").attr("disabled", false);
		},
		success : function(data)
		{
		    _guid = data;
	        AddRegion_GetInnerID();
		}
	});
	
	return false;	
}

function AddRegion_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddRegion_SetPageID();
		}
	});
}

function AddRegion_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function EditRegion()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)

	var data = "ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit").attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit").attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function ModifyRegion(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteRegion(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}

function MoveRegion(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}
//End : 地区管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 公司管理
function AddCompany()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.FoundedDate.value != "")
	{
		var regx = /^((\d{4})|(\d{4}-\d{2})|(\d{4}-\d{2}-\d{2}))$/;
		if (!regx.test(this.FoundedDate.value))
		{
		    Alert(_lang_founded_date_incorrect, function(){this.FoundedDate.select();}, this);
			return false;
		}
	}
	
	if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
	{
		Alert(_lang_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&FoundedDate=" + encodeURIComponent(this.FoundedDate.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Address=" + encodeURIComponent(this.Address.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	_uploadLogo = _uploader.NeedUpload("Logo");
	if (!_uploadLogo)
		data += "&Logo=" + encodeURIComponent(this.Logo.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Company&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddCompany_GetInnerID();
		}
	});
	
	return false;
}

function AddCompany_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Company&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddCompany_SetPageID();
		}
	});
}

function AddCompany_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Company&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Company_UploadLogo();

		}
	});
}

function EditCompany()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
	{
		Alert(_lang_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&FoundedDate=" + encodeURIComponent(this.FoundedDate.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Address=" + encodeURIComponent(this.Address.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	_uploadLogo = _uploader.NeedUpload("Logo");
	if (!_uploadLogo)
		data += "&Logo=" + encodeURIComponent(this.Logo.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Company&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Company_UploadLogo();
		}
	});
	
	return false;	
}

function Company_UploadLogo()
{
    if (!_uploadLogo)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Company&Operation=UploadLogo&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Logo", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function DeleteCompany(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Company&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}
//End : 公司管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 栏目设置
function SetBasicSettings()
{
	if (this.PlayFolder.value.length > 0 && this.PlayFolder.value.indexOf("/") != 0)
	{
		Alert(_lang_play_folder_starts_slash, function(){this.PlayFolder.select();}, this);
		return false;
	}
	
	if (this.DownloadFolder.value.length > 0 && this.DownloadFolder.value.indexOf("/") != 0)
	{
		Alert(_lang_download_folder_starts_slash, function(){this.DownloadFolder.select();}, this);
		return false;
	}
	
	if (!this.MovieThumbnailWidth.value.match(/^\d*$/))
	{
		Alert(_lang_movie_thumbnail_width_incorrect, function(){this.MovieThumbnailWidth.select();}, this);
		return false;
	}	
	
	if (!this.MovieThumbnailHeight.value.match(/^\d*$/))
	{
		Alert(_lang_movie_thumbnail_height_incorrect, function(){this.MovieThumbnailHeight.select();}, this);
		return false;
	}	
	
	if (!this.PersonThumbnailWidth.value.match(/^\d*$/))
	{
		Alert(_lang_person_thumbnail_width_incorrect, function(){this.PersonThumbnailWidth.select();}, this);
		return false;
	}	
	
	if (!this.PersonThumbnailHeight.value.match(/^\d*$/))
	{
		Alert(_lang_person_thumbnail_height_incorrect, function(){this.PersonThumbnailHeight.select();}, this);
		return false;
	}	
	
	if (!IsAllowedType(this.MovieDefaultThumbnail.value, this.MovieDefaultThumbnailAllowedType.value))
	{
		Alert(_lang_movie_type_must_be + this.MovieDefaultThumbnailAllowedType.value, function(){this.MovieDefaultThumbnail.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.PersonDefaultThumbnail.value, this.PersonDefaultThumbnailAllowedType.value))
	{
		Alert(_lang_person_type_must_be + this.PersonDefaultThumbnailAllowedType.value, function(){this.PersonDefaultThumbnail.select();}, this);
		return false;
	}
	
	var data = "FirstLetter=" + encodeURIComponent(this.FirstLetter.value);
	data += "&PlayFolder=" +  encodeURIComponent(this.PlayFolder.value);
	data += "&DownloadFolder=" +  encodeURIComponent(this.DownloadFolder.value);
	data += "&MovieThumbnailFolder=" +  encodeURIComponent(this.MovieThumbnailFolder.value);
	data += "&MoviePictureFolder=" +  encodeURIComponent(this.MoviePictureFolder.value);
	data += "&PersonThumbnailFolder=" +  encodeURIComponent(this.PersonThumbnailFolder.value);
	data += "&PersonPictureFolder=" +  encodeURIComponent(this.PersonPictureFolder.value);
	data += "&MovieThumbnailWidth=" + this.MovieThumbnailWidth.value;
	data += "&MovieThumbnailHeight=" + this.MovieThumbnailHeight.value;
	data += "&PersonThumbnailWidth=" + this.PersonThumbnailWidth.value;
	data += "&PersonThumbnailHeight=" + this.PersonThumbnailHeight.value;
	data += "&EnableComment=" + this.EnableComment.checked;
	data += "&CheckComment=" + this.CheckComment.checked;
	_uploadMovieDefaultThumbnail = _uploader.NeedUpload("Movie");
	if (!_uploadMovieDefaultThumbnail)
		data += "&MovieDefaultThumbnail=" + encodeURIComponent(this.MovieDefaultThumbnail.value);
	_uploadPersonDefaultThumbnail = _uploader.NeedUpload("Person");
	if (!_uploadPersonDefaultThumbnail)
		data += "&PersonDefaultThumbnail=" + encodeURIComponent(this.PersonDefaultThumbnail.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=InstanceConfig&Operation=SetBasicSettings",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    SetBasicSettings_UploadMovieDefaultThumbnail();
		}
	});
	
	return false;	
}

function SetBasicSettings_UploadMovieDefaultThumbnail()
{
    if (!_uploadMovieDefaultThumbnail)
    {
		SetBasicSettings_UploadPersonDefaultThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_movie);
    _uploader.Init({Status:_lang_uploading_movie,Params:"Lang=" + _lang + "&Object=InstanceConfig&Operation=UploadMovieDefaultThumbnail"});
    _uploader.Upload("Movie", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		SetBasicSettings_UploadPersonDefaultThumbnail();
    	}
    });
}

function SetBasicSettings_UploadPersonDefaultThumbnail()
{
    if (!_uploadPersonDefaultThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload_person);
    _uploader.Init({Status:_lang_uploading_person,Params:"Lang=" + _lang + "&Object=InstanceConfig&Operation=UploadPersonDefaultThumbnail"});
    _uploader.Upload("Person", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function CreateAllMovieThumbnail()
{
    var me = $(this);
	me.attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie&Operation=CreateAllThumbnail",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			me.attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			me.attr("disabled", false);
		}
	});
	
	return false;	
}

function CreateAllPersonThumbnail()
{
    var me = $(this);
	me.attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=CreateAllThumbnail",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			me.attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			me.attr("disabled", false);
		}
	});
	
	return false;	
}

function CreateAllPackFile()
{
    var me = $(this);
	me.attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Url&Operation=CreateAllPackFile",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			me.attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			me.attr("disabled", false);
		}
	});
	
	return false;	
}
//End : 栏目设置
//-------------------------------------------------

//-------------------------------------------------
//Start : 语言管理
function AddLanguage()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddLanguage_GetInnerID();
		}
	});
	
	return false;
}

function AddLanguage_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddLanguage_SetPageID();
		}
	});
}

function AddLanguage_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function EditLanguage()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function ModifyLanguage(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteLanguage(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}	
//End : 语言管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 电影管理
function AddMovie()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.Premiere.value != "")
	{
		var regx = /^((\d{4})|(\d{4}-\d{2})|(\d{4}-\d{2}-\d{2}))$/;
		if (!regx.test(this.Premiere.value))
		{
		    Alert(_lang_premiere_incorrect, function(){this.Premiere.select();}, this);
			return false;
		}
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	if (!this.Error.value.match(/^\d+$/))
	{
		Alert(_lang_error_incorrect, function(){this.Error.select();}, this);
		return false;
	}
	
	_urlIndex = 0;
	_urlTable = $("#UrlTable tbody")[0];

	var tag = PrepareTag();
	var actor = PrepareActor();
	var director = PrepareDirector();

	var category = $("[name=CategoryID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");
	var company = $("[name=CompanyID] option:selected");

	SetCookie("CategoryID", category.val(), 10*360*24*60);	
	SetCookie("RegionID", region.val(), 10*360*24*60);	
	SetCookie("LanguageID", language.val(), 10*360*24*60);	
	SetCookie("MakeThumbnail", $("#MakeThumbnail")[0].checked, 10*360*24*60);
		
	_createTime = new Date();
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&CreateTime=" + FormatDate(_createTime, "YYYY-MM-DD hh:mm:ss.SSS");
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&CompanyID=" + this.CompanyID.value;
	data += "&CompanyName=" + company.attr("Name");
	data += "&CompanyPageGenerate=" + company.attr("PageGenerate");
	data += "&CompanyPageTemplate=" + company.attr("PageTemplate");
	data += "&CompanyPageID=" + company.attr("PageID");
	data += "&CompanyPageExtension=" + company.attr("PageExtension");
	data += "&Premiere=" + this.Premiere.value;
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&Error=" + this.Error.value;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&ActorNames=" + encodeURIComponent(actor.Names);
	data += "&ActorPageGenerates=" + encodeURIComponent(actor.PageGenerates);
	data += "&ActorPageTemplates=" + encodeURIComponent(actor.PageTemplates);
	data += "&ActorPageIDs=" + encodeURIComponent(actor.PageIDs);
	data += "&ActorPageExtensions=" + encodeURIComponent(actor.PageExtensions);
	data += "&DirectorNames=" + encodeURIComponent(director.Names);
	data += "&DirectorPageGenerates=" + encodeURIComponent(director.PageGenerates);
	data += "&DirectorPageTemplates=" + encodeURIComponent(director.PageTemplates);
	data += "&DirectorPageIDs=" + encodeURIComponent(director.PageIDs);
	data += "&DirectorPageExtensions=" + encodeURIComponent(director.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddMovie_GetInnerID();
		}
	});
	
	return false;	
}

function AddMovie_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddMovie_SetPageID();
		}
	});
}

function AddMovie_SetPageID()
{
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
	_pageID = _pageID.replace(/\{ID\}/g, _id);
	_pageID = _pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	_pageID = _pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_pageID),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		AddMovie_AddTag();
		}
	});
}

function AddMovie_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		AddMovie_AddActor();
		return;
	}
	
	var data = "MovieID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

    SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddMovie_AddTag();
		}
	});
}

function AddMovie_AddActor()
{
	if (_actorIndex >= _actors.length)
	{
		AddMovie_AddDirector();
		return;
	}
	
	var data = "MovieID=" + _guid;
	data += "&ActorID=" + _actors[_actorIndex];
	
	_actorIndex++;

    SetStatusMessage(_lang_adding_actor);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Actor&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddMovie_AddActor();
		}
	});
}

function AddMovie_AddDirector()
{
	if (_directorIndex >= _directors.length)
	{
		AddMovie_AddUrl();
		return;
	}
	
	var data = "MovieID=" + _guid;
	data += "&DirectorID=" + _directors[_directorIndex];
	
	_directorIndex++;

    SetStatusMessage(_lang_adding_director);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Director&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddMovie_AddDirector();
		}
	});
}

function AddMovie_AddUrl()
{
	if (_urlIndex >= _urlTable.rows.length)
	{
		Movie_UploadPicture();
		return;
	}
	
	var urlCategoryID = _urlTable.rows[_urlIndex].cells[0].childNodes[0].value;
	var name = _urlTable.rows[_urlIndex].cells[1].childNodes[0].value;
	var url = _urlTable.rows[_urlIndex].cells[2].childNodes[0].value;
	var playerID = _urlTable.rows[_urlIndex].cells[3].childNodes[0].value;
	
	_urlIndex++;
	if (name == "" || url == "")
	{
		AddMovie_AddUrl();
		return;
	}
	
	var data = "MovieID=" + _guid;
	data += "&CategoryID=" + urlCategoryID;
	data += "&Name=" + encodeURIComponent(name);
	data += "&Url=" + encodeURIComponent(url);
	data += "&PlayerID=" + playerID;
	
    SetStatusMessage(_lang_adding_url);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Url&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddMovie_AddUrl();
		}
	});
}

function EditMovie()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}

	if (this.Premiere.value != "")
	{
		var regx = /^((\d{4})|(\d{4}-\d{2})|(\d{4}-\d{2}-\d{2}))$/;
		if (!regx.test(this.Premiere.value))
		{
		    Alert(_lang_premiere_incorrect, function(){this.Premiere.select();}, this);
			return false;
		}
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	if (!this.Error.value.match(/^\d+$/))
	{
		Alert(_lang_error_incorrect, function(){this.Error.select();}, this);
		return false;
	}
	
	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.UpdateTime.value))
	{
	    Alert(_lang_update_time_incorrect, function(){this.UpdateTime.select();}, this);
		return false;
	}

	var tag = PrepareTag();
	var actor = PrepareActor();
	var director = PrepareDirector();
	
	var category = $("[name=CategoryID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");
	var company = $("[name=CompanyID] option:selected");

	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	pageID = pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	pageID = pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

	var data = "Name=" + encodeURIComponent(this.Name.value);
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&CompanyID=" + this.CompanyID.value;
	data += "&CompanyName=" + company.attr("Name");
	data += "&CompanyPageGenerate=" + company.attr("PageGenerate");
	data += "&CompanyPageTemplate=" + company.attr("PageTemplate");
	data += "&CompanyPageID=" + company.attr("PageID");
	data += "&CompanyPageExtension=" + company.attr("PageExtension");
	data += "&Premiere=" + this.Premiere.value;
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&Error=" + this.Error.value;
	data += "&UpdateTime=" + this.UpdateTime.value;
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&ActorNames=" + encodeURIComponent(actor.Names);
	data += "&ActorPageGenerates=" + encodeURIComponent(actor.PageGenerates);
	data += "&ActorPageTemplates=" + encodeURIComponent(actor.PageTemplates);
	data += "&ActorPageIDs=" + encodeURIComponent(actor.PageIDs);
	data += "&ActorPageExtensions=" + encodeURIComponent(actor.PageExtensions);
	data += "&DirectorNames=" + encodeURIComponent(director.Names);
	data += "&DirectorPageGenerates=" + encodeURIComponent(director.PageGenerates);
	data += "&DirectorPageTemplates=" + encodeURIComponent(director.PageTemplates);
	data += "&DirectorPageIDs=" + encodeURIComponent(director.PageIDs);
	data += "&DirectorPageExtensions=" + encodeURIComponent(director.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMovie_DeleteTag();
		}
	});

	return false;
}

function EditMovie_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditMovie_AddTag();
		return;
	}

	SetStatusMessage(_lang_modifying_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Tag&Operation=Delete&MovieID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMovie_DeleteTag();
		}
	});
}

function EditMovie_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
        EditMovie_DeleteActor();
		return;
	}
	
	var data = "MovieID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMovie_AddTag();
		}
	});
}

function EditMovie_DeleteActor()
{
	if (_actorDeleteIndex >= _actorDeleteList.length)
	{
		EditMovie_AddActor();
		return;
	}

	SetStatusMessage(_lang_modifying_actor);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Actor&Operation=Delete&MovieID=" + _guid + "&ActorID=" + _actorDeleteList[_actorDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMovie_DeleteActor();
		}
	});
}

function EditMovie_AddActor()
{
	if (_actorAddIndex >= _actorAddList.length)
	{
        EditMovie_DeleteDirector();
		return;
	}
	
	var data = "MovieID=" + _guid;
	data += "&ActorID=" + _actorAddList[_actorAddIndex];
	
	_actorAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Actor&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMovie_AddActor();
		}
	});
}

function EditMovie_DeleteDirector()
{
	if (_directorDeleteIndex >= _directorDeleteList.length)
	{
		EditMovie_AddDirector();
		return;
	}

	SetStatusMessage(_lang_modifying_director);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Director&Operation=Delete&MovieID=" + _guid + "&DirectorID=" + _directorDeleteList[_directorDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMovie_DeleteDirector();
		}
	});
}

function EditMovie_AddDirector()
{
	if (_directorAddIndex >= _directorAddList.length)
	{
        Movie_UploadPicture();
		return;
	}
	
	var data = "MovieID=" + _guid;
	data += "&DirectorID=" + _directorAddList[_directorAddIndex];
	
	_directorAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Director&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMovie_AddDirector();
		}
	});
}

function Movie_UploadPicture()
{
    if (!_uploadPicture)
    {
        Movie_UploadThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_picture);
    _uploader.Init({Status:_lang_uploading_picture,Params:"Lang=" + _lang + "&Object=Movie&Operation=UploadPicture&ID=" + _id + "&MakeThumbnail=" + $("#MakeThumbnail")[0].checked + "&AddWaterMark=" + $("#AddWaterMarkToPicture")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Movie_UploadThumbnail();
    	}
    });
}

function Movie_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Lang=" + _lang + "&Object=Movie&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToThumbnail")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function MoveMovie(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie&Operation=" + g_action + "&From=" + from + "&To=" + to + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function UpdateMovie(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateMovie(action, id);}, this);
		else
			UpdateMovie(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}

function ReplaceMovie()
{
	if (this.From.type == "text" && this.From.value == "")
	{
		Alert(_lang_from_empty, function(){this.From.select();}, this);
		return false;
	}
	
	var data = "Property=" + this.Property.value;
	data += "&From=" + encodeURIComponent(this.From.value);
	data += "&To=" + encodeURIComponent(this.To.value);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie&Operation=Replace",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function AddClientUrl()
{
    var form = $("form")[0];

	if (form.PlayerID.value == "")
	{
		Alert(_lang_select_player);
		return;
	}
	
	SetCookie("UrlName", form.UrlName.value, 10*360*24*60);
	SetCookie("Extention", form.Extention.value, 10*360*24*60);
	SetCookie("PlayerID", form.PlayerID.value, 10*360*24*60);

	var urlCategory = "";
    if ($.browser.msie)
	    urlCategory = form.UrlCategoryID.outerHTML.replace("name=UrlCategoryID", "");
	else
	    urlCategory = "<select><option value=" + form.UrlCategoryID.value + ">" + form.UrlCategoryID.options[form.UrlCategoryID.selectedIndex].text + "</option></select>";

    var player = "";
    if ($.browser.msie)
    	player = form.PlayerID.outerHTML.replace("name=PlayerID", "");
    else
	    player = "<select><option value=" + form.PlayerID.value + ">" + form.PlayerID.options[form.PlayerID.selectedIndex].text + "</option></select>";

	var extention = form.Extention.value == "" ? "" : "." + form.Extention.value;

	var names = new Array();
	var urls = new Array();
	if (form.Type.value == "")
	{
		if (form.UrlName.value == "")
			names[names.length] = "01";
		else
			names[names.length] = form.UrlName.value;
		
		urls[urls.length] = form.UrlTemplate.value;
	}
	else if (form.Type.value == "0")
	{
		if (form.To.value.match(/^\d+$/) == null || form.From.value.match(/^\d+$/) == null || form.Wildcard.value.match(/^\d+$/) == null)
		{
			Alert(_lang_must_be_number);
			return;
		}
	
		var from, to, wildcard;
		if(parseInt(form.From.value) <= parseInt(form.To.value))
		{
			from = parseInt(form.From.value);
			to = parseInt(form.To.value);
		}
		else
		{
			from = parseInt(form.To.value);
			to = parseInt(form.From.value);
		}
			
		var wildcard = parseInt(form.Wildcard.value);	
		for (var i = from; i <= to; i++)
		{
			var r = "";
			var count = Math.max(wildcard, (i + "").length) - (i + "").length;
			for (var j = 0; j < count; j++)
				r += "0";
			r += i;

			if (form.UrlName.value.indexOf("(*)") == -1)
				names[names.length] = form.UrlName.value + r;
			else
				names[names.length] = form.UrlName.value.replace("(*)", r);
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					urls[urls.length] = form.UrlTemplate.value + r + extention;
				else
					urls[urls.length] = form.UrlTemplate.value.replace("(*)", r) + extention;
			}			
		}
	}
	else if (form.Type.value == "1")
	{
		if (!(form.From.value >= "a" && form.From.value <= "z") && !(form.From.value >= "A" && form.From.value <= "Z"))
		{
		    Alert(_lang_from_a_to_z, function(){this.From.select();}, this);
			return;
		}
		
		if (!(form.To.value >= "a" && form.To.value <= "z") && !(form.To.value >= "A" && form.To.value <= "Z"))
		{
		    Alert(_lang_to_a_to_z, function(){this.To.select();}, this);
			return;
		}
		
		var from, to;
		if(form.From.value <= form.To.value)
		{
			from = form.From.value.charCodeAt(0);
			to = form.To.value.charCodeAt(0);
		}
		else
		{
			from = form.To.value.charCodeAt(0);
			to = form.From.value.charCodeAt(0);
		}
		
		for (var i = from; i <= to; i++)
		{
			if (form.UrlName.value.indexOf("(*)") == -1)
				names[names.length] = form.UrlName.value + String.fromCharCode(i);
			else
				names[names.length] = form.UrlName.value.replace("(*)", String.fromCharCode(i));
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					urls[urls.length] = form.UrlTemplate.value + String.fromCharCode(i) + extention;
				else
					urls[urls.length] = form.UrlTemplate.value.replace("(*)", String.fromCharCode(i)) + extention;	
			}			
		}
	}
	
	var table = $("#UrlTable tbody")[0];
	for (var i = 0; i < names.length; i++)
	{
		var row = table.insertRow(-1);
		var cell = null;
		
		cell = row.insertCell(-1);
		cell.innerHTML = urlCategory;
		
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type='text' value='" + names[i] + "' size='20' maxlength='50' class='" + _lang + "Font' />";
		
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type='text' value='" + urls[i] + "' size='40' maxlength='255' />";
		
		cell = row.insertCell(-1);
		cell.innerHTML = player;
		
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type='button' value='" + _lang_delete + "' onclick='DeleteClientUrl(this)' />";
	}
}

function DeleteClientUrl(input)
{
	var table = $("#UrlTable")[0];
	table.deleteRow(input.parentNode.parentNode.rowIndex);
}

function Type_OnChange()
{
    var form = this.form;
	if (this.value == "")
	{
		$("#Batch").hide();
	}
	else
	{
		if (this.value == "0")
		{
			form.From.maxLength = 3;
			form.From.value = "1";
			form.To.maxLength = 3;
			form.To.value = "2";
	
			$("#WildcardSpan").show();
		}
		else if (form.Type.value == "1")
		{
			form.From.maxLength = 1;
			form.From.value = "A";
			form.To.maxLength = 1;
			form.To.value = "B";
	
			$("#WildcardSpan").hide();
		}

		$("#Batch").show();
	}
}

function Property_OnChange()
{
    switch (this.value)
    {
        case "CategoryID":
            SetStatusMessage(_lang_working);
        	
            $.ajax(
            {
                url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MovieCategory&Operation=List",
                type : "GET",
                error : function(request)
                {
	                Alert(_lang_operation_fail);
	                SetStatusMessage();
                },
                success : function(data)
                {
	                _xmlDoc.loadXML(data);
	                var childNodes = _xmlDoc.documentElement.childNodes;
        			
	                var from = "<select name=\"From\" class=\"" + _lang + "Font\">";
	                var to = "<select name=\"To\" class=\"" + _lang + "Font\">";
	                for (var i = 0; i < childNodes.length; i++)
	                {
						if (typeof (childNodes[i].selectSingleNode) == "undefined")
							continue;
						
	                    var id = childNodes[i].selectSingleNode(IlgharCMS.MovieModule.MovieCategory.ID).text;
	                    var name = childNodes[i].selectSingleNode(IlgharCMS.MovieModule.MovieCategory.Name).text;
		                var option = "<option value=\"" + id + "\">" + name + "</option>";
		                from += option;
		                to += option;
	                }
	                from += "</select>";
	                to += "</select>";
        			
	                $("#FromTd").html(from);
	                $("#ToTd").html(to);
	                SetStatusMessage();
                }
            });
	        break;
        case "RegionID":
            SetStatusMessage(_lang_working);
        	
            $.ajax(
            {
                url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=List",
                type : "GET",
                error : function(request)
                {
	                Alert(_lang_operation_fail);
	                SetStatusMessage();
                },
                success : function(data)
                {
	                _xmlDoc.loadXML(data);
	                var childNodes = _xmlDoc.documentElement.childNodes;
        			
	                var from = "<select name=\"From\" class=\"" + _lang + "Font\">";
	                var to = "<select name=\"To\" class=\"" + _lang + "Font\">";
	                for (var i = 0; i < childNodes.length; i++)
	                {
						if (typeof (childNodes[i].selectSingleNode) == "undefined")
							continue;
						
	                    var id = childNodes[i].selectSingleNode(IlgharCMS.MovieModule.Region.ID).text;
	                    var name = childNodes[i].selectSingleNode(IlgharCMS.MovieModule.Region.Name).text;
		                var option = "<option value=\"" + id + "\">" + name + "</option>";
		                from += option;
		                to += option;
	                }
	                from += "</select>";
	                to += "</select>";
        			
	                $("#FromTd").html(from);
	                $("#ToTd").html(to);
	                SetStatusMessage();
                }
            });
	        break;
        case "LanguageID":
            SetStatusMessage(_lang_working);
        	
            $.ajax(
            {
                url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=List",
                type : "GET",
                error : function(request)
                {
	                Alert(_lang_operation_fail);
	                SetStatusMessage();
                },
                success : function(data)
                {
	                _xmlDoc.loadXML(data);
	                var childNodes = _xmlDoc.documentElement.childNodes;
        			
	                var from = "<select name=\"From\" class=\"" + _lang + "Font\">";
	                var to = "<select name=\"To\" class=\"" + _lang + "Font\">";
	                for (var i = 0; i < childNodes.length; i++)
	                {
						if (typeof (childNodes[i].selectSingleNode) == "undefined")
							continue;
						
	                    var id = childNodes[i].selectSingleNode(IlgharCMS.MovieModule.Language.ID).text;
	                    var name = childNodes[i].selectSingleNode(IlgharCMS.MovieModule.Language.Name).text;
		                var option = "<option value=\"" + id + "\">" + name + "</option>";
		                from += option;
		                to += option;
	                }
	                from += "</select>";
	                to += "</select>";
        			
	                $("#FromTd").html(from);
	                $("#ToTd").html(to);
	                SetStatusMessage();
                }
            });
	        break;
        case "SexID":
            SetStatusMessage(_lang_working);
        	
            $.ajax(
            {
                url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=List",
                type : "GET",
                error : function(request)
                {
	                Alert(_lang_operation_fail);
	                SetStatusMessage();
                },
                success : function(data)
                {
	                _xmlDoc.loadXML(data);
	                var childNodes = _xmlDoc.documentElement.childNodes;
        			
	                var from = "<select name=\"From\" class=\"" + _lang + "Font\">";
	                var to = "<select name=\"To\" class=\"" + _lang + "Font\">";
	                for (var i = 0; i < childNodes.length; i++)
	                {
						if (typeof (childNodes[i].selectSingleNode) == "undefined")
							continue;
						
	                    var id = childNodes[i].selectSingleNode(IlgharCMS.MovieModule.Sex.ID).text;
	                    var name = childNodes[i].selectSingleNode(IlgharCMS.MovieModule.Sex.Name).text;
		                var option = "<option value=\"" + id + "\">" + name + "</option>";
		                from += option;
		                to += option;
	                }
	                from += "</select>";
	                to += "</select>";
        			
	                $("#FromTd").html(from);
	                $("#ToTd").html(to);
	                SetStatusMessage();
                }
            });
	        break;
        case "Name":
        case "Description":
	        $("#FromTd").html("<input type=\"text\" name=\"From\" class=\"Text " + _lang + "Font\" />");
	        $("#ToTd").html("<input type=\"text\" name=\"To\" class=\"Text " + _lang + "Font\" />");
	        break;
        default:
	        $("#FromTd").html("<input type=\"text\" name=\"From\" size=\"40\" class=\"Text\" />");
	        $("#ToTd").html("<input type=\"text\" name=\"To\" size=\"40\" class=\"Text\" />");
	        break;
    }
}
//End : 电影管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 地址管理
function PrepareUrl()
{
    var form = $("form")[0];

	if (form.PlayerID.value == "")
	{
		Alert(_lang_select_player);
		return;
	}
	
	SetCookie("UrlName", form.UrlName.value, 10*360*24*60);
	SetCookie("Extention", form.Extention.value, 10*360*24*60);
	SetCookie("PlayerID", form.PlayerID.value, 10*360*24*60);
	
	_playerID = form.PlayerID.value;
	_needPack = form.NeedPack.checked;
	_categoryID = form.CategoryID.value;
	_extention = form.Extention.value == "" ? "" : "." + form.Extention.value;
	_counter = 0;
	
	_names = new Array();
	_urls = new Array();
	_downloads = new Array();
	if (form.Type.value == "")
	{
		if (form.UrlName.value == "")
			_names[_names.length] = "01";
		else
			_names[_names.length] = form.UrlName.value;
		
		_urls[_urls.length] = form.UrlTemplate.value;
		_downloads[_downloads.length] = form.DownloadTemplate.value;
	}
	else if (form.Type.value == "0")
	{
		if (!form.To.value.match(/^\d+$/) || !form.From.value.match(/^\d+$/) || !form.Wildcard.value.match(/^\d+$/))
		{
			Alert(_lang_must_be_number);
			return;
		}
	
		var from, to, wildcard;
		if(parseInt(form.From.value) <= parseInt(form.To.value))
		{
			from = parseInt(form.From.value);
			to = parseInt(form.To.value);
		}
		else
		{
			from = parseInt(form.To.value);
			to = parseInt(form.From.value);
		}
			
		var wildcard = parseInt(form.Wildcard.value);	
		for (var i = from; i <= to; i++)
		{
			var r = "";
			var count = Math.max(wildcard, (i + "").length) - (i + "").length;
			for (var j = 0; j < count; j++)
				r += "0";
			r += i;

			if (form.UrlName.value.indexOf("(*)") == -1)
				_names[_names.length] = form.UrlName.value + r;
			else
				_names[_names.length] = form.UrlName.value.replace("(*)", r);
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					_urls[_urls.length] = form.UrlTemplate.value + r + _extention;
				else
					_urls[_urls.length] = form.UrlTemplate.value.replace("(*)", r) + _extention;
			}
			
			if (form.DownloadTemplate.value == "")
			{
				_downloads[_downloads.length] = "";
			}
			else
			{
				if (form.DownloadTemplate.value.indexOf("(*)") == -1)
					_downloads[_downloads.length] = form.DownloadTemplate.value + r + _extention;
				else
					_downloads[_downloads.length] = form.DownloadTemplate.value.replace("(*)", r) + _extention;
			}
		}
	}
	else if (form.Type.value == "1")
	{
		if (!(form.From.value >= "a" && form.From.value <= "z") && !(form.From.value >= "A" && form.From.value <= "Z"))
		{
		    Alert(_lang_from_a_to_z, function(){form.From.select();}, this);
			return;
		}
		
		if (!(form.To.value >= "a" && form.To.value <= "z") && !(form.To.value >= "A" && form.To.value <= "Z"))
		{
		    Alert(_lang_to_a_to_z, function(){form.To.select();}, this);
			return;
		}
		
		var from, to;
		if(form.From.value <= form.To.value)
		{
			from = form.From.value.charCodeAt(0);
			to = form.To.value.charCodeAt(0);
		}
		else
		{
			from = form.To.value.charCodeAt(0);
			to = form.From.value.charCodeAt(0);
		}
		
		for (var i = from; i <= to; i++)
		{
			if (form.UrlName.value.indexOf("(*)") == -1)
				_names[_names.length] = form.UrlName.value + String.fromCharCode(i);
			else
				_names[_names.length] = form.UrlName.value.replace("(*)", String.fromCharCode(i));
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					_urls[_urls.length] = form.UrlTemplate.value + String.fromCharCode(i) + _extention;
				else
					_urls[_urls.length] = form.UrlTemplate.value.replace("(*)", String.fromCharCode(i)) + _extention;	
			}
			
			if (form.DownloadTemplate.value == "")
			{
				_downloads[_downloads.length] = "";
			}
			else
			{
				if (form.DownloadTemplate.value.indexOf("(*)") == -1)
					_downloads[_downloads.length] = form.DownloadTemplate.value + String.fromCharCode(i) + _extention;
				else
					_downloads[_downloads.length] = form.DownloadTemplate.value.replace("(*)", String.fromCharCode(i)) + _extention;	
			}
		}
	}
}

function AddUrl()
{
    if (_counter >= _names.length)
    {
    	$(":submit")[0].disabled = false;
	    Search();
        return;
    }
    
	var data = "MovieID=" + _movieID;
	data += "&CategoryID=" + _categoryID;
	data += "&Name=" + encodeURIComponent(_names[_counter]);
	data += "&Url=" + encodeURIComponent(_urls[_counter]);
	data += "&Download=" + encodeURIComponent(_downloads[_counter]);
	data += "&PlayerID=" + _playerID;
	data += "&NeedPack=" + _needPack;
	
	_counter++;
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Url&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    AddUrl();
		}
	});
}

function ModifyUrl(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);
	data += "&URL=" + encodeURIComponent(form.URL.value);
	data += "&PlayerID=" + form.PlayerID.value;
	data += "&NeedPack=" + form.NeedPack.checked;

	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Url&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
	
	return false;
}

function DeleteUrl(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Url&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();

			if (typeof(SetupIme) == "function")
				SetupIme();
		}
	});
}

function EditUrl()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}

	if (!this.Error.value.match(/^\d+$/))
	{
		Alert(_lang_error_incorrect, function(){this.Error.select();}, this);
		return false;
	}
	
	var data = "CategoryID=" + this.CategoryID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&PlayerID=" + this.PlayerID.value;
	_uploadForPlay = _uploader.NeedUpload("URL");
	if (!_uploadForPlay)
		data += "&URL=" + encodeURIComponent(this.URL.value);
	_uploadForDownload = _uploader.NeedUpload("Download");
	if (!_uploadForDownload)
		data += "&Download=" + encodeURIComponent(this.Download.value);
	data += "&NeedPack=" + $("#NeedPackYes")[0].checked;
	data += "&Error=" + this.Error.value;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Movie.Url&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
	        Url_UploadForPlay();
		}
	});
	
	return false;
}

function Url_UploadForPlay()
{
    if (!_uploadForPlay)
    {
	    Url_UploadForDownload();

	    return;
    }

    SetStatusMessage(_lang_start_upload_play);
    _uploader.Init({Status:_lang_uploading_play,Params:"Lang=" + _lang + "&Object=Movie.Url&Operation=UploadForPlay&ID=" + _id});
    _uploader.Upload("URL", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Url_UploadForDownload();
    	}
    });
}

function Url_UploadForDownload()
{
    if (!_uploadForDownload)
    {
	    Alert(_lang_operation_success);
	    SetStatusMessage();
	    $(":submit")[0].disabled = false;

	    return;
    }

    SetStatusMessage(_lang_start_upload_download);
    _uploader.Init({Status:_lang_uploading_download,Params:"Lang=" + _lang + "&Object=Movie.Url&Operation=UploadForDownload&ID=" + _id});
    _uploader.Upload("Download", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}
//End : 地址管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 地址类别管理
function AddUrlCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&UrlPrefix=" + encodeURIComponent(this.UrlPrefix.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=UrlCategory&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditUrlCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&UrlPrefix=" + encodeURIComponent(this.UrlPrefix.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=UrlCategory&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function MoveUrlCategory(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=UrlCategory&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function ModifyUrlCategory(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=UrlCategory&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});

	return false;
}

function DeleteUrlCategory(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=UrlCategory&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}
//End : 地址类别管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 电影评论管理
function EditMovieComment()
{
	var data = "Content=" + encodeURIComponent(this.Content.value);
	data += "&UpdateTime=" + FormatDate(new Date());

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MovieComment&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function UpdateMovieComment(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateMovieComment(action, id);}, this);
		else
			UpdateMovieComment(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MovieComment&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#RecordList").html(HandleFake404(data, "text"));				
			}
		});
	}
}
//End : 电影评论管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 人物评论管理
function EditPersonComment()
{
	var data = "Content=" + encodeURIComponent(this.Content.value);
	data += "&UpdateTime=" + FormatDate(new Date());

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=PersonComment&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function UpdatePersonComment(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdatePersonComment(action, id);}, this);
		else
			UpdatePersonComment(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=PersonComment&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#RecordList").html(HandleFake404(data, "text"));				
			}
		});
	}
}
//End : 人物评论管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 性别管理
function AddSex()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddSex_GetInnerID();
		}
	});
	
	return false;
}

function AddSex_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddSex_SetPageID();
		}
	});
}

function AddSex_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function EditSex()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function ModifySex(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteSex(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}
//End : 性别管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 人物管理
function AddPerson()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	var tag = PrepareTag();

	var sex = $("[name=SexID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");
	
	SetCookie("MakeThumbnail", $("#MakeThumbnail")[0].checked, 10*360*24*60);
		
	_createTime = new Date();
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	data += "&CreateTime=" + FormatDate(_createTime, "YYYY-MM-DD hh:mm:ss.SSS");
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&FirstLetter=" + this.FirstLetter.value;
	data += "&SexID=" + this.SexID.value;
	data += "&SexName=" + sex.attr("Name");
	data += "&SexPageGenerate=" + sex.attr("PageGenerate");
	data += "&SexPageTemplate=" + sex.attr("PageTemplate");
	data += "&SexPageID=" + sex.attr("PageID");
	data += "&SexPageExtension=" + sex.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddPerson_GetInnerID();
		}
	});
	
	return false;	
}

function AddPerson_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddPerson_SetPageID();
		}
	});
}

function AddPerson_SetPageID()
{
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
	_pageID = _pageID.replace(/\{ID\}/g, _id);
	_pageID = _pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	_pageID = _pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_pageID),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		AddPerson_AddTag();
		}
	});
}

function AddPerson_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		Person_UploadPicture();
		return;
	}
	
	var data = "PersonID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

    SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddPerson_AddTag();
		}
	});
}

function EditPerson()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.UpdateTime.value))
	{
	    Alert(_lang_update_time_incorrect, function(){this.UpdateTime.select();}, this);
		return false;
	}

	var tag = PrepareTag();
	
	var sex = $("[name=SexID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");

	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	pageID = pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	pageID = pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&UpdateTime=" + this.UpdateTime.value;
	data += "&FirstLetter=" + this.FirstLetter.value;
	data += "&SexID=" + this.SexID.value;
	data += "&SexName=" + sex.attr("Name");
	data += "&SexPageGenerate=" + sex.attr("PageGenerate");
	data += "&SexPageTemplate=" + sex.attr("PageTemplate");
	data += "&SexPageID=" + sex.attr("PageID");
	data += "&SexPageExtension=" + sex.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPerson_DeleteTag();
		}
	});

	return false;
}

function EditPerson_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditPerson_AddTag();
		return;
	}

	SetStatusMessage(_lang_modifying_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person.Tag&Operation=Delete&PersonID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPerson_DeleteTag();
		}
	});
}

function EditPerson_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
        Person_UploadPicture();
		return;
	}
	
	var data = "PersonID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPerson_AddTag();
		}
	});
}

function Person_UploadPicture()
{
    if (!_uploadPicture)
    {
        Person_UploadThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_picture);
    _uploader.Init({Status:_lang_uploading_picture,Params:"Lang=" + _lang + "&Object=Person&Operation=UploadPicture&ID=" + _id + "&MakeThumbnail=" + $("#MakeThumbnail")[0].checked + "&AddWaterMark=" + $("#AddWaterMarkToPicture")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Person_UploadThumbnail();
    	}
    });
}

function Person_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Lang=" + _lang + "&Object=Person&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToThumbnail")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function MovePerson(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=" + g_action + "&From=" + from + "&To=" + to + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function UpdatePerson(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdatePerson(action, id);}, this);
		else
			UpdatePerson(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}

function ReplacePerson()
{
	if (this.From.type == "text" && this.From.value == "")
	{
		Alert(_lang_from_empty, function(){this.From.select();}, this);
		return false;
	}
	
	var data = "Property=" + this.Property.value;
	data += "&From=" + encodeURIComponent(this.From.value);
	data += "&To=" + encodeURIComponent(this.To.value);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=Replace",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

//End : 人物管理
//-------------------------------------------------

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "movie_category_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form").eq(0).submit(AddMovieCategory);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "movie_category_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;
		
		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}

		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form").eq(0).submit(EditMovieCategory);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "movie_category_list")
	{
	    MakeButton();

	    $("tr").each(function ()
		{
			var id = $(this).attr("ItemID");
			
			$(this).find("form").submit(function(){ModifyMovieCategory(this, id);return false;});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteMovieCategory(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		InitMove(null,"Move", null, MoveMovieCategory);
		
		$("#IsDisplay,#IsRecommended,#IsHeld,#Sort").change(Search);
	}
	else if (_page == "tag_list")
	{
		$("form").each(function()
		{
			var id = this.action;

			$(this).submit(function(){return ModifyTag(this, id)});
		});		

		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){DeleteTag();});
	}
	else if (_page == "tag_select")
	{
		$(":checkbox").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "tag_add")
	{
		$("form").submit(AddTag);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "tag_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").submit(EditTag);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "region_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("ItemID");
			
			$(this).find("form").submit(function(){ModifyRegion(this, id);return false;});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteRegion(id);}, this);
				return false;
			});
		});
		
		InitMove(null,"Move", null, MoveRegion);
	}
	else if (_page == "region_add")
	{
		$("form").submit(AddRegion);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "region_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").submit(EditRegion);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	if (_page == "company_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteCompany(id);}, this);
				return false;
			});
		});

		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "company_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Logo", "LogoTextbox", "LogoBrowse");
		
		$("form").eq(0).submit(AddCompany);
		$("#LogoTextbox").change(function(){$("#LogoView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "company_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Logo", "LogoTextbox", "LogoBrowse");
		
		$("form").eq(0).submit(EditCompany);
		$("#LogoTextbox").change(function(){$("#LogoView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "config_basic")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Movie", "MovieTextbox", "MovieBrowse");
		_uploader.Add("Person", "PersonTextbox", "PersonBrowse");

		$("form").eq(0).submit(SetBasicSettings);
		$("#CreateAllPackFile").click(CreateAllPackFile);
		$("#CreateAllMovieThumbnail").click(CreateAllMovieThumbnail);
		$("#CreateAllPersonThumbnail").click(CreateAllPersonThumbnail);
		$("#MovieTextbox").change(function(){$("#MovieDefaultThumbnailView").attr("src", this.value)});
		$("#PersonTextbox").change(function(){$("#PersonDefaultThumbnailView").attr("src", this.value)});
	}
	else if (_page == "language_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("form").submit(function(){return ModifyLanguage(this, id);});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteLanguage(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "language_add")
	{
		$("form").eq(0).submit(AddLanguage);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "language_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").eq(0).submit(EditLanguage);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "movie_add")
	{
	    var form = $("form")[0];
	    form.UrlName.value = GetCookie("UrlName");
	    form.Extention.value = GetCookie("Extention");
	    CheckAndSelect(form.CategoryID, GetCookie("CategoryID"));
	    CheckAndSelect(form.RegionID, GetCookie("RegionID"));
	    CheckAndSelect(form.LanguageID, GetCookie("LanguageID"));
	    CheckAndSelect(form.PlayerID, GetCookie("PlayerID"));
    	
	    if (GetCookie("MakeThumbnail") == "false")
	    {
		    $("#MakeThumbnail")[0].checked = false;
		    $("#ThumbnailRow").show();
	    }
	    else
	    {
		    $("#MakeThumbnail")[0].checked = true;
		    $("#ThumbnailRow").hide();
		}

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
               
		$("form").eq(0).submit(AddMovie);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Picture")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailSelect").click(function(){ShowSelectFileDialog("Thumbnail")});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#ActorSelect").click(function(){ShowSelectDialog("Actor")});
		$("#DirectorSelect").click(function(){ShowSelectDialog("Director")});
		$("#URLSelect").click(function(){ShowSelectFileDialog("URL")});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		$("[name=UrlName],[name=Extention],[name=UrlTemplate]").keydown(function(e){if (e.keyCode == 13){AddClientUrl();e.preventDefault();}});
		$("#AddUrl").click(AddClientUrl);
		$("[name=Type]").change(Type_OnChange);
	}
	else if (_page == "movie_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}
        
        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true);
        }
        
        for (var i = 0; i < _actors.length; i++)
        {
	        SelectPerson(_actors[i], true, "Actor");
        }
        
        for (var i = 0; i < _directors.length; i++)
        {
	        SelectPerson(_directors[i], true, "Director");
        }

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");

		$("form").eq(0).submit(EditMovie);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Picture")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailSelect").click(function(){ShowSelectFileDialog("Thumbnail")});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#ActorSelect").click(function(){ShowSelectDialog("Actor")});
		$("#DirectorSelect").click(function(){ShowSelectDialog("Director")});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
		$("#Now").click(function(){$("[name=UpdateTime]").val(FormatDate(new Date(), "YYYY-MM-DD hh:mm:ss"));return false;});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "movie_list")
	{
		MakeButton();
		
		$("tr").each(function()
		{
			$(this).find("[sort=" + this.id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});
		});
    	
		if (arguments.length == 0)
		    return;

	    if (GetCookie("ListByPicture").toLowerCase() == "true")
		    $("#ListByPicture")[0].checked = true;	
	    else
		    $("#ListByPicture")[0].checked = false;
	
		InitMove(null, "Move", null, MoveMovie);
		
		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#RegionID,#LanguageID,#CategoryID,#Sort").change(Search);
		$("#IncludeSubCategory,#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		
		$("#ListByPicture").click(function()
		{
	        SetCookie("ListByPicture", $("#ListByPicture")[0].checked, 10*360*24*60);
	        Search();
		});
	}
	else if (_page == "movie_replace")
	{
		_xmlDoc = CreateXmlDom();

		$("form").submit(ReplaceMovie);
		$("[name=Property]").change(Property_OnChange);
	}
	else if (_page == "movie_url_edit")
	{
		_uploader.Init({WebPath:_webPath});
        _uploader.Add("URL", "URLTextbox", "URLBrowse");
        _uploader.Add("Download", "DownloadTextbox", "DownloadBrowse");

		$("form").submit(EditUrl);
		$("#URLSelect").click(function(){ShowSelectFileDialog("URL")});
		$("#DownloadSelect").click(function(){ShowSelectFileDialog("Download")});
	}
	else if (_page == "movie_url_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("form").submit(function(){return ModifyUrl(this, id);});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteUrl(id);}, this);
				return false;
			});
		});

		if (arguments.length == 0)
		    return;

	    $("[name=UrlName]").val(GetCookie("UrlName"));
	    $("[name=Extention]").val(GetCookie("Extention"));
    	CheckAndSelect($("[name=PlayerID]")[0], GetCookie("PlayerID"));

		$("form").eq(0).submit(function(){PrepareUrl();AddUrl();return false;});
		$("[name=CategoryID]").change(Search);
		$("[name=Type]").change(Type_OnChange);
		$("#URLSelect").click(function(){ShowSelectFileDialog("URL")});
		$("#DownloadSelect").click(function(){ShowSelectFileDialog("Download")});
	}
	else if (_page == "url_category_add")
	{
		$("form").eq(0).submit(AddUrlCategory);
	}
	else if (_page == "url_category_edit")
	{
		$("form").eq(0).submit(EditUrlCategory);
	}
	else if (_page == "url_category_list")
	{
		$("tr").each(function()
		{
		    var id = $(this).attr("ItemID");
			
			$(this).find("form").submit(function(){return ModifyUrlCategory(this, id);});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteUrlCategory(id);}, this);
				return false;
			});
		});
		
		InitMove(null,"Move", null, MoveUrlCategory);
	}
	else if (_page == "movie_comment_list")
	{
		MakeButton();

		if (arguments.length == 0)
		    return;

		$("#IsChecked,#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){UpdateMovieComment("Delete");});
	}
	else if (_page == "movie_comment_edit")
	{
		$("form").eq(0).submit(EditMovieComment);
	}
	else if (_page == "person_comment_list")
	{
		MakeButton();

		if (arguments.length == 0)
		    return;

		$("#IsChecked").change(Search);
		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){UpdatePersonComment("Delete");});
	}
	else if (_page == "person_comment_edit")
	{
		$("form").eq(0).submit(EditPersonComment);
	}
	else if (_page == "sex_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("form").submit(function(){return ModifySex(this, id);});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteSex(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "sex_add")
	{
		$("form").eq(0).submit(AddSex);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "sex_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").eq(0).submit(EditSex);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "person_add")
	{
	    if (GetCookie("MakeThumbnail") == "false")
	    {
		    $("#MakeThumbnail")[0].checked = false;
		    $("#ThumbnailRow").show();
	    }
	    else
	    {
		    $("#MakeThumbnail")[0].checked = true;
		    $("#ThumbnailRow").hide();
		}

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
               
		$("form").eq(0).submit(AddPerson);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Picture")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailSelect").click(function(){ShowSelectFileDialog("Thumbnail")});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "person_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}
        
        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true);
        }

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");

		$("form").eq(0).submit(EditPerson);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Picture")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailSelect").click(function(){ShowSelectFileDialog("Thumbnail")});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
		$("#Now").click(function(){$("[name=UpdateTime]").val(FormatDate(new Date(), "YYYY-MM-DD hh:mm:ss"));return false;});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "person_list")
	{
		MakeButton();
		
		$("tr").each(function()
		{
			$(this).find("[sort=" + this.id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});
		});
    	
		if (arguments.length == 0)
		    return;

	    if (GetCookie("ListByPicture").toLowerCase() == "true")
		    $("#ListByPicture")[0].checked = true;	
	    else
		    $("#ListByPicture")[0].checked = false;
	
		InitMove(null, "Move", null, MovePerson);
		
		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#RegionID,#LanguageID,#SexID,#Sort").change(Search);
		$("#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		
		$("#ListByPicture").click(function()
		{
	        SetCookie("ListByPicture", $("#ListByPicture")[0].checked, 10*360*24*60);
	        Search();
		});
	}
	else if (_page == "person_select")
	{
		$("#List :checkbox").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectPerson({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked, _type);
			else
				window.opener.SelectPerson({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked, _type);
		});
		
		if (arguments.length == 0)
		    return;

		$("#RegionID,#LanguageID,#SexID,#Sort").change(Search);
		$("#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "person_replace")
	{
		_xmlDoc = CreateXmlDom();

		$("form").submit(ReplacePerson);
		$("[name=Property]").change(Property_OnChange);
	}
}
Init(true);