﻿function Login()
{
	var name = $.trim(this.Name.value);
	if (name == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var password = $.trim(this.Password.value);
	if (password == "")
	{
		Alert(_lang_password_empty, function(){this.Password.select();}, this);
		return false;
	}

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Password=" + encodeURIComponent(this.Password.value);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Mark=Member&Object=Member&Operation=Login",
		data : data,
		type : "POST",
		error : function (request)
		{
			Alert(_lang_login_fail);
		},
		success : function (data)
		{
			$(".TopMenu p span").html(GetCookie("UserName"));
			$(".TopMenu div form").hide();
			$(".TopMenu div p").show();
			$(".TopMenu ol li").toggle();
		}
	});
	
	return false;
}

function AddComment()
{
	var name = $.trim(this.Name.value);
	if (name == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}

	var content = $.trim(this.Content.value);
	if (content == "")
	{
		Alert(_lang_content_empty, function(){this.Content.select();}, this);
		return false;
	}
	
	var data = "InfoID=" + _guid;
	data += "&InfoTitle=" + encodeURIComponent(this.Title.value);
	data += "&Name=" + encodeURIComponent(name);
	data += "&Creator=" + encodeURIComponent(name);
	data += "&Content=" + encodeURIComponent(this.Content.value);
	data += "&IsChecked=" + !_checkComment;

	$(".Comment :submit")[0].disabled = true;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Comment&Operation=Add",
		data : data,
		type : "POST",
		error : function (request)
		{
			Alert(_lang_operation_fail);
			$(".Comment :submit")[0].disabled = false;
		},
		success : function (data)
		{
			Alert(_lang_operation_success);
			$("[name=Content]").val("");
			$(".Comment :submit")[0].disabled = false;
			LoadComment(1);
		}
	});
	
	return false;
}

function LoadComment(page)
{
	$(".Comment div").load(_commentPage + "?InfoID=" + _guid);
}

function AddInfo()
{
	var title = $.trim(this.Title.value);
	if (title == "")
	{
		Alert(_lang_title_empty, function(){this.Title.select();}, this);
		return false;
	}
	
	var content = $.trim(this.Content.value);
	if (content == "")
	{
		Alert(_lang_content_empty, function(){this.Content.select();}, this);
		return false;
	}
	
	var expirationTime = new Date();
	expirationTime = new Date(expirationTime.getTime() + parseInt(this.ExpirationTime.value)*24*60*60*1000);

	var region = $("[name=RegionID] option:selected");
	var category = $("[name=CategoryID] option:selected");

	var data = "IsChecked=false&Title=" + encodeURIComponent(this.Title.value);
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&Content=" + encodeURIComponent(this.Content.value);
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Mobile=" + encodeURIComponent(this.Mobile.value);
	data += "&QQ=" + encodeURIComponent(this.QQ.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&ExpirationTime=" + FormatDate(expirationTime, "YYYY-MM-DD hh:mm:ss.SSS");
	data += "&PageID=" + FormatDate(new Date(), "YYYYMMDDhhmmssSSS");

	$("#Add :submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Info&Operation=Add",
		data : data,
		type : "POST",
		error : function (request)
		{
			Alert(_lang_operation_fail);
			$("#Add :submit")[0].disabled = false;
			SetStatusMessage();
		},
		success : function (data)
		{
			Alert(_lang_operation_success);
			$("#Add :submit")[0].disabled = false;
			SetStatusMessage();
		}
	});
	
	return false;
}

function Init()
{
	if (typeof(SetupIme) != "undefined")
		SetupIme();
	
	//顶部登录
	if (GetCookie("UserName") != "")
	{
		$(".TopMenu p span").html(GetCookie("UserName"));
		$(".TopMenu div form").hide();
		$(".TopMenu div p").show();
		$(".TopMenu ol li").toggle();
	}
	else
	{
		$(".TopMenu form").submit(Login);
	}
	
	//搜索里面的发布信息按钮
	$(".Header :button").click(function()
	{
		window.location = _addPage;
	});
	
	if (typeof(_page) == "undefined")
		return;
	
	if (_page == "category" || _page == "region")
	{
		$(".Pagination [type=button]").click(function()
		{
			var page = $(".Pagination [name=Go]").val();
			if (!page.match(/^\d+$/) || page <= 0 || page > parseInt($(".Pagination [name=Go]").attr("PageCount")))
			{
				Alert(_lang_page_incorrect, function(){$(".Pagination [name=Go]")[0].select();}, this);
				return;
			}
			
			window.location = _addPage.replace("{Page}", page);
		});
	}
	else if (_page == "info")
	{
		//评论
		var commentForm = $(".Comment Form");
		if (commentForm.length > 0)
		{
			LoadComment(1);
			var userName = GetCookie("UserName");
			if (userName != "")
			{
				commentForm.find("[name=Name]").val(userName)[0].disabled = true;
			}
			
			commentForm.submit(AddComment);
		}
		
		$.post(_webPath + "ilghar.aspx?Object=Info&Operation=IncrementHitCount&ID=" + _id, {});
		
		//调整内容中的表格宽度
		var width = $(".Content").parent().eq(0).css("width").replace(/[^\d]/g, "");
		$(".Content table").each(function()
		{
			if ($(this).width() > width)
				$(this).width(width - ($(this).attr("border") + $(this).attr("cellspacing")) * this.rows[0].cells.length * 2);
		});
		
		//获取人气
		$("#HitCount").load(_webPath + "ilghar.aspx?Object=Info&Operation=GetHitCount&ID=" + _id);
	}
	else if (_page == "add")
	{
		$("#Add").submit(AddInfo);
	}
}
Init();