using System;
using System.IO;
using System.Runtime.InteropServices;
using System.Text;

namespace FOUPOS.DBUtility
{
    public class IniFile
    {
        private string IniFileName;

        [DllImport("kernel32")]
        private static extern int GetPrivateProfileInt(string lpAppName, string lpKeyName,
         int nDefault, string lpFileName);

        [DllImport("kernel32")]
        private static extern int GetPrivateProfileString(string lpAppName, string lpKeyName,
         string lpDefault, StringBuilder lpReturnedString, int nSize, string lpFileName);

        [DllImport("kernel32")]
        private static extern bool WritePrivateProfileString(string lpAppName,
         string lpKeyName, string lpString, string lpFileName);

        public IniFile(string Filename)
        {
            IniFileName = Filename;
        }

        public int ReadIni(string Section, string Key, int Default)
        {
            return GetPrivateProfileInt(Section, Key, Default, IniFileName);
        }

        public string ReadIni(string Section, string Key, string Default)
        {
            StringBuilder temp = new StringBuilder(1024);
            int rec = GetPrivateProfileString(Section, Key, Default, temp, 1024, IniFileName);
            return temp.ToString();
        }

        public void WriteIni(string Section, string Key, int intValue)
        {
            WritePrivateProfileString(Section, Key, intValue.ToString(), IniFileName);
        }

        public void WriteIni(string Section, string Key, string strValue)
        {
            WritePrivateProfileString(Section, Key, strValue, IniFileName);
        }
    }
}