﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using System.Web.Util;

public partial class SendMail : System.Web.UI.Page
{
    SqlOperate sqloperate = new SqlOperate();
    SqlConnection sqlconn = new SqlConnection(ConfigurationManager.AppSettings["ConnectionString"]);
    //========================页面加载事件================================
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["UserName"] == null)
            {
                Response.Write("<script>alert('请确认您已经登录');</script>");
                Response.Redirect("Login.aspx");
            }
            else
            {
                sqlconn.Open();
                string sqlstrUser = "select UserEmail from tb_User where UserName='" + Session["UserName"].ToString() + "'";
                SqlDataAdapter UserApter = new SqlDataAdapter(sqlstrUser, sqlconn);
                DataSet UserDS = new DataSet();
                UserApter.Fill(UserDS, "tb_User");
                DataRowView rowView = UserDS.Tables["tb_User"].DefaultView[0];
                txtSender.Text = Convert.ToString(rowView["UserEmail"]);
                sqlconn.Close();
                string sqlstrFriend = "select FriendEmail from tb_Friend";
                sqloperate.ddlBind(ddlReceiver, sqlstrFriend, "FriendEmail");
            }
        }
    }
    //==========================上传文件===================================
    protected void btnTake_Click(object sender, EventArgs e)
    {
        try
        {
            if (upFile.PostedFile.ContentLength != 0)
            {
                string clientFileName = upFile.PostedFile.FileName;
                ddlAccessories.Items.Add(new ListItem(clientFileName));
                if (ddlAccessories.Items.Count > 0)
                {
                    btnDelete.Enabled = true;
                }
                else
                {
                    btnDelete.Enabled = false;
                }
            }
        }
        catch (Exception ex)
        {
            Response.Write("<script>alert('" + ex.Message.ToString() + "')</script>");
        }
    }
    //========================删除已上传文件=================================
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        ddlAccessories.Items.Remove(ddlAccessories.Items[ddlAccessories.SelectedIndex]);
        if (ddlAccessories.Items.Count > 0)
        {
            btnDelete.Enabled = true;
        }
        else
        {
            btnDelete.Enabled = false;
        }
    }
    //========================发送邮件========================================
    protected void btnSend_Click(object sender, EventArgs e)
    {
        try
        {
            if (ddlReceiver.Visible == true)
            {
                sendEmail(txtSender.Text.Trim(), txtSUser.Text.Trim(), txtEUser.Text.Trim(), txtEPwd.Text.Trim(), txtReceiver.Text.Trim(), txtSubject.Text.Trim(), txtContent.Text.Trim(), txtEServer.Text.Trim());
            }
            else
            {
                string strEmails = txtGroupEmail.Text.Trim();
                string[] strEmail = strEmails.Split(',');
                string sumEmail = "";
                for (int i = 0; i < strEmail.Length; i++)
                {
                    sumEmail = strEmail[i];
                    sendEmail(txtSender.Text.Trim(), txtSUser.Text.Trim(), txtEUser.Text.Trim(), txtEPwd.Text.Trim(), sumEmail, txtSubject.Text.Trim(), txtContent.Text.Trim(), txtEServer.Text.Trim());
                }
            }
        }
        catch (Exception ex)
        {
            Response.Write("<script>alert('"+ex.Message.ToString()+"')</script>");
        }
    }
    //========================群发邮件========================================
    protected void lbtnGroupEmail_Click(object sender, EventArgs e)
    {
        txtSubject.Text = "";
        txtContent.Text = "";
        labSelReceiver.Visible = false;
        txtReceiver.Visible = false;
        ddlReceiver.Visible = false;
        labSelGroup.Visible = true;
        txtGroupEmail.Visible = true;
        ddlGroupEmail.Visible = true;
        txtGroupEmail.Focus();
        string sqlstr = "select FriendEmail from tb_Friend";
        sqloperate.ddlBind(ddlGroupEmail,sqlstr,"FriendEmail");
    }
    //========================选择群发用户=====================================
    protected void ddlGroupEmail_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (txtGroupEmail.Text == "")
        {
            txtGroupEmail.Text = ddlGroupEmail.SelectedItem.Text.Trim();
        }
        else
        {
            txtGroupEmail.Text += "," + ddlGroupEmail.SelectedItem.Text.Trim();
        }
    }
    //========================选择好友信箱======================================
    protected void ddlReceiver_SelectedIndexChanged(object sender, EventArgs e)
    {
        txtReceiver.Text = ddlReceiver.SelectedItem.Text.Trim();
    }
    /*
    说明：sendEmail方法用来执行发送邮件功能，该方法无返回值。
    参数：sender表示发件人，senderuser表示发件人姓名，euser表示发件人的邮箱登录名，epwd表示发件人的邮箱密码，
     　　receiver表示收件人，subject表示邮件主题，body表示邮件内容，eserver表示发送邮件服务器。
    */
    public void sendEmail(string sender,string senderuser,string euser,string epwd, string receiver, string subject, string body,string eserver)
    {
        jmail.MessageClass jmMessage = new jmail.MessageClass();
        jmMessage.Charset = "GB2312";
        jmMessage.ISOEncodeHeaders = false;
        jmMessage.From = sender;
        jmMessage.FromName = senderuser;
        jmMessage.Subject = subject;
        jmMessage.MailServerUserName = euser;
        jmMessage.MailServerPassWord = epwd;
        jmMessage.AddRecipient(receiver, "", "");
        if (ddlAccessories.Items.Count > 0)
        {
            for (int i = 0; i < ddlAccessories.Items.Count; i++)
            {
                string path = ddlAccessories.Items[i].Value;
                jmMessage.AddAttachment(@path, true, "");
            }
        }
        jmMessage.Body = body;
        if (jmMessage.Send(eserver,false))
        {
            Page.RegisterClientScriptBlock("ok", "<script language=javascript>alert('发送成功')</script>");
            this.saveEmail();
        }
        else
            Page.RegisterClientScriptBlock("ok", "<script language=javascript>alert('发送失败，请仔细检查邮件服务器的设置是否正确！')</script>");
        jmMessage = null;
    }
    /*
    说明：saveEmail方法用来保存发送的邮件信息，该方法无参数、返回值。
    */
    public void saveEmail()
    {
        if (cbErgency.Checked == true)
        {
            string sqlstr = "insert into tb_EmailInfo"
                + "(EmailSender,EmailReceiver,EmailSubject,EmailContent,EmailIsErgency) "
                + "values('" + txtSender.Text.Trim() + "','" + txtReceiver.Text.Trim() 
                + "','" + txtSubject.Text.Trim() + "','" + txtContent.Text.Trim() + "','是')";
            sqloperate.DataCom(sqlstr);
        }
        else
        {
            string sqlstr = "insert into tb_EmailInfo"
                + "(EmailSender,EmailReceiver,EmailSubject,EmailContent,EmailIsErgency) "
                + "values('" + txtSender.Text.Trim() + "','" + txtReceiver.Text.Trim()
                + "','" + txtSubject.Text.Trim() + "','" + txtContent.Text.Trim() + "','否')";
            sqloperate.DataCom(sqlstr);
        }
    }
}
