using System;
using System.Collections.Generic;
using System.Text;
using IBLL;
using Model;
using DBUtility;
using System.Data;
using System.Data.SqlClient;

namespace BLL
{
    public class CategoryManager:IBLL.ICategoryManager
    {
        #region ICategoryManager Ա
        IDAL.ICategoryManager aut = DALFactory.DataAccess.CreateCategroyManager();

        /// <summary>
        /// ѯϢ
        /// </summary>
        /// <returns>IList<Model.Category>ͼ</returns>
        public IList<Model.CategoryManager> GetAllCategory()
        {
            return aut.SelectAllCategory();
        }

        /// <summary>
        /// ͨϼĿ¼IDѯϢ
        /// </summary>
        /// <param name="superiorId">ϼID</param>
        /// <param name="pager">ִзҳ</param>
        /// <returns>IList<Model.CategoryManager>ͼ</returns>
        public IList<Model.CategoryManager> GetCategoryBySuperiorId(int superiorId, PagerParameter pager)
        {
            return aut.SelectCategoryBySuperiorId(superiorId, pager);
        }

        /// <summary>
        /// ͨIDѯϢ
        /// </summary>
        /// <param name="categoryId"></param>
        /// <returns>IList<Model.CategoryManager>ͼ</returns>
        public IList<Model.CategoryManager> GetCategoryList(int categoryId)
        {
            return aut.SelectCategoryList(categoryId);
        }

        /// <summary>
        /// Ϣ
        /// </summary>
        /// <param name="categoryManager"></param>
        /// <returns>CategoryManager</returns>
        public int AddCategory(Model.CategoryManager categoryManager)
        {
            return aut.InsertCategory(categoryManager);
        }

        /// <summary>
        /// ޸ķϢ
        /// </summary>
        /// <param name="categoryManager"></param>
        /// <returns>CategoryManager</returns>
        public int ModifyCategory(Model.CategoryManager categoryManager)
        {
            return aut.UpdateCategory(categoryManager);
        }

        /// <summary>
        /// ɾϢ
        /// </summary>
        /// <param name="categoryId"></param>
        /// <returns>categoryId</returns>
        public int RemoveCategory(int categoryId)
        {
            return aut.DeleteCategory(categoryId);
        }

        /// <summary>
        /// ͨϼĿ¼ѯϢ
        /// </summary>
        /// <param name="superiorId">ϼĿ¼</param>
        /// <returns>superiorId</returns>
        public int GetCategoryCountBySuperiorId(int superiorId)
        {
            //
            SqlParameter parm = new SqlParameter("@SuperiorId", SqlDbType.Int);
            //ֵ
            parm.Value = superiorId;

            //SqlHelper෽ִݿ
            return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure,
                                           "Tengfei_SelectCategoryCountBySuperiorId", parm));
        }

        public Model.CategoryManager GetCategory(int categoryId)
        {
            return aut.SelectCategory(categoryId);
        }

        #endregion
    }
}
