using System;
using System.Collections.Generic;
using System.Text;
using IBLL;
using Model;

namespace BLL
{
    public class CollectionBookCyclostyle:IBLL.ICollectionBookCyclostyle
    {
        #region ICollectionBookCyclostyle Ա
        IDAL.ICollectionBookCyclostyle dal = DALFactory.DataAccess.CreateCollectionBookCyclostyle();

        /// <summary>
        /// ͨ鼮ɼIDѯϢ
        /// </summary>
        /// <param name="collectionCyclostyleID">鼮ɼID</param>
        /// <returns>Model.CollectionBookCyclostyle</returns>
        public Model.CollectionBookCyclostyle GetCollectionBookCyclostyle(int collectionCyclostyleID)
        {
            return dal.SelectCollectionBookCyclostyle(collectionCyclostyleID);
        }

        /// <summary>
        /// ѯ鼮ɼϢ
        /// </summary>
        /// <param name="pager">ִзҳ</param>
        /// <returns>IList<Model.CollectionBookCyclostyle>ͼ</returns>
        public IList<Model.CollectionBookCyclostyle> GetCollectionBookCyclostyleList(PagerParameter pager)
        {
            return dal.SelectCollectionBookCyclostyleList(pager);
        }

        /// <summary>
        /// 鼮ɼϢ
        /// </summary>
        /// <param name="collectionBookCyclostyle">鼮ɼ</param>
        /// <returns>Model.CollectionBookCyclostyle</returns>
        public int AddCollectionBookCyclostyle(Model.CollectionBookCyclostyle collectionBookCyclostyle)
        {
            return dal.InsertCollectionBookCyclostyle(collectionBookCyclostyle);
        }

        /// <summary>
        /// ޸鼮ɼϢ
        /// </summary>
        /// <param name="collectionBookCyclostyle">鼮ɼ</param>
        /// <returns></returns>
        public int ModifyCollectionBookCyclostyle(Model.CollectionBookCyclostyle collectionBookCyclostyle)
        {
            return dal.UpdateCollectionBookCyclostyle(collectionBookCyclostyle);
        }

        /// <summary>
        /// ɾ鼮ɼϢ
        /// </summary>
        /// <param name="collectionCyclostyleID">鼮ɼID</param>
        /// <returns>Model.CollectionBookCyclostyle</returns>
        public int RemoveCollectionBookCyclostyle(int collectionCyclostyleID)
        {
            return dal.DeleteCollectionBookCyclostyle(collectionCyclostyleID);
        }

        #endregion
    }
}
