using System;
using System.Collections.Generic;
using System.Text;
using IBLL;
using Model;

namespace BLL
{
    public class CollectionCyclostyle:IBLL.ICollectionCyclostyle
    {
        #region ICollectionCyclostyle Ա
        IDAL.ICollectionCyclostyle acdal = DALFactory.DataAccess.CreateCollectionCyclostyle();

        /// <summary>
        /// ͨͨɼIDѯϢ
        /// </summary>
        /// <param name="cyclostyleID">ͨɼID</param>
        /// <returns>Model.CollectionCyclostyle</returns>
        public Model.CollectionCyclostyle GetCollectionCyclostyle(int cyclostyleID)
        {
            return acdal.SelectCollectionCyclostyle(cyclostyleID);
        }

        /// <summary>
        /// ѯͨɼϢ
        /// </summary>
        /// <param name="pager">ִзҳ</param>
        /// <returns>IList<Model.CollectionCyclostyle>ͼ</returns>
        public IList<Model.CollectionCyclostyle> GetCollectionCyclostyleList(PagerParameter pager)
        {
            return acdal.SelectCollectionCyclostyleList(pager);
        }

        /// <summary>
        /// ͨɼϢ
        /// </summary>
        /// <param name="collectionCyclostyle">ͨɼ</param>
        /// <returns>Model.CollectionCyclostyle</returns>
        public int AddCollectionCyclostyle(Model.CollectionCyclostyle collectionCyclostyle)
        {
            return acdal.InsertCollectionCyclostyle(collectionCyclostyle);
        }

        /// <summary>
        /// ޸ͨɼϢ
        /// </summary>
        /// <param name="collectionCyclostyle">ͨɼ</param>
        /// <returns>Model.CollectionCyclostyle</returns>
        public int ModifyCollectionCyclostyle(Model.CollectionCyclostyle collectionCyclostyle)
        {
            return acdal.UpdateCollectionCyclostyle(collectionCyclostyle);
        }

        /// <summary>
        /// ɾͨɼϢ
        /// </summary>
        /// <param name="collectionCyclostyle">ͨɼID</param>
        /// <returns>collectionCyclostyle</returns>
        public int RemoveCollectionCyclostyle(int collectionCyclostyle)
        {
            return acdal.DeleteCollectionCyclostyle(collectionCyclostyle);
        }

        #endregion
    }
}
