using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Text;
using DBUtility;

namespace BLL
{
    public class Comments : IBLL.IComments
    {
        #region IComments Ա

        IDAL.IComments dal = DALFactory.DataAccess.CreateComments();

        public IList<Model.Comments> GetComments(Model.PagerParameter pager)
        {
            return dal.SelectComments(pager);
        }

        public IList<Model.Comments> GetCommentsByBookId(int bookId, Model.PagerParameter pager)
        {
            return dal.SelectCommentsByBookId(bookId, pager);
        }

        public int GetCommentsCount()
        {
            return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, 
                                    CommandType.StoredProcedure,
                                    "Tengfei_GetCommentsCount", null));
        }
        public int AddComments(Model.Comments comments)
        {
            return dal.InsertComments(comments);
        }

        public int ModifyComments(Model.Comments comments)
        {
            return dal.UpdateComments(comments);
        }

        public int RemoveComments(int commentsId)
        {
            return dal.DeleteComments(commentsId);
        }
        public int GetCommentsCountByBookId(int BookId)
        {
            return dal.SelectCommentsCountByBookId(BookId);
        }
        public int CommentsTop(int commentsId)
        {
            SqlParameter parm = new SqlParameter("@CommentsId",SqlDbType.Int);
            parm.Value = commentsId;
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_CommentsTop", parm);
        }
        public int CommentsNotTop(int commentsId)
        {
            SqlParameter parm = new SqlParameter("@CommentsId",SqlDbType.Int);
            parm.Value = commentsId;
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_CommentsNotTop", parm);
        }
        public int CommentsAudit(int commentsId)
        {
            SqlParameter parm = new SqlParameter("@CommentsId", SqlDbType.Int);
            parm.Value = commentsId;
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_CommentsAudit", parm);
        }
        public int CommentsNotAudit(int commentsId)
        {
            SqlParameter parm = new SqlParameter("@CommentsId", SqlDbType.Int);
            parm.Value = commentsId;
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_CommentsNotAudit", parm);
        }
        public int CommentsHighlights(int commentsId)
        {
            SqlParameter parm = new SqlParameter("@CommentsId", SqlDbType.Int);
            parm.Value = commentsId;
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_CommentsHighlights", parm);
        }

        public int CommentsNotHighlights(int commentsId)
        {
            SqlParameter parm = new SqlParameter("@CommentsId", SqlDbType.Int);
            parm.Value = commentsId;
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_CommentsNotHighlights", parm);
        }

        #endregion
    }
}
