using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using IBLL;
using Model;
using DBUtility;

namespace BLL
{
    public class MemberGroup:IBLL.IMemberGroup
    {
        #region IMemberGroup Ա

        IDAL.IMemberGroup dal = DALFactory.DataAccess.CreateMemberGroup();
        public IList<Model.MemberGroup> GetAllMemberGroup(PagerParameter pager)
        {
            return dal.SelectMemberGroup(pager);
        }
        public IList<Model.MemberGroup> GetAllMemberGroup()
        {
            return dal.SelectAllMemberGroup();
        }
        public Model.MemberGroup GetMemberGroupById(int memberGroupId)
        {
            return dal.SelectMemberGroupById(memberGroupId);
        }
        public Model.MemberGroup GetNextMemberGroupById(int memberGroupId)
        {
            return dal.SelectNextMemberGroupById(memberGroupId);
        }
        public int AddMemberGroup(Model.MemberGroup memberGroup)
        {
            return dal.InsertMemberGroup(memberGroup);
        }

        public int ModifyMemberGroup(Model.MemberGroup memberGroup)
        {
            return dal.UpdateMemberGroup(memberGroup);
        }
        public int GetMaxRatingInMemberGroup()
        {
            return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectMaxRatingInMemberGroup", null));
        }
        public int RemoveMemberGroup(int memberGroupId)
        {
            return dal.DeleteMemberGroup(memberGroupId);
        }
      
        #endregion
    }
}
