using System;
using System.Collections.Generic;
using System.Text;

namespace BLL
{
    public class Sections:IBLL.ISections
    {
     
        IDAL.ISections dal = DALFactory.DataAccess.CreateSections();

        #region ISections Ա

        /// <summary>
        /// ѯ½
        /// </summary>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Sections>ͼ</returns>
        public IList<Model.Sections> GetSections(Model.PagerParameter pager)
        {
            return dal.SelectSections(pager);
        }

        /// <summary>
        /// ͨ½Idѯ½
        /// </summary>
        /// <param name="sectionsId">½ڱ</param>
        /// <returns>һModel.Sections</returns>
        public Model.Sections GetSectionsById(int sectionsId)
        {
            return dal.SelectSectionsById(sectionsId);
        }

        /// <summary>
        /// ͨŲѯ½
        /// </summary>
        /// <param name="volumeId"></param>
        /// <returns>IList<Model.Sections>ͼ</returns>
        public IList<Model.Sections> GetSectionsByvolumeId(int volumeId)
        {
            return dal.SelectSectionsByvolumeId(volumeId);
        }

        /// <summary>
        /// ѯµ½
        /// </summary>
        /// <param name="startTime">ʼѯʱ</param>
        /// <param name="endTime">ѯʱ</param>
        /// <returns>IList<Model.Sections>ͼ</returns>
        public IList<Model.Sections> GetSectionsToday(string startTime, string endTime)
        {
            return dal.SelectSectionsToday(startTime, endTime);
        }

        /// <summary>
        /// ͨIdѯ½
        /// </summary>
        /// <param name="volumeId">ID</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<RecdCategory>ͼ</returns>
        public IList<Model.Sections> GetSectionsByvolumeId(int volumeId, Model.PagerParameter pager)
        {
            return dal.SelectSectionsByvolumeId(volumeId,pager);
        }

        /// <summary>
        /// ½
        /// </summary>
        /// <param name="sections">Model.Sections½ڵĲ</param>
        /// <returns>ز</returns>
        public int AddSections(Model.Sections sections)
        {
            return dal.InsertSections(sections);
        }

        /// <summary>
        /// ½Ϣ
        /// </summary>
        /// <param name="sections">½ϢModel.Sectionsִи½Ϣʱ</param>
        /// <returns>ظ½</returns>
        public int ModifySections(Model.Sections sections)
        {
            return dal.UpdateSections(sections);
        }

        /// <summary>
        /// ɾ½
        /// </summary>
        /// <param name="sectionsId">½ڱ</param>
        /// <returns>ɾ½</returns>
        public int RemoveSections(int sectionsId)
        {
            return dal.DeleteSections(sectionsId);
        }

        /// <summary>
        /// ͨ鼮Idѯ½
        /// </summary>
        /// <param name="bookId">鼮</param>
        /// <returns>IList<Model.Sections>ͼ</returns>
        public IList<Model.Sections> GetSectionsByBookId(int bookId, Model.PagerParameter pager)
        {
            return dal.SelectSectionsByBookId(bookId,pager);
        }

        /// <summary>
        /// ѯδ½
        /// </summary>
        /// <param name="StateAudit">½״̬</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Sections>ͼ</returns>
        public IList<Model.Sections> GetSectionsByStateAudit(int StateAudit, Model.PagerParameter pager)
        {
            return dal.SelectSectionsByStateAudit(StateAudit,pager);
        }

        /// <summary>
        /// ȡ
        /// </summary>
        /// <param name="startTime">ʼʱ</param>
        /// <param name="endTime">ʱ</param>
        /// <param name="count">ָ</param>
        /// <returns>IList<Model.Sections>ͼ</returns>
        public IList<Model.Sections> GetSectionsTodayTop(string startTime, string endTime, int count)
        {
            return dal.SelectSectionsTodayTop(startTime, endTime, count);
        }

        #endregion
    }
}
