using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using DBUtility;
using DAL;
using IDAL;

namespace DAL
{
    public class Book:IDAL.IBook
    {

        #region IBook Ա
        /// <summary>
        /// ѯָ¼
        /// </summary>
        /// <param name="count">¼</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> SelectTopBookList(int count)
        {
            //Book
            Model.Book book = null;
            //IList<Model.Book>
            IList<Model.Book> bookList = new List<Model.Book>();
            //
            SqlParameter parm = new SqlParameter("@Count", SqlDbType.Int);
            //ֵ
            parm.Value = count;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure,
                                                        "Tengfei_SelectTopBookList", parm);
            while (sdr.Read())
            {
                //ʼ췽
                book = new Model.Book(sdr.GetInt32(0), sdr.GetString(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4),
                                    sdr.GetString(5), sdr.GetInt32(6), sdr.GetString(7), sdr.GetString(8), sdr.GetString(9),
                                    sdr.GetInt32(10), sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14),
                                    sdr.GetInt32(15), sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetString(19), sdr.GetDateTime(20));
                //Ͷӵͼ
                bookList.Add(book);
            }
            //IList<Model.Book>
            return bookList;
        }
        /// <summary>
        /// 鼮IDѯ鼮
        /// </summary>
        /// <param name="categoryId">鼮Id</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> SelectBookListByCategoryId(int categoryId, Model.PagerParameter pager)
        {
            //Book
            Model.Book book = null;
            //IList<Book>
            IList<Model.Book> bookList = new List<Model.Book>();
            //
            SqlParameter[] parm ={new SqlParameter("@startIndex",SqlDbType.Int),
                                  new SqlParameter("@endIndex",SqlDbType.Int),
                                  new SqlParameter("@docount",SqlDbType.Bit),
                                  new SqlParameter("@CategoryId",SqlDbType.Int)};
            //鸳ֵ
            parm[0].Value = pager.StartIndex;
            parm[1].Value = pager.EndIndex;
            parm[2].Value = pager.Docount;
            parm[3].Value = categoryId;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectBookListByCateogry", parm);
            while (sdr.Read())
            {
                //ʼ췽
                book = new Model.Book(sdr.GetInt32(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4), sdr.GetString(5),
                            sdr.GetString(6), sdr.GetInt32(7), sdr.GetString(8), sdr.GetString(9), sdr.GetString(10),
                            sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14), sdr.GetInt32(15),
                            sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetInt32(19), sdr.GetString(20), sdr.GetDateTime(21));
                //Ͷӵͼ
                bookList.Add(book);
            }
            //IList<Model.Book>
            return bookList;
        }

        /// <summary>
        /// ѯ鼮Ϣ
        /// </summary>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> BookList(Model.PagerParameter pager)
        {
            //Book
            Model.Book book = null;
            //IList<Book>
            IList<Model.Book> bookList = new List<Model.Book>();
            //
            SqlParameter[] parm ={new SqlParameter("@startIndex",SqlDbType.Int),
                                  new SqlParameter("@endIndex",SqlDbType.Int),
                                  new SqlParameter("@docount",SqlDbType.Bit)};
            //鸳ֵ
            parm[0].Value = pager.StartIndex;
            parm[1].Value = pager.EndIndex;
            parm[2].Value = pager.Docount;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectAllBook", parm);
            while (sdr.Read())
            {
                //ʼ췽
                book = new Model.Book(sdr.GetInt32(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4), sdr.GetString(5),
                            sdr.GetString(6), sdr.GetInt32(7), sdr.GetString(8), sdr.GetString(9), sdr.GetString(10),
                            sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14), sdr.GetInt32(15),
                            sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetInt32(19), sdr.GetString(20), sdr.GetDateTime(21));
                //Ͷӵͼ
                bookList.Add(book);
            }
            //IList<Model.Book>
            return bookList;
        }

        /// <summary>
        /// ͨ鼮ѯ鼮Ϣ
        /// </summary>
        /// <param name="bookId">Ҫѯ鼮ID</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public Model.Book SelectBookById(int bookId)
        {
            //Book
            Model.Book book = null;
            //
            SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);
            //鸳ֵ
            parm.Value = bookId;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectBookById", parm);

            while (sdr.Read())
            {
                book = new Model.Book(sdr.GetInt32(0), sdr.GetString(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4),
                            sdr.GetString(5), sdr.GetInt32(6), sdr.GetString(7), sdr.GetString(8), sdr.GetString(9),
                            sdr.GetInt32(10), sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14),
                            sdr.GetInt32(15), sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetString(19), sdr.GetDateTime(20));
            }

            //book
            return book;


        }

        /// <summary>
        /// 鼮ѯϢ
        /// </summary>
        /// <param name="title">鼮</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> SelectBookByTitle(string title, Model.PagerParameter pager)
        {
            //Book
            Model.Book book = null;
            //IList<Book>
            IList<Model.Book> bookList = new List<Model.Book>();
            //
            SqlParameter[] parm ={new SqlParameter("@startIndex",SqlDbType.Int),
                                  new SqlParameter("@endIndex",SqlDbType.Int),
                                  new SqlParameter("@docount",SqlDbType.Bit),
                                  new SqlParameter("@Title",SqlDbType.NVarChar)};
            //鸳ֵ
            parm[0].Value = pager.StartIndex;
            parm[1].Value = pager.EndIndex;
            parm[2].Value = pager.Docount;
            parm[3].Value = title;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectBookByTitle", parm);
            while (sdr.Read())
            {
                //ʼ췽
                book = new Model.Book(sdr.GetInt32(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4), sdr.GetString(5),
                            sdr.GetString(6), sdr.GetInt32(7), sdr.GetString(8), sdr.GetString(9), sdr.GetString(10),
                            sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14), sdr.GetInt32(15),
                            sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetInt32(19), sdr.GetString(20), sdr.GetDateTime(21));
                //Ͷӵͼ
                bookList.Add(book);
            }
            //IList<Model.Book>
            return bookList;
        }

        /// <summary>
        /// ûѯ鼮
        /// </summary>
        /// <param name="userName">û</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> SelectBookByUser(string userName, Model.PagerParameter pager)
        {
            //Book
            Model.Book book = null;
            //IList<Book>
            IList<Model.Book> bookList = new List<Model.Book>();
            //
            SqlParameter[] parm ={new SqlParameter("@startIndex",SqlDbType.Int),
                                  new SqlParameter("@endIndex",SqlDbType.Int),
                                  new SqlParameter("@docount",SqlDbType.Bit),
                                  new SqlParameter("@UserName",SqlDbType.NVarChar)};
            //鸳ֵ
            parm[0].Value = pager.StartIndex;
            parm[1].Value = pager.EndIndex;
            parm[2].Value = pager.Docount;
            parm[3].Value = userName;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectBookByUser", parm);
            while (sdr.Read())
            {
                //ʼ췽
                book = new Model.Book(sdr.GetInt32(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4), sdr.GetString(5),
                            sdr.GetString(6), sdr.GetInt32(7), sdr.GetString(8), sdr.GetString(9), sdr.GetString(10),
                            sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14), sdr.GetInt32(15),
                            sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetInt32(19), sdr.GetString(20), sdr.GetDateTime(21));
                //Ͷӵͼ
                bookList.Add(book);
            }
            //IList<Model.Book>
            return bookList;
        }

        /// <summary>
        /// ͨBookͶ,鼮Ϣӵݿ 
        /// </summary>
        /// <param name="book">鼮ϢModel.BookͶ</param>
        /// <returns>ز</returns>
        public int InsertBook(Model.Book book)
        {
            SqlParameter[] parm ={ new SqlParameter("@BookName",SqlDbType.NVarChar),
                                   new SqlParameter("@Author",SqlDbType.NVarChar),
                                   new SqlParameter("@UserName",SqlDbType.NVarChar),
                                   new SqlParameter("@Images",SqlDbType.NVarChar),
                                   new SqlParameter("@Protagonists",SqlDbType.NVarChar),
                                   new SqlParameter("@StateAudit",SqlDbType.Int),
                                   new SqlParameter("@Process",SqlDbType.NVarChar),
                                   new SqlParameter("@Nature",SqlDbType.NVarChar),
                                   new SqlParameter("@Authorized",SqlDbType.NVarChar),
                                   new SqlParameter("@TotalClick",SqlDbType.Int),
                                   new SqlParameter("@MonthClick",SqlDbType.Int),
                                   new SqlParameter("@WeekClick",SqlDbType.Int),
                                   new SqlParameter("@DayClick",SqlDbType.Int),
                                   new SqlParameter("@RecommendedNum",SqlDbType.Int),
                                   new SqlParameter("@BigCategoryID",SqlDbType.Int),
                                   new SqlParameter("@SmallCategoryID",SqlDbType.Int),
                                   new SqlParameter("@FirstIssue",SqlDbType.Int),
                                   new SqlParameter("@CollectionNum",SqlDbType.Int),
                                   new SqlParameter("@BookIntroduction",SqlDbType.NVarChar),
                                     new SqlParameter("@AddTime",SqlDbType.DateTime)
                               };

            //SqlParameterĲ
            parm[0].Value = book.BookName;
            parm[1].Value = book.Author;
            parm[2].Value = book.UserName;
            parm[3].Value = book.Images;
            parm[4].Value = book.Protagonists;
            parm[5].Value = book.StateAudit;
            parm[6].Value = book.Process;
            parm[7].Value = book.Nature;
            parm[8].Value = book.Authorized;
            parm[9].Value = book.TotalClick;
            parm[10].Value = book.MonthClick;
            parm[11].Value = book.WeekClick;
            parm[12].Value = book.DayClick;
            parm[13].Value = book.RecommendedNum;
            parm[14].Value = book.BigCategoryID;
            parm[15].Value = book.SmallCategoryID;
            parm[16].Value = book.FirstIssue;
            parm[17].Value = book.CollectionNum;
            parm[18].Value = book.BookIntroduction;
            parm[19].Value = book.AddTime;
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                            "Tengfei_InsertBook", parm);



        }

        /// <summary>
        /// ͨ鼮ִɾ鼮
        /// </summary>
        /// <param name="bookId">鼮ID</param>
        /// <returns>ɾ</returns>
        public int DeleteBook(int bookId)
        {
            SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);
            parm.Value = bookId;
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                             "Tengfei_DeleteBook", parm);
        }

        /// <summary>
        /// 鼮Ϣ
        /// </summary>
        /// <param name="book">Model.Bookṩִи²Ĳ</param>
        /// <returns>ظµ</returns>
        public int UpdateBook(Model.Book book)
        {


            SqlParameter[] parm ={ new SqlParameter("@BookId",SqlDbType.Int),
                                   new SqlParameter("@BookName",SqlDbType.NVarChar),
                                   new SqlParameter("@Author",SqlDbType.NVarChar),
                                   new SqlParameter("@UserName",SqlDbType.NVarChar),
                                   new SqlParameter("@Images",SqlDbType.NVarChar),
                                   new SqlParameter("@Protagonists",SqlDbType.NVarChar),
                                   new SqlParameter("@StateAudit",SqlDbType.Int),
                                   new SqlParameter("@Process",SqlDbType.NVarChar),
                                   new SqlParameter("@Nature",SqlDbType.NVarChar),
                                   new SqlParameter("@Authorized",SqlDbType.NVarChar),
                                   new SqlParameter("@TotalClick",SqlDbType.Int),
                                   new SqlParameter("@MonthClick",SqlDbType.Int),
                                   new SqlParameter("@WeekClick",SqlDbType.Int),
                                   new SqlParameter("@DayClick",SqlDbType.Int),
                                   new SqlParameter("@RecommendedNum",SqlDbType.Int),
                                   new SqlParameter("@BigCategoryID",SqlDbType.Int),
                                   new SqlParameter("@SmallCategoryID",SqlDbType.Int),
                                   new SqlParameter("@FirstIssue",SqlDbType.Int),
                                   new SqlParameter("@CollectionNum",SqlDbType.Int),
                                   new SqlParameter("@BookIntroduction",SqlDbType.NVarChar),
                                   new SqlParameter("@AddTime",SqlDbType.DateTime)
                               };

            //SqlParameterĲ
            parm[0].Value = book.BookId;
            parm[1].Value = book.BookName;
            parm[2].Value = book.Author;
            parm[3].Value = book.UserName;
            parm[4].Value = book.Images;
            parm[5].Value = book.Protagonists;
            parm[6].Value = book.StateAudit;
            parm[7].Value = book.Process;
            parm[8].Value = book.Nature;
            parm[9].Value = book.Authorized;
            parm[10].Value = book.TotalClick;
            parm[11].Value = book.MonthClick;
            parm[12].Value = book.WeekClick;
            parm[13].Value = book.DayClick;
            parm[14].Value = book.RecommendedNum;
            parm[15].Value = book.BigCategoryID;
            parm[16].Value = book.SmallCategoryID;
            parm[17].Value = book.FirstIssue;
            parm[18].Value = book.CollectionNum;
            parm[19].Value = book.BookIntroduction;
            parm[20].Value = book.AddTime;

            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                         "Tengfei_UpdateBook", parm);





        }
        /// <summary>
        /// ͨIdѯµ鼮
        /// </summary>
        /// <param name="bigCategoryID">ID</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> SelectBookByCategoryId(int bigCategoryID, Model.PagerParameter pager)
        {
            //Book
            Model.Book book = null;
            //IList<Book>
            IList<Model.Book> bookList = new List<Model.Book>();
            //
            SqlParameter[] parm ={new SqlParameter("@startIndex",SqlDbType.Int),
                                  new SqlParameter("@endIndex",SqlDbType.Int),
                                  new SqlParameter("@docount",SqlDbType.Bit),
                                  new SqlParameter("@CategoryID",SqlDbType.Int)};
            //鸳ֵ
            parm[0].Value = pager.StartIndex;
            parm[1].Value = pager.EndIndex;
            parm[2].Value = pager.Docount;
            parm[3].Value = bigCategoryID;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectAllBookByCategoryID", parm);
            while (sdr.Read())
            {
                //ʼ췽
                book = new Model.Book(sdr.GetInt32(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4), sdr.GetString(5),
                            sdr.GetString(6), sdr.GetInt32(7), sdr.GetString(8), sdr.GetString(9), sdr.GetString(10),
                            sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14), sdr.GetInt32(15),
                            sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetInt32(19), sdr.GetString(20), sdr.GetDateTime(21));
                //Ͷӵͼ
                bookList.Add(book);
            }
            //IList<Model.Book>
            return bookList;
        }
        /// <summary>
        /// 鼮IDûϲѯ鼮Ϣ
        /// </summary>
        /// <param name="bigCategoryID"></param>
        /// <param name="UserName">û</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> SelectBookByCategoryId_UserName(int bigCategoryID, string UserName, Model.PagerParameter pager)
        {
            //Book
            Model.Book book = null;
            //IList<Book>
            IList<Model.Book> bookList = new List<Model.Book>();
            //
            SqlParameter[] parm ={ new SqlParameter("@CategoryID",SqlDbType.Int),
                                   new SqlParameter("@UserName",SqlDbType.NVarChar),
                                   new SqlParameter("@startIndex",SqlDbType.Int),
                                   new SqlParameter("@endIndex",SqlDbType.Int),
                                   new SqlParameter("@docount",SqlDbType.Bit)};
            //鸳ֵ
            parm[0].Value = bigCategoryID;
            parm[1].Value = UserName;
            parm[2].Value = pager.StartIndex;
            parm[3].Value = pager.EndIndex;
            parm[4].Value = pager.Docount;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectBookByCategoryId_UserName", parm);
            while (sdr.Read())
            {
                //ʼ췽
                book = new Model.Book(sdr.GetInt32(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4), sdr.GetString(5),
                            sdr.GetString(6), sdr.GetInt32(7), sdr.GetString(8), sdr.GetString(9), sdr.GetString(10),
                            sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14), sdr.GetInt32(15),
                            sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetInt32(19), sdr.GetString(20), sdr.GetDateTime(21));
                //Ͷӵͼ
                bookList.Add(book);
            }
            //IList<Model.Book>
            return bookList;
        }


        /// <summary>
        /// ѯ鼮Ϣ
        /// </summary>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> SelectAllBook()
        {
            //Book
            Model.Book book = null;
            //IList<Book>
            IList<Model.Book> bookList = new List<Model.Book>();


            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectBook");
            while (sdr.Read())
            {
                //ʼ췽
                book = new Model.Book(sdr.GetInt32(0), sdr.GetString(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4),
                            sdr.GetString(5), sdr.GetInt32(6), sdr.GetString(7), sdr.GetString(8), sdr.GetString(9),
                            sdr.GetInt32(10), sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14),
                            sdr.GetInt32(15), sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetString(19), sdr.GetDateTime(20));
                //Ͷӵͼ
                bookList.Add(book);
            }
            //IList<Model.Book>
            return bookList;
        }
        /// <summary>
        /// ѯ鼮Ϣ
        /// </summary>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> SelectAllBook(Model.PagerParameter pager)
        {
            //Book
            Model.Book book = null;
            //IList<Book>
            IList<Model.Book> bookList = new List<Model.Book>();

            SqlParameter[] parm ={new SqlParameter("@startIndex",SqlDbType.Int),
                                  new SqlParameter("@endIndex",SqlDbType.Int),
                                  new SqlParameter("@docount",SqlDbType.Bit)};
            parm[0].Value = pager.StartIndex;
            parm[1].Value = pager.EndIndex;
            parm[2].Value = pager.Docount;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectAllBookByPager", parm);
            while (sdr.Read())
            {
                //ʼ췽
                book = new Model.Book(sdr.GetInt32(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4), sdr.GetString(5),
                            sdr.GetString(6), sdr.GetInt32(7), sdr.GetString(8), sdr.GetString(9), sdr.GetString(10),
                            sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14), sdr.GetInt32(15),
                            sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetInt32(19), sdr.GetString(20), sdr.GetDateTime(21));
                //Ͷӵͼ
                bookList.Add(book);
            }
            //IList<Model.Book>
            return bookList;
        }

        /// <summary>
        /// ߲ѯ鼮
        /// </summary>
        /// <param name="author">û</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> SelectBookByAuthor(string author, Model.PagerParameter pager)
        {
            //Book
            Model.Book book = null;
            //IList<Book>
            IList<Model.Book> bookList = new List<Model.Book>();
            //
            SqlParameter[] parm ={ new SqlParameter("@Author",SqlDbType.NVarChar),
                                   new SqlParameter("@startIndex",SqlDbType.Int),
                                   new SqlParameter("@endIndex",SqlDbType.Int),
                                   new SqlParameter("@docount",SqlDbType.Bit)};
            //鸳ֵ
            parm[0].Value = author;
            parm[1].Value = pager.StartIndex;
            parm[2].Value = pager.EndIndex;
            parm[3].Value = pager.Docount;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SearchBookByAuthor", parm);
            while (sdr.Read())
            {
                //ʼ췽
                book = new Model.Book(sdr.GetInt32(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4), sdr.GetString(5),
                            sdr.GetString(6), sdr.GetInt32(7), sdr.GetString(8), sdr.GetString(9), sdr.GetString(10),
                            sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14), sdr.GetInt32(15),
                            sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetInt32(19), sdr.GetString(20), sdr.GetDateTime(21));
                //Ͷӵͼ
                bookList.Add(book);
            }
            //IList<Model.Book>
            return bookList;
        }

        /// <summary>
        /// 鼮ѯ鼮
        /// </summary>
        /// <param name="title">鼮</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> SelectBookWithTitle(string title)
        {
            //Book
            Model.Book book = null;
            //IList<Book>
            IList<Model.Book> bookList = new List<Model.Book>();
            //
            SqlParameter parm = new SqlParameter("@Title", SqlDbType.NVarChar);
            //鸳ֵ
            parm.Value = title;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectBookWithTitle", parm);
            while (sdr.Read())
            {
                //ʼ췽
                book = new Model.Book(sdr.GetInt32(0), sdr.GetString(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4),
                            sdr.GetString(5), sdr.GetInt32(6), sdr.GetString(7), sdr.GetString(8), sdr.GetString(9),
                            sdr.GetInt32(10), sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14),
                            sdr.GetInt32(15), sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetString(19), sdr.GetDateTime(20));
                //Ͷӵͼ
                bookList.Add(book);
            }
            //IList<Model.Book>
            return bookList;
        }
        
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public IList<Model.Book> SelectBookByTotalClick()
        {
            //Book
            Model.Book book = null;
            //IList<Book>
            IList<Model.Book> bookList = new List<Model.Book>();

            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectTotalClickSort");
            while (sdr.Read())
            {
                //ʼ췽
                book = new Model.Book(sdr.GetInt32(0), sdr.GetString(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4),
                            sdr.GetString(5), sdr.GetInt32(6), sdr.GetString(7), sdr.GetString(8), sdr.GetString(9),
                            sdr.GetInt32(10), sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14),
                            sdr.GetInt32(15), sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetString(19), sdr.GetDateTime(20));
                //Ͷӵͼ
                bookList.Add(book);
            }
            //IList<Model.Book>
            return bookList;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public IList<Model.Book> SelectBookByTotalRecd()
        {
            //Book
            Model.Book book = null;
            //IList<Book>
            IList<Model.Book> bookList = new List<Model.Book>();
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                     CommandType.StoredProcedure,
                                                     "Tengfei_SelectTotalRecdSort");
            while (sdr.Read())
            {
                //ʼ췽
                book = new Model.Book(sdr.GetInt32(0), sdr.GetString(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4),
                            sdr.GetString(5), sdr.GetInt32(6), sdr.GetString(7), sdr.GetString(8), sdr.GetString(9),
                            sdr.GetInt32(10), sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14),
                            sdr.GetInt32(15), sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetString(19), sdr.GetDateTime(20));
                //Ͷӵͼ
                bookList.Add(book);
            }
            //IList<Model.Book>
            return bookList;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public IList<Model.Book> SelectBookByTotalcollection()
        {
            //Book
            Model.Book book = null;
            //IList<Book>
            IList<Model.Book> bookList = new List<Model.Book>();
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                     CommandType.StoredProcedure,
                                                     "Tengfei_SelectTotalCollectionSort");
            while (sdr.Read())
            {
                //ʼ췽
                book = new Model.Book(sdr.GetInt32(0), sdr.GetString(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4),
                            sdr.GetString(5), sdr.GetInt32(6), sdr.GetString(7), sdr.GetString(8), sdr.GetString(9),
                            sdr.GetInt32(10), sdr.GetInt32(11), sdr.GetInt32(12), sdr.GetInt32(13), sdr.GetInt32(14),
                            sdr.GetInt32(15), sdr.GetInt32(16), sdr.GetInt32(17), sdr.GetInt32(18), sdr.GetString(19), sdr.GetDateTime(20));
                //Ͷӵͼ
                bookList.Add(book);
            }
            //IList<Model.Book>
            return bookList;
        }

        #endregion
    }
}
