using System;
using System.Collections.Generic;
using System.Text;
using IDAL;
using Model;
using DBUtility;
using System.Data.SqlClient;
using System.Data;

namespace DAL
{
    public class CollectionBookCyclostyle:IDAL.ICollectionBookCyclostyle
    {
        #region ICollectionBookCyclostyle Ա

        /// <summary>
        /// ܹ鼮ģidѯ鼮Ϣ
        /// </summary>
        /// <param name="collectionCyclostyleID">鼮ģid</param>
        /// <returns></returns>
        public Model.CollectionBookCyclostyle SelectCollectionBookCyclostyle(int collectionCyclostyleID)
        {
            //Model.CollectionBookCyclostyle
            Model.CollectionBookCyclostyle collectionBookCyclostyle = null;
            //
            SqlParameter parm = new SqlParameter("@CollectionCyclostyleID",SqlDbType.Int);
            //ֵ
            parm.Value = collectionCyclostyleID;

            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectCollectionBookCyclostyle",parm);
            while (sdr.Read())
            {
                //ʼ췽
                collectionBookCyclostyle = new Model.CollectionBookCyclostyle(sdr.GetInt32(0), sdr.GetString(1),
                    sdr.GetString(2), sdr.GetString(3), sdr.GetInt32(4), sdr.GetString(5));
            }
            //Model.CollectionBookCyclostyle
            return collectionBookCyclostyle;
        }

        /// <summary>
        /// ѯ鼮Ϣ
        /// </summary>
        /// <param name="pager">ִзҳ</param>
        /// <returns></returns>
        public IList<Model.CollectionBookCyclostyle> SelectCollectionBookCyclostyleList(PagerParameter pager)
        {
            //Model.CollectionBookCyclostyle
            Model.CollectionBookCyclostyle collectionBookCyclostyle = null;
            //IList<Model.CollectionBookCyclostyle>
            IList<Model.CollectionBookCyclostyle> collectionBookCyclostyleList = new List<Model.CollectionBookCyclostyle>();
            //SqlHelper෽ִݿ
            SqlParameter[] parm = { new SqlParameter("@startIndex",SqlDbType.Int),
                                    new SqlParameter("@endIndex",SqlDbType.Int),
                                    new SqlParameter("@docount",SqlDbType.Bit)};
            //鸳ֵ
            parm[0].Value = pager.StartIndex;
            parm[1].Value = pager.EndIndex;
            parm[2].Value = pager.Docount;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                     "Tengfei_SelectCollectionBookCyclostyleList", parm);
            while (sdr.Read())
            {
                //ʼ췽
                collectionBookCyclostyle = new Model.CollectionBookCyclostyle(sdr.GetInt32(1), sdr.GetString(2),
                    sdr.GetString(3), sdr.GetString(4), sdr.GetInt32(5), sdr.GetString(6));
                //Ͷӵͼ
                collectionBookCyclostyleList.Add(collectionBookCyclostyle);
            }
            //IList<CollectionBookCyclostyle>
            return collectionBookCyclostyleList;
        }

        /// <summary>
        /// 鼮ģϢ
        /// </summary>
        /// <param name="collectionBookCyclostyle">ִ鼮ģ</param>
        /// <returns></returns>
        public int InsertCollectionBookCyclostyle(Model.CollectionBookCyclostyle collectionBookCyclostyle)
        {
            //
            SqlParameter[] parm = {new SqlParameter("@CollectionCyclostyleName",SqlDbType.NVarChar),
                                   new SqlParameter("@ReadBook",SqlDbType.NVarChar),
                                   new SqlParameter("@CollectionAddress",SqlDbType.NVarChar),
                                   new SqlParameter("@CollectionBookID",SqlDbType.Int),
                                   new SqlParameter("@CollectionContentAddress",SqlDbType.NVarChar)};
            //鸳ֵ
            parm[0].Value = collectionBookCyclostyle.CollectionCyclostyleName;
            parm[1].Value = collectionBookCyclostyle.ReadBook;
            parm[2].Value = collectionBookCyclostyle.CollectionAddress;
            parm[3].Value = collectionBookCyclostyle.CollectionBookID;
            parm[4].Value = collectionBookCyclostyle.CollectionContentAddress;

            //SqlHelper෽ִݿ
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                        "Tengfei_InsertCollectionBookCyclostyle", parm);
        }

        /// <summary>
        /// ޸鼮ģϢ
        /// </summary>
        /// <param name="collectionBookCyclostyle">ִ鼮ģ</param>
        /// <returns></returns>
        public int UpdateCollectionBookCyclostyle(Model.CollectionBookCyclostyle collectionBookCyclostyle)
        {
            //
            SqlParameter[] parm = {new SqlParameter("@CollectionCyclostyleID",SqlDbType.Int),
                                   new SqlParameter("@CollectionCyclostyleName",SqlDbType.NVarChar),
                                   new SqlParameter("@ReadBook",SqlDbType.NVarChar),
                                   new SqlParameter("@CollectionAddress",SqlDbType.NVarChar),
                                   new SqlParameter("@CollectionBookID",SqlDbType.Int),
                                   new SqlParameter("@CollectionContentAddress",SqlDbType.NVarChar)};
            //鸳ֵ
            parm[0].Value = collectionBookCyclostyle.CollectionCyclostyleID;
            parm[1].Value = collectionBookCyclostyle.CollectionCyclostyleName;
            parm[2].Value = collectionBookCyclostyle.ReadBook;
            parm[3].Value = collectionBookCyclostyle.CollectionAddress;
            parm[4].Value = collectionBookCyclostyle.CollectionBookID;
            parm[5].Value = collectionBookCyclostyle.CollectionContentAddress;

            //SqlHelper෽ִݿ
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                        "Tengfei_UpdateCollectionBookCyclostyle", parm);
        }

        /// <summary>
        /// ɾ鼮ģϢ
        /// </summary>
        /// <param name="collectionCyclostyleID">鼮ģid</param>
        /// <returns></returns>
        public int DeleteCollectionBookCyclostyle(int collectionCyclostyleID)
        {
            //
            SqlParameter parm = new SqlParameter("@CollectionCyclostyleID", SqlDbType.Int);
            //ֵ
            parm.Value = collectionCyclostyleID;

            //SqlHelper෽ִݿ
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                             "Tengfei_DeleteCollectionBookCyclostyle", parm);
        }

        #endregion
    }
}
