using System;
using System.Collections.Generic;
using System.Text;
using IDAL;
using Model;
using DBUtility;
using System.Data.SqlClient;
using System.Data;

namespace DAL
{
    public class NewsCollection:IDAL.INewsCollection
    {
        #region INewsCollection Ա

        /// <summary>
        /// ѯɼϢ
        /// </summary>
        /// <param name="pager">ִзҳ</param>
        /// <returns></returns>
        public IList<Model.NewsCollection> SelectNewsCollection(PagerParameter pager)
        {
            //Model.NewsCollection
            Model.NewsCollection newsCollection = null;
            //IList<Model.NewsCollection>
            IList<Model.NewsCollection> modelNewsCollection = new List<Model.NewsCollection>();
            //
            SqlParameter[] parm = { new SqlParameter("@startIndex",SqlDbType.Int),
                                    new SqlParameter("@endIndex",SqlDbType.Int),
                                    new SqlParameter("@docount",SqlDbType.Bit)};
            //鸳ֵ
            parm[0].Value = pager.StartIndex;
            parm[1].Value = pager.EndIndex;
            parm[2].Value = pager.Docount;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                     "Tengfei_SelectNewsCollection", parm);
            while (sdr.Read())
            {
                //ʼ췽
                newsCollection = new Model.NewsCollection(sdr.GetInt32(1), sdr.GetString(2), sdr.GetString(3), sdr.GetString(4));
                modelNewsCollection.Add(newsCollection);
            }
            //IList<Model.NewsCollection>
            return modelNewsCollection;
        }

        /// <summary>
        /// ӲɼϢ
        /// </summary>
        /// <param name="newsCollection">ɼݶ</param>
        /// <returns></returns>
        public int InsertNewsCollection(Model.NewsCollection newsCollection)
        {
            //
            SqlParameter[] parm ={ new SqlParameter("@NewsTitle",SqlDbType.NVarChar),
                                   new SqlParameter("@NewsURL",SqlDbType.NVarChar),
                                   new SqlParameter("@NewsBody",SqlDbType.NVarChar)};
            //鸳ֵ
            parm[0].Value = newsCollection.NewsTitle;
            parm[1].Value = newsCollection.NewsURL;
            parm[2].Value = newsCollection.NewsBody;

            //SqlHelper෽ִݿ
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                        "Tengfei_InsertNewsCollection", parm);
        }

        /// <summary>
        /// ݲɼݱŲѯϢ
        /// </summary>
        /// <param name="newsCollection">ɼݱ</param>
        /// <returns></returns>
        public Model.NewsCollection SelectNews(int newsCollection)
        {
            //newsCollection
            Model.NewsCollection newsCollections = null;
            //
            SqlParameter parm = new SqlParameter("@NewsId", SqlDbType.Int);
            //ֵ
            parm.Value = newsCollection;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectNews", parm);
            while (sdr.Read())
            {
                //ʼ췽
                newsCollections = new Model.NewsCollection(sdr.GetInt32(0), sdr.GetString(1), sdr.GetString(2), sdr.GetString(3));
            }
            //newsCollection
            return newsCollections;
        }

        #endregion
    }
}