using System;
using System.Collections.Generic;
using System.Text;
using IDAL;
using DBUtility;
using System.Data;
using System.Data.SqlClient;

namespace DAL
{
    public class Sections : IDAL.ISections
    {
        #region ISections Ա
        /// <summary>
        /// ѯ½
        /// </summary>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Sections>ͼ</returns>
        public IList<Model.Sections> SelectSections(Model.PagerParameter pager)
        {
            //Model.Sections
            Model.Sections sections = null;

            //IList<RecdCategory>
            IList<Model.Sections> sectionsList = new List<Model.Sections>();

            //
            SqlParameter[] parm ={new SqlParameter("@startIndex",SqlDbType.Int),
                                  new SqlParameter("@endIndex",SqlDbType.Int),
                                  new SqlParameter("@docount",SqlDbType.Bit)};
            //鸳ֵ
            parm[0].Value = pager.StartIndex;
            parm[1].Value = pager.EndIndex;
            parm[2].Value = pager.Docount;

            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectAllSections", parm);
            while (sdr.Read())
            {
                //ʼ췽
                sections = new Model.Sections(sdr.GetInt32(1), sdr.GetInt32(2), sdr.GetString(3),
                           sdr.GetInt32(4), sdr.GetString(5), sdr.GetDateTime(6), sdr.GetInt32(7));
                //Ͷӵͼ
                sectionsList.Add(sections);
            }
            //IList<Model.Sections>
            return sectionsList;
        }
        /// <summary>
        /// ͨ½Idѯ½
        /// </summary>
        /// <param name="sectionsId">½ڱ</param>
        /// <returns>һModel.Sections</returns>
        public Model.Sections SelectSectionsById(int sectionsId)
        {
            //Model.Sections
            Model.Sections sections = null;
            //
            SqlParameter parm = new SqlParameter("@SectionId", SqlDbType.Int);
            //鸳ֵ
            parm.Value = sectionsId;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectSectionsById", parm);
            while (sdr.Read())
            {

                //ʼ췽
                sections = new Model.Sections(sdr.GetInt32(0), sdr.GetInt32(1), sdr.GetString(2),
                                       sdr.GetInt32(3), sdr.GetString(4), sdr.GetDateTime(5), sdr.GetInt32(6));
            }
            //һModel.Sections
            return sections;
        }

        /// <summary>
        /// ͨ鼮Idѯ½
        /// </summary>
        /// <param name="bookId">鼮</param>
        /// <returns>IList<Model.Sections>ͼ</returns>
        public IList<Model.Sections> SelectSectionsByBookId(int bookId, Model.PagerParameter pager)
        {
            //Model.Sections
            Model.Sections sections = null;

            //IList<RecdCategory>
            IList<Model.Sections> sectionsList = new List<Model.Sections>();

            //
            SqlParameter[] parm ={new SqlParameter("@startIndex",SqlDbType.Int),
                                  new SqlParameter("@endIndex",SqlDbType.Int),
                                  new SqlParameter("@docount",SqlDbType.Bit),
                                   new SqlParameter("@BookId",SqlDbType.Int) };
            //鸳ֵ
            parm[0].Value = pager.StartIndex;
            parm[1].Value = pager.EndIndex;
            parm[2].Value = pager.Docount;
            parm[3].Value = bookId;

            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectSectionsByBookId", parm);
            while (sdr.Read())
            {
                //ʼ췽
                sections = new Model.Sections(sdr.GetInt32(1), sdr.GetInt32(2), sdr.GetString(3),
                           sdr.GetInt32(4), sdr.GetString(5), sdr.GetDateTime(6), sdr.GetInt32(7));
                //Ͷӵͼ
                sectionsList.Add(sections);
            }
            //IList<Model.Sections>
            return sectionsList;
        }
        /// <summary>
        /// ͨŲѯ½
        /// </summary>
        /// <param name="volumeId"></param>
        /// <returns>IList<Model.Sections>ͼ</returns>
        public IList<Model.Sections> SelectSectionsByvolumeId(int volumeId)
        {
            //Model.Sections
            Model.Sections sections = null;

            //IList<Model.Sections>
            IList<Model.Sections> sectionsList = new List<Model.Sections>();
            SqlParameter parm = new SqlParameter("@VolumeId", SqlDbType.Int);
            parm.Value = volumeId;

            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectSectionsByVolumeIdNotPager", parm);
            while (sdr.Read())
            {
                //ʼ췽
                sections = new Model.Sections(sdr.GetInt32(0), sdr.GetInt32(1), sdr.GetString(2),
                                         sdr.GetInt32(3), sdr.GetString(4), sdr.GetDateTime(5), sdr.GetInt32(6));
                //Ͷӵͼ
                sectionsList.Add(sections);
            }
            //IList<Model.Sections>
            return sectionsList;
        }

        /// <summary>
        /// ͨIdѯ½
        /// </summary>
        /// <param name="volumeId">ID</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<RecdCategory>ͼ</returns>
        public IList<Model.Sections> SelectSectionsByvolumeId(int volumeId, Model.PagerParameter pager)
        {
            //Model.Sections
            Model.Sections sections = null;

            //IList<Model.Sections>
            IList<Model.Sections> sectionsList = new List<Model.Sections>();

            //
            SqlParameter[] parm ={new SqlParameter("@startIndex",SqlDbType.Int),
                                  new SqlParameter("@endIndex",SqlDbType.Int),
                                  new SqlParameter("@docount",SqlDbType.Bit),
                                   new SqlParameter("@VolumeId",SqlDbType.Int)};
            //鸳ֵ
            parm[0].Value = pager.StartIndex;
            parm[1].Value = pager.EndIndex;
            parm[2].Value = pager.Docount;
            parm[3].Value = volumeId;

            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectSectionsByvolumeId", parm);
            while (sdr.Read())
            {
                //ʼ췽
                sections = new Model.Sections(sdr.GetInt32(1), sdr.GetInt32(2), sdr.GetString(3),
                                         sdr.GetInt32(4), sdr.GetString(5), sdr.GetDateTime(6), sdr.GetInt32(7));
                //Ͷӵͼ
                sectionsList.Add(sections);
            }
            //IList<Model.Sections>
            return sectionsList;
        }

        /// <summary>
        /// ½
        /// </summary>
        /// <param name="sections">Model.Sections½ڵĲ</param>
        /// <returns>ز</returns>
        public int InsertSections(Model.Sections sections)
        {
            SqlParameter[] parm ={ new SqlParameter("@VolumeId",SqlDbType.Int),
                                   new SqlParameter("@SectionTitle",SqlDbType.NVarChar),
                                   new SqlParameter("@CharNum",SqlDbType.Int),
                                   new SqlParameter("@Contents",SqlDbType.NText),
                                   new SqlParameter("@AddTime",SqlDbType.DateTime),
                                   new SqlParameter("@StateAudit",SqlDbType.Int)
                               };

            //SqlParameterĲ
            parm[0].Value = sections.VolumeId;
            parm[1].Value = sections.SectionTitle;
            parm[2].Value = sections.CharNum;
            parm[3].Value = sections.Contents;
            parm[4].Value = sections.AddTime;
            parm[5].Value = sections.StateAudit;



            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                             "Tengfei_InsertSections", parm);
        }

        /// <summary>
        /// ½Ϣ
        /// </summary>
        /// <param name="sections">½ϢModel.Sectionsִи½Ϣʱ</param>
        /// <returns>ظ½</returns>
        public int UpdateSections(Model.Sections sections)
        {
            SqlParameter[] parm ={  new SqlParameter("@SectionId",SqlDbType.Int),
                                   new SqlParameter("@VolumeId",SqlDbType.Int),
                                   new SqlParameter("@SectionTitle",SqlDbType.NVarChar),
                                   new SqlParameter("@CharNum",SqlDbType.Int),
                                   new SqlParameter("@Contents",SqlDbType.NText),
                                   new SqlParameter("@AddTime",SqlDbType.DateTime),
                                   new SqlParameter("@StateAudit",SqlDbType.Int)
                               };

            //SqlParameterĲ
            parm[0].Value = sections.SectionId;
            parm[1].Value = sections.VolumeId;
            parm[2].Value = sections.SectionTitle;
            parm[3].Value = sections.CharNum;
            parm[4].Value = sections.Contents;
            parm[5].Value = sections.AddTime;
            parm[6].Value = sections.StateAudit;

            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                 "Tengfei_UpdateSections", parm);

        }

        /// <summary>
        /// ɾ½
        /// </summary>
        /// <param name="sectionsId">½ڱ</param>
        /// <returns>ɾ½</returns>
        public int DeleteSections(int sectionsId)
        {

            //
            SqlParameter parm = new SqlParameter("@SectionId", SqlDbType.Int);
            //鸳ֵ
            parm.Value = sectionsId;
            //SqlHelper෽ִݿ
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_DeleteSections", parm);

        }

        /// <summary>
        /// ѯδ½
        /// </summary>
        /// <param name="StateAudit">½״̬</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Sections>ͼ</returns>
        public IList<Model.Sections> SelectSectionsByStateAudit(int StateAudit, Model.PagerParameter pager)
        {

            //Model.Sections
            Model.Sections sections = null;

            //IList<RecdCategory>
            IList<Model.Sections> sectionsList = new List<Model.Sections>();

            //
            SqlParameter[] parm ={new SqlParameter("@startIndex",SqlDbType.Int),
                                  new SqlParameter("@endIndex",SqlDbType.Int),
                                  new SqlParameter("@docount",SqlDbType.Bit),
                                  new SqlParameter("@StateAudit",SqlDbType.Int)};
            //鸳ֵ
            parm[0].Value = pager.StartIndex;
            parm[1].Value = pager.EndIndex;
            parm[2].Value = pager.Docount;
            parm[3].Value = StateAudit;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectSectionsByStateAudit", parm);
            while (sdr.Read())
            {
                //ʼ췽
                sections = new Model.Sections(sdr.GetInt32(1), sdr.GetInt32(2), sdr.GetString(3),
                           sdr.GetInt32(4), sdr.GetString(5), sdr.GetDateTime(6), sdr.GetInt32(7));
                //Ͷӵͼ
                sectionsList.Add(sections);
            }
            //IList<Model.Sections>
            return sectionsList;
        }
        /// <summary>
        /// ѯµ½
        /// </summary>
        /// <param name="startTime">ʼѯʱ</param>
        /// <param name="endTime">ѯʱ</param>
        /// <returns>IList<Model.Sections>ͼ</returns>
        public IList<Model.Sections> SelectSectionsToday(string startTime, string endTime)
        {
            //Model.Sections
            Model.Sections sections = null;

            //IList<RecdCategory>
            IList<Model.Sections> sectionsList = new List<Model.Sections>();

            //
            SqlParameter[] parm ={new SqlParameter("@startTime",SqlDbType.NVarChar),
                                  new SqlParameter("@endTime",SqlDbType.NVarChar) };
            //鸳ֵ
            parm[0].Value = startTime;
            parm[1].Value = endTime;

            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectSectionToday", parm);
            while (sdr.Read())
            {
                //ʼ췽
                sections = new Model.Sections(sdr.GetInt32(0), sdr.GetInt32(1), sdr.GetString(2),
                           sdr.GetInt32(3), sdr.GetString(4), sdr.GetDateTime(5), sdr.GetInt32(6));
                //Ͷӵͼ
                sectionsList.Add(sections);
            }
            //IList<Model.Sections>
            return sectionsList;
        }

        public IList<Model.Sections> SelectSectionsTodayTop(string startTime, string endTime, int count)
        {
            //Model.Sections
            Model.Sections sections = null;

            //IList<RecdCategory>
            IList<Model.Sections> sectionsList = new List<Model.Sections>();
            //
            SqlParameter[] parm ={ new SqlParameter("@StartTime", SqlDbType.NVarChar),
                                   new SqlParameter("@EndTime",SqlDbType.NVarChar),
                                   new SqlParameter("@Count",SqlDbType.Int)};
            //鸳ֵ
            parm[0].Value = startTime;
            parm[1].Value = endTime;
            parm[2].Value = count;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectSectionTodayTop", parm);
            while (sdr.Read())
            {
                //ʼ췽
                sections = new Model.Sections(sdr.GetInt32(0), sdr.GetInt32(1), sdr.GetString(2),
                           sdr.GetInt32(3), sdr.GetString(4), sdr.GetDateTime(5), sdr.GetInt32(6));
                //Ͷӵͼ
                sectionsList.Add(sections);
            }
            //IList<Model.Sections>
            return sectionsList;
        }

        #endregion
    }
}
