using System;
using System.Collections.Generic;
using System.Text;
using Model;

namespace IDAL
{
    public interface IBook
    {
        /// <summary>
        /// ѯ鼮Ϣ
        /// </summary>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        IList<Book> BookList(PagerParameter pager);

        /// <summary>
        /// ѯָ¼
        /// </summary>
        /// <param name="count">¼</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        IList<Book> SelectTopBookList(int count);


        /// <summary>
        /// ͨ鼮Idѯ鼮
        /// </summary>
        /// <param name="bookId">鼮ID</param>
        /// <returns>Model.Book</returns>
        Book SelectBookById(int bookId);


        /// <summary>
        /// ͨ鼮ѯ鼮
        /// </summary>
        /// <param name="title">鼮</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        IList<Book> SelectBookByTitle(string title, PagerParameter pager);

        /// <summary>
        /// ͨûѯ鼮
        /// </summary>
        /// <param name="userName">û</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        IList<Book> SelectBookByUser(string userName, PagerParameter pager);

        /// <summary>
        /// ߲ͨѯ鼮
        /// </summary>
        /// <param name="author">û</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        IList<Book> SelectBookByAuthor(string author, PagerParameter pager);

        /// <summary>
        /// ͨIdѯ鼮
        /// </summary>
        /// <param name="categoryId">ID</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        IList<Book> SelectBookListByCategoryId(int categoryId, PagerParameter pager);

        /// <summary>
        /// ͨidѯ鼮
        /// </summary>
        /// <param name="bigCategoryID"></param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        IList<Book> SelectBookByCategoryId(int bigCategoryID, PagerParameter pager);

        /// <summary>
        /// ͨ鼮źûѯ鼮Ϣ
        /// </summary>
        /// <param name="bigCategoryID"></param>
        /// <param name="UserName">û</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        IList<Book> SelectBookByCategoryId_UserName(int bigCategoryID, string UserName, PagerParameter pager);

        /// <summary>
        /// 鼮Ϣ
        /// </summary>
        /// <param name="book">Model.Book,鼮ʱĲ</param>
        /// <returns>鼮</returns>
        int InsertBook(Book book);

        /// <summary>
        /// 鼮ɾ鼮
        /// </summary>
        /// <param name="bookId">鼮</param>
        /// <returns>ɾ鼮</returns>
        int DeleteBook(int bookId);

        /// <summary>
        /// 鼮Ϣ
        /// </summary>
        /// <param name="book">Model.Book,鼮ϢʱĲ</param>
        /// <returns>ظ鼮</returns>
        int UpdateBook(Book book);

        /// <summary>
        /// ѯ鼮Ϣ
        /// </summary>
        /// <returns>IList<Model.Book>ͼ</returns>
        IList<Book> SelectAllBook();

        /// <summary>
        /// ѯ鼮Ϣ
        /// </summary>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        IList<Book> SelectAllBook(PagerParameter pager);

        /// <summary>
        /// 鼮ģѯ鼮
        /// </summary>
        /// <param name="title">鼮</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        IList<Book> SelectBookWithTitle(string title);

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        IList<Book> SelectBookByTotalClick();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        IList<Book> SelectBookByTotalRecd();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        IList<Book> SelectBookByTotalcollection();
    }
}
