﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.IO;
using System.Text;
using DBUtility;

/// <summary>
/// common 的摘要说明
/// </summary>
public class common
{
    public static void DropDownListBind(DropDownList dropdownlist, string dataTextField, string dataValueField, string connectionString, CommandType cmdType, string cmdText, params SqlParameter[] parm)
    {
        SqlDataReader sdr = SqlHelper.ExecuteReader(connectionString, cmdType, cmdText,parm);
        dropdownlist.DataTextField = dataTextField;
        dropdownlist.DataValueField = dataValueField;
        dropdownlist.DataSource = sdr;
        dropdownlist.DataBind();
        sdr.Close();
    }
    public static void DropDownListBind(DropDownList dropdownlist, string dataTextField, string dataValueField, string connectionString, CommandType cmdType, string cmdText)
    {
        SqlDataReader sdr = SqlHelper.ExecuteReader(connectionString, cmdType, cmdText);
        dropdownlist.DataTextField = dataTextField;
        dropdownlist.DataValueField = dataValueField;
        dropdownlist.DataSource = sdr;
        dropdownlist.DataBind();
        sdr.Close();
    }
    public static int ValidateUser(string userName)
    {
        SqlParameter parm = new SqlParameter("@UserName", SqlDbType.NVarChar);
        parm.Value = userName;
        return (int)SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure,
                                            "Tengfei_ValidateUser", parm);
    }
    public static int InsetMemberGroupToTree(string Text,int linkId)
    {
        SqlParameter[] parm ={new SqlParameter("@Text",SqlDbType.NVarChar),
                              new SqlParameter("@LinkId",SqlDbType.Int)};
        parm[0].Value = Text;
        parm[1].Value = linkId;
        return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_InsertMemberGroupOnTree_Admin", parm);
    }

    /// <summary>
    /// 添加数据时将信息插入分类管理树节点下
    /// </summary>
    /// <param name="Text">文本内容</param>
    /// <param name="linkId">树节点ID</param>
    /// <returns></returns>
    public static int InsertCategoryToTree(string Text, int linkId)
    {
        SqlParameter[] parm ={new SqlParameter("@Text",SqlDbType.NVarChar),
                              new SqlParameter("@LinkId",SqlDbType.Int)};
        parm[0].Value = Text;
        parm[1].Value = linkId;
        return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_InsertCategoryOnTree_Admin", parm);
    }
    public static int InsertCategoryToTree(string Text,int parentId, int linkId)
    {
        SqlParameter[] parm ={new SqlParameter("@Text",SqlDbType.NVarChar),
                              new SqlParameter("@LinkId",SqlDbType.Int),
                              new SqlParameter("@ParentId",SqlDbType.Int)};
        parm[0].Value = Text;
        parm[1].Value = linkId;
        parm[2].Value = parentId;
        return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_InsertCategoryOnTree", parm);
    }
    public static int InsertRedCategoryToTree(string Text,int linkId)
    {
        SqlParameter[] parm ={new SqlParameter("@Text",SqlDbType.NVarChar),
                              new SqlParameter("@LinkId",SqlDbType.Int)};
        parm[0].Value = Text;
        parm[1].Value = linkId;
        return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_InsertRedCategoryToTree", parm);
    }

    /// <summary>
    /// 添加数据时将信息插入书籍管理树节点下
    /// </summary>
    /// <param name="Text">文本内容</param>
    /// <param name="linkId">树节点ID</param>
    /// <returns></returns>
    public static int InsertCategoryToTree_Admin(string Text,int linkId)
    {
        SqlParameter[] parm={new SqlParameter("@Text",SqlDbType.NVarChar),
                             new SqlParameter("@LinkId",SqlDbType.Int)};
        parm[0].Value = Text;
        parm[1].Value = linkId;
        return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_InsertCategoryToTree", parm);
    }
    public static string GetMemberGroupName(int memberGroupId)
    {
        SqlParameter parm = new SqlParameter("@MemberGroupId", SqlDbType.Int);
        parm.Value = memberGroupId;
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetMemberGroupNameById", parm);
        string memberGroupName = "";
        while (sdr.Read())
        {
            memberGroupName= sdr.GetString(0);
        }
        sdr.Close();
        return memberGroupName;
    }
    public static string GetAuthorityName(int id)
    {
        SqlParameter parm = new SqlParameter("@Id", SqlDbType.Int);
        parm.Value = id;
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectAuthorityNameByIdInTree", parm);
        string authorityName = "";
        while (sdr.Read())
        {
             authorityName = sdr.GetString(0);
        }
        sdr.Close();
        return authorityName;
    }
    public static int GetBookCountByAuthor(string author)
    {
        SqlParameter parm = new SqlParameter("@Author", SqlDbType.NVarChar);
        parm.Value = author;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectBookCountByAuthor", parm));
    }
    public static int GetBookCountByBookName(string bookName)
    {
        SqlParameter parm = new SqlParameter("@BookName", SqlDbType.NVarChar);
        parm.Value = bookName;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString,CommandType.StoredProcedure,"Tengfei_SelectBookCountByBookName",parm));
    }
    public static string GetCategoryManager(int superiorId)
    {
        SqlParameter parm = new SqlParameter("@SuperiorId", SqlDbType.Int);
        parm.Value = superiorId;
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectCategoryName", parm);
        string cat = "";
        while (sdr.Read())
        {
            cat = sdr.GetString(0);
        }
        sdr.Close();
        return cat;
    }
    public static string GetCategoryName(int CategoryId)
    {
        SqlParameter parm = new SqlParameter("@CategoryId", SqlDbType.Int);
        parm.Value = CategoryId;
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectCategoryNameById", parm);
        string categoryName="";
        while (sdr.Read())
        {
            categoryName = sdr.GetString(0);
        }
        sdr.Close();
        return categoryName;
    }
    public static string GetProvince(int provinceId)
    {
        SqlParameter parm = new SqlParameter("@ProvinceId", SqlDbType.Int);
        parm.Value = provinceId;
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetProvinceById", parm);
        string province = "";
        while (sdr.Read())
        {
            province = sdr.GetString(0);
        } 
        sdr.Close();
        return province;
    }
    public static string GetCity(int cityId)
    {
        SqlParameter parm = new SqlParameter("@CityId", SqlDbType.Int);
        parm.Value = cityId;
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetCityById", parm);
        string city = "";
        while (sdr.Read())
        {
             city = sdr.GetString(0);
        }
        sdr.Close();
        return city;
    }
    public static string GetArea(int areaId)
    {
        SqlParameter parm = new SqlParameter("@AreaId", SqlDbType.Int);
        parm.Value = areaId;
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetAreaById", parm);
        string area = "";
        while (sdr.Read())
        {
            area = sdr.GetString(0);
        }
        sdr.Close();
        return area;
    }
     public static string GetBookName(int BookId)
    {
        SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);
        parm.Value = BookId;
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectBookById", parm);
        string BookName = "";
        while (sdr.Read())
        {
            BookName = sdr.GetString(1);
        }
        sdr.Close();
        return BookName;
}
    public static string GetVolumeName(int VolumeId)
    {
        SqlParameter parm = new SqlParameter("@VolumeId", SqlDbType.Int);
        parm.Value = VolumeId;
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectVolumeByVolumeId", parm);
        string VolumeName = "";
        while (sdr.Read())
        {
            VolumeName = sdr.GetString(2);
        }
        sdr.Close();
        return VolumeName;
    }
    public static int GetAutomatismAuditingBook()
    {
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectSystemInfo");
        int AutoAudit = 0;
        while (sdr.Read())
        {
            AutoAudit = sdr.GetInt32(27);
        }
        sdr.Close();
        return AutoAudit;
    
    }
    public static int GetBookIdByVolumeId(int VolumeId)
    {
        SqlParameter parm = new SqlParameter("@VolumeId", SqlDbType.Int);
        parm.Value = VolumeId;
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectVolumeByVolumeId", parm);
        int BookId = 0;
        while (sdr.Read())
        {
            BookId = sdr.GetInt32(1);
        }
        sdr.Close();
        return BookId;
    }

    public static int GetBookCountByCategory(int categoryId)
    {
        SqlParameter parm = new SqlParameter("@CategoryId", SqlDbType.Int);
        parm.Value = categoryId;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectBookCountByCategory", parm));
    }

    public static int SetAuthorized(int BookId, int StateAudit)
    {
        SqlParameter[] parm = {new SqlParameter("@BookId", SqlDbType.Int),
                               new SqlParameter("@StateAudit", SqlDbType.Int)
                                };
        parm[0].Value = BookId;
        parm[1].Value = StateAudit;
        return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_UpdateBookAuthorized",parm);
    
    }    
    public static int DeleteBook(int BookId)
    {
        SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);
        parm.Value = BookId;
        return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_DeleteBook", parm);

    }  
    public static int DeleteSection(int SectionId)
    {
        SqlParameter parm = new SqlParameter("@SectionId", SqlDbType.Int);
        parm.Value = SectionId;
        return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_DeleteSections", parm);
    }
  
    public static int DeleteVolume(int VolumeId)
    {
        SqlParameter parm = new SqlParameter("@VolumeId", SqlDbType.Int);
        parm.Value = VolumeId;
        return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_DeleteVolume", parm);
    }
    public static int SetBookAuthorized(int BookId, int StateAudit)
    {
        SqlParameter[] parm = {new SqlParameter("@BookId", SqlDbType.Int),
                               new SqlParameter("@StateAudit", SqlDbType.Int)
                                };
        parm[0].Value = BookId;
        parm[1].Value = StateAudit;
        return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_UpdateBookAuthorized", parm);

    }
    public static int SetSectionAuthorized(int SectionId, int StateAudit)
    {
        SqlParameter[] parm = {new SqlParameter("@SectionId", SqlDbType.Int),
                               new SqlParameter("@StateAudit", SqlDbType.Int)
                                };
        parm[0].Value = SectionId;
        parm[1].Value = StateAudit;
        return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_UpdateSectionsAuthorized", parm);
    }

    public static int GetVolumeColumnsByBookId(int BookId)
    {
        SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);
        parm.Value = BookId;
        string str = SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectVolumeColumnsByBookId", parm).ToString();
        return Convert.ToInt32(str.ToString());
    }
    public static string GetVolumeIdListByBookId(int bookId)
    {
        string volumeIdList = null;
        SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);
        parm.Value = bookId;
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectVolumeIdByBookId", parm);
        while (sdr.Read())
        {
            int volumeId = sdr.GetInt32(0);
            volumeIdList = volumeId.ToString() + "," + volumeIdList;
        }
        sdr.Close();
        if (volumeIdList != null)
        {
            int startIndex = volumeIdList.LastIndexOf(",");
            volumeIdList = volumeIdList.Substring(0, startIndex);
        }
        return volumeIdList;
    }
    public static string GetRecdCategoryNameByRecdCategoryId(int RecdCategoryId)
    {
        SqlParameter parm = new SqlParameter("@RecdCategoryId", SqlDbType.Int);
        parm.Value = RecdCategoryId;
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectRecdCategoryById", parm);
        string RecdCategoryName = "";
        while (sdr.Read())
        {
            RecdCategoryName = sdr.GetString(1);
        }
        sdr.Close();
        return RecdCategoryName;
    }
    public static int GetBookCount()
    {
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectBookCount", null));
    }
    public static int GetAutomatismHTML()
    {
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectSystemInfo");
        int AutoHTML = 0;
        while (sdr.Read())
        {
            AutoHTML = sdr.GetInt32(26);
        }
        sdr.Close();
        return AutoHTML;
    }

    /// <summary>
    /// 实现保存，使其写入一个特定的文件夹中
    /// </summary>
    /// <param name="strNewsHtml">所有值</param>
    /// <param name="strOldHtml">显示值</param>
    /// <param name="strModeFilePath">模板路径</param>
    /// <param name="strPageFilePath">保存文件路径</param>
    /// <returns></returns>
    public static bool CreatHtmlPage(string[] strNewsHtml, string[] strOldHtml, string strModeFilePath, string strPageFilePath)
    {
        bool Flage = false;
        StreamReader ReaderFile = null;
        StreamWriter WrirteFile = null;
        string FilePath = HttpContext.Current.Server.MapPath(strModeFilePath);
        Encoding Code = Encoding.GetEncoding("gb2312");
        string strFile = string.Empty;
        try
        {
            ReaderFile = new StreamReader(FilePath, Code);
            strFile = ReaderFile.ReadToEnd();

        }
        catch (Exception ex)
        {
            throw ex;
        }
        finally
        {
            ReaderFile.Close();
        }
        try
        {
            int intLengTh = strNewsHtml.Length;
            for (int i = 0; i < intLengTh; i++)
            {
                strFile = strFile.Replace(strOldHtml[i], strNewsHtml[i]);
            }
            WrirteFile = new StreamWriter(HttpContext.Current.Server.MapPath(strPageFilePath), false, Code);
            WrirteFile.Write(strFile);
            Flage = true;
        }
        catch (Exception ex)
        {
            throw ex;
        }
        finally
        {

            WrirteFile.Flush();
            WrirteFile.Close();
        }
        return Flage;
    }
    public static int GetSectionsCountByVolumeId(int VolumeId)
    {
        SqlParameter parm = new SqlParameter("@VolumeId", SqlDbType.Int);
        parm.Value = VolumeId;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetSectionsCountByVolumeId", parm));
    }
    public static int GetBookCountByBigCategoryID(int CategoryID)
    {
        SqlParameter parm = new SqlParameter("@CategoryID", SqlDbType.Int);
        parm.Value = CategoryID;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetBookCountByBigCategoryID", parm));
    }
    public static int GetBookCountByBigCategoryID_UserName(int CategoryID, string UserName)
    {
        SqlParameter[] parm ={ new SqlParameter("@CategoryID", SqlDbType.Int),
                               new SqlParameter("@UserName", SqlDbType.NVarChar)};
        parm[0].Value = CategoryID;
        parm[1].Value = UserName;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetBookCountByBigCategoryID_UserName", parm));
    }
    public static int GetBookCountByUserName(string UserName)
    {
        SqlParameter parm = new SqlParameter("@UserName", SqlDbType.NVarChar);
        parm.Value = UserName;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetBookCountByUserName", parm));
    }
    public static int GetAllBookCount()
    {
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetAllBookCount", null));
    }
    public static int GetVolumeCountByBookId(int BookId)
    {
        SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);
        parm.Value = BookId;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetVolumeCountByBookId", parm));
    }
    public static int GetSectionCountInVolumeIdList(string VolumeIdList)
    {
        string sql_count = "select count(SectionId) from Sections where VolumeId in (" + VolumeIdList + ")";
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.Text, sql_count, null));
    }
    public static int GetAllRecdBookCount()
    {
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetAllRecdBookCount", null));
    }
    public static int GetSectionCountByStateAudit(int StateAudit)
    {
        SqlParameter parm = new SqlParameter("@StateAudit", SqlDbType.Int);
        parm.Value = StateAudit;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetSectionCountByStateAudit", parm));
    }
    public static int GetOrderNumByBookId(int OrderNum, int BookId)
    {
        SqlParameter[] parm ={ new SqlParameter("@OrderNum", SqlDbType.Int),
                               new SqlParameter("@BookId", SqlDbType.Int)};
        parm[0].Value = OrderNum;
        parm[1].Value = BookId;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetOrderNumByBookId", parm));
    }
    public static int GetSortByRecdCategoryId(int RecdCategoryId, int Sort)
    {
        SqlParameter[] parm ={ new SqlParameter("@RecdCategoryId", SqlDbType.Int),
                               new SqlParameter("@Sort", SqlDbType.Int)};
        parm[0].Value = RecdCategoryId;
        parm[1].Value = Sort;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetSortByRecdCategoryId", parm));
    }
    public static int GetRecdBookCountById(int RecdCategoryId)
    {
        SqlParameter parm = new SqlParameter("@RecdCategoryId", SqlDbType.Int);
        parm.Value = RecdCategoryId;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetRecdBookCountById", parm));
    }
    public static int GetNewBookCount()
    {
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectNewBookCount");
        int newBookCount=0;
        while (sdr.Read())
        {
            newBookCount = int.Parse(sdr.GetString(0));
        }
        sdr.Close();
        return newBookCount;
    }
    public static int GetRegistScore()
    {
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_RegistScore");
        int registScore = 0;
        while (sdr.Read())
        {
            registScore = sdr.GetInt32(0);
        }
        sdr.Close();
        return registScore;
    }
    public static int GetLoginScore()
    {
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_LoginScore");
        int loginScore =0;
        while (sdr.Read())
        {
            loginScore = sdr.GetInt32(0);
        }
        sdr.Close();
        return loginScore;
    }
    public static int GetCommentScore()
    {
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_CommentScore");
        int commentScore = 0;
        while (sdr.Read())
        {
            commentScore = sdr.GetInt32(0);
        }
        sdr.Close();
        return commentScore;
    }
    public static int GetFovBookCount(int memberGroupId)
    {
        SqlParameter parm = new SqlParameter("@MemberGroupId", SqlDbType.Int);
        parm.Value = memberGroupId;
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetFavBookCount", parm);
        int bookCount = 0;
        while (sdr.Read())
        {
            bookCount = sdr.GetInt32(0);
        }
        sdr.Close();
        return bookCount;
    }
    public static int GetBookCountByUser(string userName)
    {
        SqlParameter parm = new SqlParameter("@UserName", SqlDbType.NVarChar);
        parm.Value = userName;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetBookCountByUser", parm));
    }
    public static int GetSuperiorIdByBigCategoryID(int BigCategoryID)
    {
        SqlParameter parm = new SqlParameter("@BigCategoryID", SqlDbType.Int);
        parm.Value = BigCategoryID;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetSuperiorIdByBigCategoryID", parm));

    }
    public static int GetCountWhere(int categoryId)
    {
        SqlParameter parm = new SqlParameter("@CategoryManagerId", SqlDbType.Int);
        parm.Value = categoryId;
        return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectCategoryIsNull", parm));
    }
    public static int GetQianglieRecdCount()
    {
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectQianglieRecdCount");
        int num = 0;
        while (sdr.Read())
        {
            num = sdr.GetInt32(0);
        }
        sdr.Close();
        return num;
    }
    public static int GetBendiRecdCount()
    {
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectBenZhanRecdCount");
        int num = 0;
        while (sdr.Read())
        {
            num = sdr.GetInt32(0);
        }
        sdr.Close();
        return num;
    }
    public static int GetWebSiteStatus()
    {
        SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectWebSiteStatus");
        int satus = 0;
        while (sdr.Read())
        {
            satus = sdr.GetInt32(0);
        }
        sdr.Close();
        return satus;
    }
}
