﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;

public partial class Controls_Admin_Admin_Tree : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["UserName"] != null)
            {
                ProfileCommon p = Profile.GetProfile(Session["UserName"].ToString());
                string role = common.GetAuthorityName(p.Rating);
                if (role == "普通用户")
                {
                    Response.Redirect("/TengfeiWeb/Clientele/Cannot.aspx");
                }
                else
                {
                    buildTree();
                }
            }
            
        }
    }
    
    public DataSet GetData(string id)
    {
        SqlParameter parm = new SqlParameter("@ParentId", SqlDbType.Int);
        parm.Value = Convert.ToInt32(id);
        DataSet ds= SqlHelper.dataSet(SqlHelper.connectionString, CommandType.StoredProcedure,
                                           "Tengfei_SelectTreeNodeByParentId", parm);
        return ds;
    }
    //构建Tree
    private void buildTree()
    {
        string id = Request["id"];

            DataSet ds = GetData(id);
            DataTable dt = ds.Tables[0];
            foreach (DataRow row in dt.Rows)
            {
                TreeNode node = new TreeNode();
                node.Text = row["Text"].ToString();
                node.Value = row["id"].ToString();
                string smid = row["id"].ToString();
                this.TreeView_Admin.Nodes.Add(node);
                TravelTree(node, smid);
           }
    }

    //递归构建Tree
    private void TravelTree(TreeNode nodes, string id)
    {
        DataSet ds = GetData(id);
        DataTable dt = ds.Tables[0];
        foreach (DataRow row in dt.Rows)
        {
            TreeNode node = new TreeNode();
            node.Text = row["Text"].ToString();
            string treeID = row["id"].ToString();
            node.Value = treeID;
            string parentID = row["ParentId"].ToString();
            string linkId=row["LinkId"].ToString();

            if (treeID == "13")
            {
                node.NavigateUrl = "/TengfeiWeb/Clientele/Doing.aspx";
                node.Target = "mainFrame";
            }
            else if (parentID == "18")
            {
                node.NavigateUrl = "/TengfeiWeb/UserManage/SystemInfo.aspx?id=" + treeID;
                node.Target = "mainFrame";
            }
            else if (parentID=="19")
            {
                node.NavigateUrl = "/TengfeiWeb/UserManage/NewUser.aspx?id=" + linkId;
                node.Target = "mainFrame";
            }
            else if (treeID == "7")
            {
                node.NavigateUrl = "/TengfeiWeb/SystemManager/CategoryManager.aspx?id=" + int.Parse(treeID);
                node.Target = "mainFrame";
            }
            else if (treeID == "8")
            {
                node.NavigateUrl = "/TengfeiWeb/SystemManager/CategoryManager.aspx?id=" + int.Parse(treeID);
                node.Target = "mainFrame";
            }
            else if (treeID == "9")
            {
                node.NavigateUrl = "/TengfeiWeb/SystemManager/CategoryManager.aspx?id=" + int.Parse(treeID);
                node.Target = "mainFrame";
            }
            else if (treeID == "10")
            {
                node.NavigateUrl = "/TengfeiWeb/SystemManager/CategoryManager.aspx?id=" + int.Parse(treeID);
                node.Target = "mainFrame";
            }
            else if (treeID == "11")
            {
                node.NavigateUrl = "/TengfeiWeb/SystemManager/CategoryManager.aspx?id=" + int.Parse(treeID);
                node.Target = "mainFrame";
            }
            else if (treeID == "12")
            {
                node.NavigateUrl = "/TengfeiWeb/SystemManager/CategoryManager.aspx?id=" + int.Parse(treeID);
                node.Target = "mainFrame";
            }
            else if (treeID == "18")
            {
                node.NavigateUrl = "/TengfeiWeb/UserManage/SystemInfo.aspx";
                node.Target = "mainFrame";
            }
            else if (parentID == "59")
            {
                node.NavigateUrl = "/TengfeiWeb/BookManager/RecdBookInfo.aspx?Id="+linkId;
                node.Target = "mainFrame"; 
            }
            else if (treeID == "19")
            {
                node.NavigateUrl = "/TengfeiWeb/UserManage/MemberGroup.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "20")
            {
                node.NavigateUrl = "/TengfeiWeb/UserManage/NewUser.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "29")
            {
                node.NavigateUrl = "/TengfeiWeb/UserManage/NewUser.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "30")
            {
                node.NavigateUrl = "/TengfeiWeb/Clientele/Doing.aspx";
                node.Target = "mainFrame";
            }
            else if (parentID == "32")
            {
                node.NavigateUrl = "/TengfeiWeb/BookManager/BookInfoList.aspx?id=" + linkId;
                node.Target = "mainFrame";

            }
            else if (treeID == "14")
            {
                node.NavigateUrl = "/TengfeiWeb/SystemManager/Economy.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "15")
            {
                node.NavigateUrl = "/TengfeiWeb/SystemManager/Display.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "16")
            {
                node.NavigateUrl = "/TengfeiWeb/Category/Category.aspx?id=1";
                node.Target = "mainFrame";
            }
            else if (parentID == "16")
            {
                node.NavigateUrl = "/TengfeiWeb/Category/Category.aspx?id=" + Convert.ToInt32(linkId);
                node.Target = "mainFrame";
            }
            else if (treeID == "31")
            {
                node.NavigateUrl = "/TengfeiWeb/BookManager/BookInfoList.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "32")
            {
                node.NavigateUrl = "/TengfeiWeb/BookManager/BookInfoList.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "57")
            {
                node.NavigateUrl = "/TengfeiWeb/BookManager/AddBook.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "58")
            {
                node.NavigateUrl = "/TengfeiWeb/BookManager/WaitAudit.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "59")
            {
                node.NavigateUrl = "/TengfeiWeb/BookManager/RecdBookInfo.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "68")
            {
                node.NavigateUrl = "/TengfeiWeb/BookManager/RecdCategory.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "69")
            {
                node.NavigateUrl = "/TengfeiWeb/BookManager/CommentList.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "70")
            {
                node.NavigateUrl = "/TengfeiWeb/BookManager/BatchWork.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "72")
            {
                node.NavigateUrl = "/TengfeiWeb/DataCollection/BookTemplet.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "71")
            {
                node.NavigateUrl = "/TengfeiWeb/DataCollection/CommonCollection.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "128")
            {
                node.NavigateUrl = "/TengfeiWeb/DataCollection/AptitudeCollection.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "73")
            {
                node.NavigateUrl = "/TengfeiWeb/DataCollection/BookSum.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "74")
            {
                node.NavigateUrl = "/TengfeiWeb/DataCollection/MonthDotHit.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "75")
            {
                node.NavigateUrl = "/TengfeiWeb/DataCollection/DayDotHit.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "130")
            {
                node.NavigateUrl = "/TengfeiWeb/DataCollection/AptitudeCollection.aspx";
                node.Target = "mainFrame";
            }
            else if (treeID == "105")
            {
                node.ToolTip = "单击此节点将退出后台管理。";
                node.NavigateUrl = "/TengfeiWeb/Clientele/Index.aspx";
                node.Target = "_parent";
            }
            else if (treeID == "107")
            {
                node.ToolTip = "单击此节点获取最新树节点内容。";
                node.NavigateUrl = "/TengfeiWeb/Admin/Page_Left.aspx";
                node.Target = "leftFrame";
            }
            string smid = row["id"].ToString();
            nodes.ChildNodes.Add(node);
            TravelTree(node, smid);
        }

    }
 
}
