﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DBUtility;
using System.Collections.Generic;

public partial class Controls_AddRecdBook : System.Web.UI.UserControl
{
    /// <summary>
    /// 动态创建接口实例
    /// </summary>
    IBLL.IRecdBook recdBook = BLLFactory.BusinessLogic.CreateRecdBook();
    
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");

        if (!IsPostBack)
        {
           bind();
        }
    }

    /// <summary>
    /// 从数据库查询推荐类别绑定到下拉列表中
    /// </summary>
    public void bind()
    {
        common.DropDownListBind(ddlRecdBook, "RecdCategoryName", "RecdCategoryId",
              SqlHelper.connectionString, CommandType.StoredProcedure,
              "Tengfei_SelectRecdCategory");
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        //创建Model层RecdBook对象
        Model.RecdBook modelRecdBook = new Model.RecdBook();
        string str =this.txtBookName.Value;
        //判断推荐书籍是否选择，如果没有选择就提示用户选择推荐书籍
        if (str != "")
        {
            //将书籍信息按书籍编号ID和书籍名称截取开，
            int endIndex = str.IndexOf("|");
            string bookId = str.Substring(0, endIndex);
            int startIndex = endIndex + 1;
            int end = str.Length - startIndex;
            string bookName = str.Substring(startIndex, end);

            modelRecdBook.BookId = Convert.ToInt32(bookId);
            int RecdCategoryId = Convert.ToInt32(ddlRecdBook.SelectedValue);
            modelRecdBook.RecdCategoryId = RecdCategoryId;
            int Sort = Convert.ToInt32(txtSort.Text);
            modelRecdBook.Sort = Sort;
            modelRecdBook.RecdCategoryName = ddlRecdBook.SelectedItem.Text;

            //调用业务逻辑层方法查询该推荐类别下的顺序是否存在
            int Num = common.GetSortByRecdCategoryId(RecdCategoryId, Sort);
            if (Num == 0)
            {
                //调用方法执行新增推荐书籍的操作
                int IsOK = recdBook.AddRecdBook(modelRecdBook);
                if (IsOK == 0)
                {
                    Response.Write("<script>alert('添加推荐书籍失败!')</script>");
                }
                else
                {
                    Response.Write("<script>window.close()</script>");
                }
            }
            else
            {
                Response.Write("<Script>alert('该推荐类别中此顺序已存在,请重新输入!')</Script>");

            }
        }
        else
        {
            Response.Write("<script>alert('请选择要推荐的书籍!')</script>"); 
        }
    }
}
