﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using Model;
using DBUtility;

public partial class Controls_AddVolume : System.Web.UI.UserControl
{
    /// <summary>
    /// 动态创建业务逻辑层接口实例
    /// </summary>
    IBLL.IVolume volume = BLLFactory.BusinessLogic.CreateVolume();
    IBLL.IBook book = BLLFactory.BusinessLogic.CreateBook();

    /// <summary>
    /// 创建Model层Volume分类卷对象
    /// </summary>
    Model.Volume modelVolume = new Model.Volume();


    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");

        if (!IsPostBack)
        {
            //当前书籍编号ID
            ViewState["BookId"] = Convert.ToInt32(Request.QueryString["BookId"]);
            
            //获得书籍名称
            GetBookName();
        }
    }
    
    /// <summary>
    /// 根据书籍编号查询到书籍名称，并将书籍名称填充到TextBox控件中
    /// </summary>
    public void GetBookName()
    {
        int BookId = Convert.ToInt32(ViewState["BookId"]);
        Model.Book modelBook = new Model.Book();
        modelBook = book.GetBookById(BookId);
        txtBookName.Text = modelBook.BookName.ToString();
    }
   
    /// <summary>
    /// 将分类卷信息添加到分类卷信息表中去
    /// </summary>
 
    protected void btnSave_Click(object sender, EventArgs e)
    {
        int OrderNum=Convert.ToInt32(txtNum.Text.ToString());
        modelVolume.OrderNum = OrderNum;
        int BookId = Convert.ToInt32(ViewState["BookId"]);
        modelVolume.BookId = BookId;
        modelVolume.VolumeName = txtVolumeName.Text.ToString();

        //判断该书籍中的此分类卷顺序是否存在
        int Num=common.GetOrderNumByBookId(OrderNum,BookId);
        if (Num==0)
        {
            //执行新增分类卷操作，返回新增分类卷行数
            int IsOK = volume.AddVolume(modelVolume);
            if (IsOK != 0)
            {
                Response.Write("<Script>window.close()</Script>");
            }
            else
            {
                Response.Write("<Script>alert('添加分类卷失败!')</Script>");
            }
        }
        else
        {
            Response.Write("<Script>alert('卷顺序已存在,请重新输入!')</Script>");
        }
    }
}
