﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Windows.Forms;
using System.Collections.Generic;
using DBUtility;
using System.Data.SqlClient;
using Model;

public partial class Controls_BookInfo : System.Web.UI.UserControl
{

    /// <summary>
    /// 动态创建接口实例
    /// </summary>
    IBLL.IBook book = BLLFactory.BusinessLogic.CreateBook();
    IBLL.ICategoryManager categoryManager = BLLFactory.BusinessLogic.CreateCategoryManager();


    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");

        //判断Session["UserName"]是否为空，如果为空则跳转到登陆页面
        if (Session["UserName"] != null)
        {

            //判断用户的类型(作者或者管理员)
            string userName = Session["UserName"].ToString();
            ViewState["UserName"] = userName;
            ProfileCommon p = Profile.GetProfile(userName);
            string authorityName = common.GetAuthorityName(p.Rating);
            ViewState["AuthorityName"] = authorityName;
            if (!IsPostBack)
            {
                if (authorityName == "系统管理员")
                {

                    //判断本页面此次是执行书籍列表操作还是实际书籍分类操作
                    if (Request.QueryString["id"] != null)
                    {
                        ViewState["CategoryID"] = Request.QueryString["id"];
                        ViewState["opinion"] = "ByCategoryID";
                    }
                    else
                    {
                        ViewState["opinion"] = "AllBook";
                    }

                }
                else
                {
                    //判断本页面此次是执行书籍列表操作还是实际书籍分类操作
                    if (Request.QueryString["id"] != null)
                    {
                        ViewState["CategoryID"] = Request.QueryString["id"];
                        ViewState["opinion"] = "ByCategoryID_UserName";
                    }
                    else
                    {
                        ViewState["opinion"] = "ByUserName";
                    }

                }
                bind();
            }
        }
        else
        {
            Response.Redirect("~/Clientele/Login.aspx");
        }

    }

    /// <summary>
    /// 执行页面数据绑定操作
    /// </summary>
    public void bind()
    {
        string userName = ViewState["UserName"].ToString();
        int CategoryID = 0;
        //获得书籍类别编号
        if (ViewState["CategoryID"] != null)
        {
            CategoryID = Convert.ToInt32(ViewState["CategoryID"].ToString());
        }

        //查询该书籍分类下所有书籍
        if (ViewState["opinion"].ToString() == "ByCategoryID")
        {
            Pager.RecordCount = common.GetBookCountByBigCategoryID(CategoryID);
            Model.PagerParameter paper = new Model.PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
            IList<Model.Book> modelBook = book.GetBookByCategoryId(CategoryID, paper);
            GVBookInfoList.DataSource = modelBook;
            GVBookInfoList.DataBind();
        }
        //根据书籍分类和用户名查询书籍
        else if (ViewState["opinion"].ToString() == "ByCategoryID_UserName")
        {
            Pager.RecordCount = common.GetBookCountByBigCategoryID_UserName(CategoryID, userName);
            Model.PagerParameter paper = new Model.PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
            IList<Model.Book> modelBook = book.GetBookByCategoryId_UserName(CategoryID, userName, paper);
            GVBookInfoList.DataSource = modelBook;
            GVBookInfoList.DataBind();
        }
        //查询所有书籍
        else if (ViewState["opinion"].ToString() == "AllBook")
        {
            Pager.RecordCount = common.GetAllBookCount();
            Model.PagerParameter paper = new Model.PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
            IList<Model.Book> modelBook = book.GetBookList(paper);
            GVBookInfoList.DataSource = modelBook;
            GVBookInfoList.DataBind();
        }
        //查询该用户的所有书籍
        else if (ViewState["opinion"].ToString() == "ByUserName")
        {
            Pager.RecordCount = common.GetBookCountByUserName(userName);
            Model.PagerParameter paper = new Model.PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
            IList<Model.Book> modelBook = book.GetBookByUser(userName, paper);
            GVBookInfoList.DataSource = modelBook;
            GVBookInfoList.DataBind();
        }

        //自定义信息显示
        Pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + Pager.RecordCount.ToString() + "</b></font>";
        Pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + Pager.PageCount.ToString() + "</b></font>";
        Pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + Pager.CurrentPageIndex.ToString() + "</b></font>";
    }

    //根据类别编号查询出类别名称---此为大类名称
    public string getBigCategoryName(int BigCategoryID)
    {
        string BigCategoryName = common.GetCategoryName(BigCategoryID);
        return BigCategoryName;
    
    }
    //根据类别编号查询出类别名称---此为小类名称
    public string getSmallCategoryName(int SmallCategoryID)
    {
        string SmallCategoryName = common.GetCategoryName(SmallCategoryID);
        return SmallCategoryName;
    }

 
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
    }

    protected void Pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        Pager.CurrentPageIndex = e.NewPageIndex;
        bind();
    }
    public string Authorized(int authorized)
    {
        string AuthorizedName=null;
        if (authorized == 0)
        {
            AuthorizedName = "转载";
        
        }
        else if (authorized == 1)
        {
                AuthorizedName = "专属";
               
        }
        else if (authorized == 2)
        {  
                AuthorizedName = "特约";
            
        }
        else if (authorized == 3)
        {
                AuthorizedName = "授权";
               
        }
        else if (authorized == 4)
        {
                AuthorizedName = "驻站";
               
        }
        else if (authorized == 5)
        {
                 AuthorizedName = "连载";
              
        }
        return AuthorizedName;
    }
    public string GetText(int StateAudit)
    {
        if (StateAudit == 0)
        {
            return "×";
        }
        else
        {
            return "√";
        }


    }

    //根据书籍审核状态返回相应的颜色
    public System.Drawing.Color GetColor(int StateAudit)
    {
        if (StateAudit == 0)
        {
            return System.Drawing.Color.Red;
        }
        else
        {
            return System.Drawing.Color.Blue;
        }
    }

    //审核书籍操作
    protected void lbtnAudit_Command(object sender, CommandEventArgs e)
    {
        int BookId = Convert.ToInt32(e.CommandArgument);
        int Authorized = 1;
        int IsOK = common.SetBookAuthorized(BookId, Authorized);
        if (IsOK != 0)
        {
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
        else
        {
            Response.Write("<script>alert('系统提示:'+\n' 书籍通过审核失败!')</script>");
            Response.Write("<script>window.location.href = window.location.href</script>");
        }        
    }

    //撤审书籍操作
    protected void lbtnD_Audit_Command(object sender, CommandEventArgs e)
    {
        int BookId = Convert.ToInt32(e.CommandArgument);
        int StateAudit = 0;
        int IsOK = common.SetBookAuthorized(BookId, StateAudit);
        if (IsOK != 0)
        {
              Response.Write("<script>window.location.href = window.location.href</script>");
        }
        else
        {
            Response.Write("<script>alert('系统提示:'+\n' 书籍撤销审核失败!')</script>");
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
    }
    //删除书籍操作
    protected void lbtnDelete_Command(object sender, CommandEventArgs e)
    {
        int BookId = Convert.ToInt32(e.CommandArgument);
        int IsOK =book.RemoveBook(BookId);
        if (IsOK != 0)
        {
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
        else
        {
            Response.Write("<script>alert('系统提示:'+\n' 书籍删除失败!')</script>");
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
    }
    protected void GVBookInfoList_DataBound(object sender, EventArgs e)
    {
       string authorityName= ViewState["AuthorityName"].ToString();
       if (authorityName!="系统管理员")
        {
            //不是系统管理员就屏蔽审核，撤审按钮
            for (int i = 0; i < GVBookInfoList.Rows.Count; i++)
            {
                LinkButton lbtnAudit = GVBookInfoList.Rows[i].Cells[7].FindControl("lbtnAudit") as LinkButton;
                LinkButton lbtnD_Audit = GVBookInfoList.Rows[i].Cells[7].FindControl("lbtnD_Audit") as LinkButton; 
                lbtnAudit.Visible = false;
                lbtnD_Audit.Visible = false;
            }
        }
    }
}
