﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="CommentsInfo.ascx.cs" Inherits="Controls_CommentsInfo" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<table style="width: 100%">
    <tr>
        <td style="background-color:#c3daf9;">
            <asp:GridView ID="gvComments" runat="server" AutoGenerateColumns="False"
            CssClass="GridView_Style"  Width="100%" Height="100%"  DataKeyNames="commentsId" OnRowDataBound="gvComments_RowDataBound" EmptyDataText="此栏目暂无任何内容">
                <Columns>
                <asp:TemplateField HeaderText="ID">
                        <ItemStyle HorizontalAlign="Center" CssClass="Item_Style" />
                        <ItemTemplate>
                            <asp:CheckBox ID="cbxBookName" runat="server" Text='<%# Eval("commentsId") %>'  />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="书籍名称">
                        <ItemTemplate>
                            <asp:Label ID="Label1" runat="server" Text='<%# GetBookNameById((int)Eval("BookId")) %>' ></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="postUser" HeaderText="发表用户">
                        <ItemStyle HorizontalAlign="Center" />
                    </asp:BoundField>
                    <asp:BoundField DataField="content" HeaderText="内容">
                        <ItemStyle HorizontalAlign="Center" Width="100px" />
                    </asp:BoundField>
                    <asp:BoundField DataField="isAudit" HeaderText="审核">
                        <ItemStyle HorizontalAlign="Center" />
                    </asp:BoundField>
                    <asp:BoundField DataField="isHighlights" HeaderText="精华">
                        <ItemStyle HorizontalAlign="Center" />
                    </asp:BoundField>
                    <asp:BoundField DataField="isTop" HeaderText="置顶">
                        <ItemStyle HorizontalAlign="Center" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="操作">
                        <ItemStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            &nbsp;<asp:LinkButton ID="lbtnAudit" CommandArgument='<%#Eval("commentsId") %>' runat="server" OnClientClick="return confirm('系统提示！\n您确认要执行审核操作吗？')" OnCommand="lbtnAudit_Command" >审核</asp:LinkButton>
                            <asp:LinkButton ID="lbtnD_Audit" CommandArgument='<%#Eval("commentsId") %>' runat="server" OnClientClick="return confirm('系统提示！\n您确认要执行撤审操作吗？')" OnCommand="lbtnD_Audit_Command" >撤审</asp:LinkButton>
                            <asp:LinkButton ID="lbtnHighlights" CommandArgument='<%#Eval("commentsId") %>' runat="server" OnClientClick="return confirm('系统提示！\n您确认要执行精华操作吗？')" OnCommand="lbtnHighlights_Command" >精华</asp:LinkButton>
                            <asp:LinkButton ID="lbtnD_Highlights" CommandArgument='<%#Eval("commentsId") %>' runat="server" OnClientClick="return confirm('系统提示！\n您确认要执行撤精操作吗？')" OnCommand="lbtnD_Highlights_Command">撤精</asp:LinkButton>
                            <asp:LinkButton ID="lbtnTop" CommandArgument='<%#Eval("commentsId") %>' runat="server" OnClientClick="return confirm('系统提示！\n您确认要执行置顶操作吗？')" OnCommand="lbtnTop_Command">置顶</asp:LinkButton>
                            <asp:LinkButton ID="lbtnD_Top" CommandArgument='<%#Eval("commentsId") %>' runat="server" OnClientClick="return confirm('系统提示！\n您确认要执行撤顶操作吗？')" OnCommand="lbtnD_Top_Command">撤顶</asp:LinkButton>
                            <asp:LinkButton ID="lbtnDelete" OnClientClick="return confirm('系统提示！\n您确认要执行删除操作吗？')" CommandArgument='<%# Eval("commentsId") %>' runat="server" OnCommand="lbtnDelete_Command">删除</asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
                <HeaderStyle BorderWidth="1px" CssClass="GridViewHeaderStyle" />
            </asp:GridView>
        </td>
    </tr>
    <tr>
        <td>
             <webdiyer:AspNetPager ID="Pager" runat="server" CssClass="AspNetPager"
                OnPageChanging="Pager_PageChanging" PageIndexBoxType="TextBox" PageSize="4" ShowCustomInfoSection="Left"
                ShowPageIndexBox="Always" SubmitButtonText="Go" TextAfterPageIndexBox="页" TextBeforePageIndexBox="转到第"
                Width="100%" PageIndexBoxStyle="border:solid 1px Blue;color:Red;text-align:center;" SubmitButtonStyle="width:35px;border:solid 1px Blue;color:Red;background-color:yellow" FirstPageText='<font face="webdings">9</font>' LastPageText='<font face="webdings">:</font>' NextPageText='<font face="webdings">4</font>' NumericButtonTextFormatString="[{0}]" PrevPageText='<font face="webdings">3</font>' CustomInfoTextAlign="Left" NumericButtonCount="8">
            </webdiyer:AspNetPager>

        </td>
    </tr>
    <tr>
        <td>
             &nbsp;&nbsp;<asp:CheckBox ID="cbxAllSelect" runat="server" Text="全选" Width="60px" ForeColor="Blue" AutoPostBack="True" OnCheckedChanged="cbxAllSelect_CheckedChanged" /><asp:Button ID="btnDeleteLog" OnClientClick="return confirm('您确定要执行全部删除操作吗？')" runat="server" Text="删除选择记录" Width="97px" style="font-weight: bold; color: #ffffff; background-color: #c3daf9" OnClick="btnDeleteLog_Click" CssClass="Button_Style" />
        </td>
    </tr>
</table>
