﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;
using Model;

public partial class Controls_CommentsInfo : System.Web.UI.UserControl
{
    IBLL.IComments objComments = BLLFactory.BusinessLogic.CreateComments();
    string authorityName;
    protected void Page_Load(object sender, EventArgs e)
    {
        //判断用户的类型
        if (!IsPostBack)
        {
             
            if (Request["BookId"] != null)
            {
                ViewState["BookId"] = Request["BookId"];
                int BookId = Convert.ToInt32(ViewState["BookId"]);
                Pager.RecordCount = objComments.GetCommentsCountByBookId(BookId);
                Bind();
            }
            else if (Session["UserName"] != null)
            {
                ProfileCommon p = Profile.GetProfile(Session["UserName"].ToString());
                ViewState["role"] = common.GetAuthorityName(p.Rating);
                if (ViewState["role"].ToString() == "系统管理员")
                {
                    Bind();
                }
                else
                {
                    Response.Redirect("/TengfeiWeb/BookManager/Sorry.aspx");
                }
            }
            else
            {
                Response.Redirect("~/Clientele/Login.aspx");
            }

        }
    }
    protected void Bind()
    {
     
        if (ViewState["BookId"] != null)
        {            
            int BookId = Convert.ToInt32(ViewState["BookId"]);
            Pager.RecordCount = objComments.GetCommentsCountByBookId(BookId);
            //将分页所需参数初始化给PagerParameter类的构造方法
            PagerParameter pagerParm = new PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);

            //通过接口调用方法查询数据，并返回IList<T>类型对象
            IList<Model.Comments> comments = objComments.GetCommentsByBookId(BookId, pagerParm);
            //将IList<T>对象作为数据源绑定到GridView上
            gvComments.DataSource = comments;
        }
        else 
        {
            Pager.RecordCount = objComments.GetCommentsCount();
            //将分页所需参数初始化给PagerParameter类的构造方法
            PagerParameter pagerParm = new PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);

            //通过接口调用方法查询数据，并返回IList<T>类型对象
            IList<Model.Comments> comments = objComments.GetComments(pagerParm);
            //将IList<T>对象作为数据源绑定到GridView上
            gvComments.DataSource = comments;
        }

        gvComments.DataBind();
        //自定义信息显示
        Pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + Pager.RecordCount.ToString() + "</b></font>";
        Pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + Pager.PageCount.ToString() + "</b></font>";
        Pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + Pager.CurrentPageIndex.ToString() + "</b></font>";
    }

    protected void Pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        Pager.CurrentPageIndex = e.NewPageIndex;
        Bind();
    }
    protected void gvComments_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Cells[3].Style.Add("word-break", "break-all");
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
    }
    protected void lbtnDelete_Command(object sender, CommandEventArgs e)
    {
        int id = Convert.ToInt32(e.CommandArgument);
        int i = objComments.RemoveComments(id);
        Bind();
    }
    public string GetBookNameById(int bookId)
    {
        return common.GetBookName(bookId);
    }
    protected void cbxAllSelect_CheckedChanged(object sender, EventArgs e)
    {
        if (((CheckBox)sender).Checked == true)
        {
            for (int i = 0; i < gvComments.Rows.Count; i++)
            {
                ((CheckBox)gvComments.Rows[i].FindControl("cbxBookName")).Checked = true;
            }
        }
        else
        {
            for (int i = 0; i < gvComments.Rows.Count; i++)
            {
                ((CheckBox)gvComments.Rows[i].FindControl("cbxBookName")).Checked = false;
            }
        }
    }
    protected void btnDeleteLog_Click(object sender, EventArgs e)
    {
        if (cbxAllSelect.Checked)
        {
            for (int i = 0; i < gvComments.Rows.Count; i++)
            {
                CheckBox cbk = gvComments.Rows[i].Cells[0].FindControl("cbxBookName") as CheckBox;
                int id = Convert.ToInt32(cbk.Text);
                objComments.RemoveComments(id);
            }
            Bind();
            cbxAllSelect.Checked = false;
        }
        else
        {
            Response.Write("<script>alert('必须勾上全选复选框才能执行删除操作。');</script>");
        }
    }
    protected void lbtnTop_Command(object sender, CommandEventArgs e)
    {
        int id = Convert.ToInt32(e.CommandArgument);
        int i = objComments.CommentsTop(id);
        Bind();
    }
    protected void lbtnD_Top_Command(object sender, CommandEventArgs e)
    {
        int id = Convert.ToInt32(e.CommandArgument);
        int i = objComments.CommentsNotTop(id);
        Bind();
    }
    protected void lbtnAudit_Command(object sender, CommandEventArgs e)
    {
        int id = Convert.ToInt32(e.CommandArgument);
        int i = objComments.CommentsAudit(id);
        Bind();
    }
    protected void lbtnD_Audit_Command(object sender, CommandEventArgs e)
    {
        int id = Convert.ToInt32(e.CommandArgument);
        int i = objComments.CommentsNotAudit(id);
        Bind();
    }
    protected void lbtnHighlights_Command(object sender, CommandEventArgs e)
    {
        int id = Convert.ToInt32(e.CommandArgument);
        int i = objComments.CommentsHighlights(id);
        Bind();
    }
    protected void lbtnD_Highlights_Command(object sender, CommandEventArgs e)
    {
        int id = Convert.ToInt32(e.CommandArgument);
        int i = objComments.CommentsNotHighlights(id);
        Bind();
    }
}
