﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;

public partial class Controls_EditBookInfo : System.Web.UI.UserControl
{
   /// <summary>
   /// 动态创建接口实例
   /// </summary>
    IBLL.IBook book = BLLFactory.BusinessLogic.CreateBook();
    /// <summary>
    /// 创建Model层Book对象
    /// </summary>
    Model.Book modelbook = new Model.Book();  

    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");
        if (!IsPostBack)
        {
            //将书籍编号和书籍封面保存地址保存到ViewState中
            ViewState["PhotoPath"] = ConfigurationManager.AppSettings["PhotoPath"].ToString();
            ViewState["BookId"] = Convert.ToInt32(Request.QueryString["BookId"]);
            DateBindBookInfo();
        }
    }

    /// <summary>
    /// 保存修改的书籍信息
    /// </summary>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        //判断用户是否选择书籍类别
        if (ddlBigCategoryName.SelectedIndex != ddlBigCategoryName.Items.Count - 1 && ddlSmallCategoryName.SelectedIndex != ddlSmallCategoryName.Items.Count - 1)
        {
            modelbook.BookId = Convert.ToInt32(ViewState["BookId"].ToString());
            modelbook.BookName = txtBookTitle.Text.ToString();
            modelbook.Author = txtAuthor.Text.ToString();
            modelbook.UserName = ViewState["UserName"].ToString();
            modelbook.Protagonists = txtProtagonists.Text.ToString();
            modelbook.StateAudit = Convert.ToInt32(ViewState["StateAudit"].ToString());
            modelbook.Process = ddlProcess.SelectedItem.Text.ToString();
            modelbook.Nature = ddlNature.SelectedItem.Text.ToString();
            modelbook.Authorized = ddlAuthorized.SelectedItem.Text.ToString();
            modelbook.TotalClick = Convert.ToInt32(txtTotalClick.Text.ToString());
            modelbook.MonthClick = Convert.ToInt32(txtMonthClick.Text.ToString());
            modelbook.WeekClick = Convert.ToInt32(txtWeekClick.Text.ToString());
            modelbook.DayClick = Convert.ToInt32(txtDayClick.Text.ToString());
            modelbook.CollectionNum = Convert.ToInt32(txtRecommendedNum.Text.ToString());
            modelbook.BigCategoryID = Convert.ToInt32(ddlBigCategoryName.SelectedValue);
            modelbook.SmallCategoryID = Convert.ToInt32(ddlSmallCategoryName.SelectedValue);
            modelbook.FirstIssue = Convert.ToInt32(ddlFirstIssue.SelectedValue);
            modelbook.CollectionNum = Convert.ToInt32(txtCollectionNum.Text.ToString());
            modelbook.BookIntroduction = ftbBookIntroduction.Text.ToString();
            modelbook.AddTime = DateTime.Parse(ViewState["AddTime"].ToString());

            //判断用户是否指定书籍封面，如没有指定则设为默认书籍封面
            if (this.txtImageURL.Value != null)
            {
                modelbook.Images =this.txtImageURL.Value;
            }
            else
            {
                string PhotoPath = ConfigurationManager.AppSettings["PhotoPath"].ToString();
                modelbook.Images = PhotoPath + "book.jpg";
            }

            //执行修改书籍信息操作，返回修改书籍的行数
            int i = book.ModifyBook(modelbook);
            if (i == 0)
            {
                Response.Write("<script>alert('修改书籍信息失败！');</script>");
            }
            else
            {
                Response.Write("<script> alert('修改书籍信息成功!')</script>");
                Response.Write("<script>window.close()</script>");
            }
        }
        else
        {
            Response.Write("<script>alert('请选择所属分类!')</script>");
        }

    }
    
    /// <summary>
    /// 点击取消按钮，返回书籍列表页面，并关闭当前页面
    /// </summary>
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Server.Transfer("BookInfoList.aspx");
        Response.Write("<script>window.close()</script>");
    }

    /// <summary>
    /// 执行页面控件数据绑定
    /// </summary>
    public void DateBindBookInfo()
    {
        //判断书籍自动审核状态
        int AutoAudit = common.GetAutomatismAuditingBook();
        if (AutoAudit == 0)
        {
            lblAutoAudit.Text = "×";
            lblAutoAudit.ForeColor = System.Drawing.Color.Red;
        }
        else
        {
            lblAutoAudit.Text = "√";
            lblAutoAudit.ForeColor = System.Drawing.Color.Blue;
        }


        //大类,小类编号ID
        int BigCategoryID = 0;
        int SmallCategoryID = 0;
        int BookId = Convert.ToInt32(ViewState["BookId"].ToString());

        //根据书籍编号查询书籍信息
        Model.Book books =book.GetBookById(BookId);

        //如果存在该书籍，则绑定书籍信息到页面控件
        if (books != null)
        {
            txtBookTitle.Text = books.BookName;
            txtAuthor.Text = books.Author;
            ViewState["UserName"] = books.UserName;
            this.txtImageURL.Value = books.Images;
            txtProtagonists.Text = books.Protagonists;
            ViewState["StateAudit"] = books.StateAudit;
            ddlProcess.SelectedItem.Text = books.Process.ToString();
            ddlNature.SelectedItem.Text = books.Nature.ToString();
            ddlAuthorized.SelectedItem.Text = books.Authorized.ToString();
            txtTotalClick.Text = books.TotalClick.ToString();
            txtMonthClick.Text = books.MonthClick.ToString();
            txtWeekClick.Text = books.WeekClick.ToString();
            txtDayClick.Text = books.DayClick.ToString();
            txtRecommendedNum.Text = books.RecommendedNum.ToString();
            BigCategoryID = books.BigCategoryID;
            SmallCategoryID = books.SmallCategoryID;
            ddlFirstIssue.SelectedValue = books.FirstIssue.ToString();
            txtCollectionNum.Text = books.CollectionNum.ToString();
            ftbBookIntroduction.Text = books.BookIntroduction;
            ViewState["AddTime"] = books.AddTime;
        }
        //根据大类编号查询出总书籍分类

        int BookCategoryManagerId = common.GetSuperiorIdByBigCategoryID(BigCategoryID);

        //绑定书籍总类别到下拉列表
        SqlParameter parms = new SqlParameter("@SuperiorId", SqlDbType.Int);
        parms.Value = 1;
        common.DropDownListBind(ddlCategoryManager, "CategoryName", "CategoryManagerId",
              SqlHelper.connectionString, CommandType.StoredProcedure,
              "Tengfei_SelectSuperiorCategoryBySuperiorId", parms);
        ddlCategoryManager.Items.Add("请选择书籍类别");
        ddlCategoryManager.SelectedValue = BookCategoryManagerId.ToString();


        //查询出书籍大类，并说绑定到下拉列表
        SqlParameter parmBig = new SqlParameter("@SuperiorId", SqlDbType.Int);
        parmBig.Value = BookCategoryManagerId;
        common.DropDownListBind(ddlBigCategoryName, "CategoryName", "CategoryManagerId",
              SqlHelper.connectionString, CommandType.StoredProcedure,
              "Tengfei_SelectSuperiorCategoryBySuperiorId", parmBig);
        ddlBigCategoryName.Items.Add("请选择分类");
        ddlBigCategoryName.SelectedValue = BigCategoryID.ToString();
      

        //根据大类编号查询出该类别下的小类，并绑定到下拉列表
        SqlParameter parmSmall = new SqlParameter("@SuperiorId", SqlDbType.Int);
        parmSmall.Value = BigCategoryID;
        common.DropDownListBind(ddlSmallCategoryName, "CategoryName", "CategoryManagerId",
              SqlHelper.connectionString, CommandType.StoredProcedure,
              "Tengfei_SelectSuperiorCategoryBySuperiorId", parmSmall);
        ddlSmallCategoryName.Items.Add("请选择左边大类");
        ddlSmallCategoryName.SelectedValue = SmallCategoryID.ToString();

    }

    /// <summary>
    /// 更改大类选项后，将该大类下的所有小类绑定到下拉列表中去。
    /// </summary>
    protected void ddlBigCategoryName_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (ddlBigCategoryName.SelectedIndex != ddlBigCategoryName.Items.Count - 1)
        {
            ddlSmallCategoryName.Items.Clear();
            int BigCategoryID = Convert.ToInt32(ddlBigCategoryName.SelectedValue);
            SqlParameter parm = new SqlParameter("@SuperiorId", SqlDbType.Int);
            parm.Value = BigCategoryID;
            common.DropDownListBind(ddlSmallCategoryName, "CategoryName", "CategoryManagerId",
                  SqlHelper.connectionString, CommandType.StoredProcedure,
                  "Tengfei_SelectSuperiorCategoryBySuperiorId", parm);
            ddlSmallCategoryName.Items.Add("请选择左边大类");
            ddlSmallCategoryName.SelectedIndex = ddlSmallCategoryName.Items.Count - 1;
        }
        else 
        {
            ddlSmallCategoryName.Items.Clear();
            ddlSmallCategoryName.Items.Add("请选择左边大类");
            ddlSmallCategoryName.SelectedIndex = ddlSmallCategoryName.Items.Count - 1;
        }
    }

    /// <summary>
    /// 获得书籍封面保存地址
    /// </summary>
    /// <returns>返回书籍封面保存地址URL</returns>
    public string GetPhotoPath()
    {
        string str = ViewState["PhotoPath"].ToString();
        return str;
    }

    /// <summary>
    /// 更改书籍总类别选项后，绑定该类别下的大类信息到下拉列表
    /// </summary>
    protected void ddlCategoryManager_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (ddlCategoryManager.SelectedIndex != ddlCategoryManager.Items.Count - 1)
        {
            ddlBigCategoryName.Items.Clear();
            ddlSmallCategoryName.Items.Clear();
            //绑定数据到下拉列表
            SqlParameter parms = new SqlParameter("@SuperiorId", SqlDbType.Int);
            parms.Value = ddlCategoryManager.SelectedValue;
            common.DropDownListBind(ddlBigCategoryName, "CategoryName", "CategoryManagerId",
                  SqlHelper.connectionString, CommandType.StoredProcedure,
                  "Tengfei_SelectSuperiorCategoryBySuperiorId", parms);
            ddlBigCategoryName.Items.Add("请选择分类");
            ddlBigCategoryName.SelectedIndex = ddlBigCategoryName.Items.Count - 1;
            ddlSmallCategoryName.Items.Add("请选择左边大类");
            ddlSmallCategoryName.SelectedIndex = ddlSmallCategoryName.Items.Count - 1;
        }
        else
        {
            ddlBigCategoryName.Items.Clear();
            ddlSmallCategoryName.Items.Clear();
            ddlBigCategoryName.Items.Add("请选择分类");
            ddlBigCategoryName.SelectedIndex = ddlBigCategoryName.Items.Count - 1;
            ddlSmallCategoryName.Items.Add("请选择左边大类");
            ddlSmallCategoryName.SelectedIndex = ddlSmallCategoryName.Items.Count - 1;
        }
    }
}
