﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Controls_EditRecdCategory : System.Web.UI.UserControl
{
    IBLL.IRedCategory objRedCategory = BLLFactory.BusinessLogic.CreateRedCategory();
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");
        if (!IsPostBack)
        {
            BindredCat();
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.close()</script>");
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request["id"] != null)
        {
            int id = Convert.ToInt32(Request["id"]);
            Model.RedCategory redCategory = new Model.RedCategory(id, txtFunctionName.Text, Convert.ToInt32(txtShowNum.Text));
            int i = objRedCategory.ModifyRedCategory(redCategory);
            if (i > 0)
                Response.Write("<script>alert('编辑成功！');</script>");
            else
                Response.Write("<script>alert('编辑失败！');</script>");
        }
    }
    public void BindredCat()
    {
        if (Request["id"] != null)
        {
            Model.RedCategory recdCat = objRedCategory.GetRecdCategoryById(Convert.ToInt32(Request["id"]));
            txtFunctionName.Text = recdCat.RedCategoryName;
            txtShowNum.Text = recdCat.RedCategoryNum.ToString();
        }
    }
}
