﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;

public partial class Controls_EditVolume : System.Web.UI.UserControl
{

    /// <summary>
    /// 动态创建接口实例
    /// </summary>
    IBLL.IVolume volume = BLLFactory.BusinessLogic.CreateVolume();
    IBLL.IBook book = BLLFactory.BusinessLogic.CreateBook();
    /// <summary>
    /// 创建Model层Volume对象实例
    /// </summary>
    Model.Volume modelVolume = new Model.Volume();

    protected void Page_Load(object sender, EventArgs e)
    {
        //当前分类卷编号ID
        int VolumeId;
        if (!IsPostBack)
        {
            VolumeId = Convert.ToInt32(Request.QueryString["VolumeId"]);
            ViewState["VolumeId"] = VolumeId;
            //获得书籍名称
            GetVolumeInfo();
            GetBookInfo();
        }

    }


    /// <summary>
    /// 根据分类卷编号查询分类卷信息
    /// </summary>
    public void GetVolumeInfo()
    {
        int VolumeId=Convert.ToInt32(ViewState["VolumeId"]);
        modelVolume = volume.GetVolumeByVolumeId(VolumeId);
        ViewState["BookId"] = modelVolume.BookId.ToString();
        txtVolumeName.Text = modelVolume.VolumeName.ToString();
        txtOrderNum.Text = modelVolume.OrderNum.ToString();
        ViewState["OrderNum"] = modelVolume.OrderNum.ToString();
    }  
    /// <summary>
    /// 根据书籍编号查询到书籍名称，并将书籍名称填充到TextBox控件中
    /// </summary>
    public void GetBookInfo()
    {
        int BookId = Convert.ToInt32(ViewState["BookId"]);
        Model.Book modelBook = new Model.Book();
        modelBook = book.GetBookById(BookId);
        txtBookName.Text = modelBook.BookName.ToString();
    }

    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.close()</script>");
    }

    /// <summary>
    /// 将分类卷信息添加到分类卷信息表中去
    /// </summary>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        modelVolume.VolumeId = Convert.ToInt32(ViewState["VolumeId"].ToString());
        int BookId = Convert.ToInt32(ViewState["BookId"].ToString());
        modelVolume.BookId = BookId;
        modelVolume.VolumeName = txtVolumeName.Text.ToString();
        int OrderNum = Convert.ToInt32(txtOrderNum.Text.ToString());
        int _OrderNum = Convert.ToInt32(ViewState["OrderNum"]);
        //判断用户是否更改卷顺序
        if (OrderNum != _OrderNum)
        {
            int Num = common.GetOrderNumByBookId(OrderNum, BookId);
            if (Num == 0)
            {
                modelVolume.OrderNum = OrderNum;
                //调用方法以执行相应的数据库操作
                int IsOK = volume.ModifyVolume(modelVolume);
                if (IsOK != 0)
                {
                    Response.Write("<script>window.close()</script>");
                }
                else
                {
                    Response.Write("<Script>alert('修改书籍失败!')</Script>");
                }
            }
            else
            {
                Response.Write("<Script>alert('卷顺序已存在,请重新输入!')</Script>");
            }


        }
         //如果没有更改卷顺序，则不修改卷顺序
        else
        {
            modelVolume.OrderNum = _OrderNum;
            int IsOK = volume.ModifyVolume(modelVolume);
            if (IsOK != 0)
            {
             
                Response.Write("<script>window.close()</script>");
            }
            else
            {
                Response.Write("<Script>alert('修改书籍失败!')</Script>");
            }
        }
    }
    
}
