﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;
using Model;

public partial class Controls_RecCategory : System.Web.UI.UserControl
{
    IBLL.IRedCategory objCategory = BLLFactory.BusinessLogic.CreateRedCategory();
    string authorityName;
    protected void Page_Load(object sender, EventArgs e)
    {
        //判断用户的类型
        if (!IsPostBack)
        {
            if (Session["UserName"] != null)
            {
                ProfileCommon p = Profile.GetProfile(Session["UserName"].ToString());
                ViewState["role"] = common.GetAuthorityName(p.Rating);
                if (ViewState["role"].ToString() == "系统管理员")
                {
                    Bind();
                }
                else
                {
                    Response.Redirect("/TengfeiWeb/BookManager/Sorry.aspx");
                }
            }
            else
            {
                Response.Redirect("/TengfeiWeb/Clientele/SessionOut.aspx");
            }
            
        }
    }
    //绑定GridView数据
    protected void Bind()
    {
        Pager.RecordCount = objCategory.GetRecdCategoryCount();
        //将分页所需参数初始化给PagerParameter类的构造方法
        PagerParameter pagerParm = new PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
        //通过接口调用方法查询数据，并返回IList<T>类型对象
        IList<Model.RedCategory> redCategoryList = objCategory.GetAllRecdCategory(pagerParm);
        //将IList<T>对象作为数据源绑定到GridView上
        gvRecdCategory.DataSource = redCategoryList;
        gvRecdCategory.DataBind();
        //自定义信息显示
        Pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + Pager.RecordCount.ToString() + "</b></font>";
        Pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + Pager.PageCount.ToString() + "</b></font>";
        Pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + Pager.CurrentPageIndex.ToString() + "</b></font>";
    }
    //启动分页功能
    protected void Pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        Pager.CurrentPageIndex = e.NewPageIndex;
        Bind();
    }

    //为GridView添加高亮显示
    protected void gvRecdCategory_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
    }
    //执行删除功能
    protected void lkbDelete_Command(object sender, CommandEventArgs e)
    {
        int id = Convert.ToInt32(e.CommandArgument);
        int i = objCategory.RemoveRecCategory(id);
        Bind();
    }
}
