﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;
using System.Collections.Generic;


public partial class Controls_SectionInfo : System.Web.UI.UserControl
{
    IBLL.ISections sections = BLLFactory.BusinessLogic.CreateSections();
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");

        if (!IsPostBack)
        {
            //保存页面传过来的值到ViewState
            if (Request.QueryString["VolumeId"] != null)
            {
                ViewState["VolumeId"] = Request.QueryString["VolumeId"];
               
            }
            else if (Request.QueryString["BookId"] != null)
            {
                ViewState["BookId"] = Request.QueryString["BookId"];
            }
           bind();
        }
    }
    
    /// <summary>
    /// 绑定数据到页面控件中
    /// </summary>
    public void bind()
    {
        cbxAll.Checked = false;
        //查询分类卷下的章节信息
        if (ViewState["VolumeId"] != null)
        {
            int VolumeId = Convert.ToInt32(ViewState["VolumeId"]);
            Pager.RecordCount = common.GetSectionsCountByVolumeId(VolumeId);
            Model.PagerParameter modelPagerParameter = new Model.PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
            IList<Model.Sections> modelSections = sections.GetSectionsByvolumeId(VolumeId, modelPagerParameter);
            gvSectionInfo.DataSource = modelSections;
            gvSectionInfo.DataBind();
        }
        //查询该书籍下的章节信息
        else if (ViewState["BookId"] != null)
        {
            int BookId =Convert.ToInt32(ViewState["BookId"]);
            string VolumeIdList = common.GetVolumeIdListByBookId(BookId);
            if (VolumeIdList != null)
            {
                Pager.RecordCount =common.GetSectionCountInVolumeIdList(VolumeIdList);
            }
            else
            {
                Pager.RecordCount = 0;
            }
            Model.PagerParameter modelPagerParameter = new Model.PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
            IList<Model.Sections> modelSections = sections.GetSectionsByBookId(BookId,modelPagerParameter);
            gvSectionInfo.DataSource = modelSections;
            gvSectionInfo.DataBind();
        }

        //自定义信息显示
        Pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + Pager.RecordCount.ToString() + "</b></font>";
        Pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + Pager.PageCount.ToString() + "</b></font>";
        Pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + Pager.CurrentPageIndex.ToString() + "</b></font>";
    }
    protected void Pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        Pager.CurrentPageIndex = e.NewPageIndex;
        bind();
    }
    /// <summary>
    /// 根据分类卷编号查询分类卷名称
    /// </summary>
    /// <param name="VolumeId">分类卷编号</param>
    /// <returns>返回分类卷名称</returns>
    public string GetVolumeName(int VolumeId)
    {
        string VolumeName = common.GetVolumeName(VolumeId);
        return VolumeName;
    }

    protected void gvSectionInfo_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
    }
    /// <summary>
    /// 根据审核状态返回相应的样式
    /// </summary>
    /// <param name="StateAudit">审核状态</param>
    /// <returns>Lable样式</returns>
    public string GetText(int StateAudit)
    {
        if(StateAudit==0)
        {
            return "×";
        }
        else
        {
            return "√";
        }


    }
    public System.Drawing.Color GetColor(int StateAudit)
    {
        if (StateAudit == 0)
        {
            return System.Drawing.Color.Red;
        }
        else
        {
            return System.Drawing.Color.Blue;
        }
    }

    //审核章节操作
    protected void lbtnAudit_Command(object sender, CommandEventArgs e)
    {
        int SectionId = Convert.ToInt32(e.CommandArgument);
        int StateAudit = 1;
        int IsOK = common.SetSectionAuthorized(SectionId, StateAudit);
        if (IsOK != 0)
        {
            
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
        else
        {
            Response.Write("<script>alert('系统提示:'+\n' 章节通过审核失败!')</script>");
            Response.Write("<script>window.location.href = window.location.href</script>");
        } 

    }
    //撤审章节操作
    protected void lbtnD_Audit_Command(object sender, CommandEventArgs e)
    {
        int SectionId = Convert.ToInt32(e.CommandArgument);
        int StateAudit = 0;
        int IsOK = common.SetSectionAuthorized(SectionId, StateAudit);
        if (IsOK != 0)
        {
           
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
        else
        {
            Response.Write("<script>alert('系统提示:'+\n' 章节撤销审核失败!')</script>");
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
    }
    //删除章节操作
    protected void lbtnDelete_Command(object sender, CommandEventArgs e)
    {
        int SectionId = Convert.ToInt32(e.CommandArgument);
        int IsOK = sections.RemoveSections(SectionId);
        if (IsOK != 0)
        {
           
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
        else
        {
            Response.Write("<script>alert('系统提示:'+\n' 章节删除失败!')</script>");
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
    }

    /// <summary>
    /// 全选按钮事件
    /// </summary>
    protected void cbxAll_CheckedChanged(object sender, EventArgs e)
    {
        if (((CheckBox)sender).Checked == true)
        {
            for (int i = 0; i < gvSectionInfo.Rows.Count; i++)
            {
                ((CheckBox)gvSectionInfo.Rows[i].FindControl("cbxID")).Checked = true;
            }
        }
        else
        {
            for (int i = 0; i < gvSectionInfo.Rows.Count; i++)
            {
                ((CheckBox)gvSectionInfo.Rows[i].FindControl("cbxID")).Checked = false;
            }
        }

    }
    /// <summary>
    /// 新增章节时绑定到点击事件的参数，判断该页面是查询书籍里的章节还是分类卷里的章节
    /// </summary>
    /// <returns></returns>
    public string Tag()
    {

        if (Request["BookId"] != null)
        {
            int BookId = Convert.ToInt32(Request["BookId"]);
            int VolumeColumns=common.GetVolumeColumnsByBookId(BookId);
            if (VolumeColumns > 0)
            {
                return "BookId";
            }
            else
            {
                return "Nothing";
            }
        }
        else
        {
            if (Request["VolumeId"] != null)
            {
                return "VolumeId";
            }
            else
            {
                return "Nothing";
            }
        }
    }
    
    /// <summary>
    /// 新增章节时绑定到点击事件的参数，判断该页面是查询书籍里的章节还是分类卷里的章节
    /// </summary>
    /// <returns></returns>
    public string GetRequest()
    {

        if (Request["BookId"] != null)
        {
            return Request["BookId"].ToString();
        }
        else if (Request["VolumeId"] != null)
        {
            return Request["VolumeId"].ToString();
        }
        else
        {
            return "0";
        }
    }

    /// <summary>
    /// 判断当前用户类型，如果不是管理员，则屏蔽相关按钮
    /// </summary>
    protected void gvSectionInfo_DataBound(object sender, EventArgs e)
    {
        if (Session["UserName"] != null)
        {
            //判断用户的类型
            string userName = Session["UserName"].ToString(); ;
            ProfileCommon p = Profile.GetProfile(userName);
            string authorityName = common.GetAuthorityName(p.Rating);
            if (authorityName != "系统管理员")
            {
                //不是系统管理员就屏蔽审核，撤审按钮
                for (int i = 0; i < gvSectionInfo.Rows.Count; i++)
                {
                    LinkButton lbtnAudit = gvSectionInfo.Rows[i].Cells[7].FindControl("lbtnAudit") as LinkButton;
                    LinkButton lbtnD_Audit = gvSectionInfo.Rows[i].Cells[7].FindControl("lbtnD_Audit") as LinkButton;
                    lbtnAudit.Visible = false;
                    lbtnD_Audit.Visible = false;
                }
            }
        }
        else
        {
            Response.Redirect("~/Clientele/Login.aspx");
        }
    }
    /// <summary>
    /// 删除多选章节操作
    /// </summary>
    protected void btnDeleteAll_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < this.gvSectionInfo.Rows.Count; i++)
        {
            CheckBox cbx = (CheckBox)this.gvSectionInfo.Rows[i].FindControl("cbxID");
            int id = int.Parse(cbx.Text);
            if (cbx.Checked)
            {
                sections.RemoveSections(id);
            }
        }
        Pager.CurrentPageIndex = 0;
        bind();
    }
}
