﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DBUtility;
using System.Collections.Generic;

public partial class Controls_SelectRecdBook : System.Web.UI.UserControl
{
    /// <summary>
    /// 动态创建接口实例
    /// </summary>
    IBLL.IBook book = BLLFactory.BusinessLogic.CreateBook();


    protected void Page_Load(object sender, EventArgs e)
    {

    }

    /// <summary>
    /// 查询书籍操作
    /// </summary>
    protected void btnSelect_Click(object sender, EventArgs e)
    {
        
        //如果未输入书籍名，则查询出所有书籍信息
        if (txtBookName.Text.Equals("") || txtBookName.Text.Trim() == "")
        {
            IList<Model.Book> modelBook = book.GetAllBook();
            lbxSelectBook.DataTextField = "bookName";
            lbxSelectBook.DataValueField = "bookId";
            lbxSelectBook.DataSource = modelBook;
            lbxSelectBook.DataBind();
        }
        //如果用户输入了书籍名，则模糊查询书籍名
        else {
            string str=txtBookName.Text.ToString();
            IList<Model.Book> modelBook = book.GetBookWithTitle(str);
            lbxSelectBook.DataTextField = "bookName";
            lbxSelectBook.DataValueField = "bookId";
            lbxSelectBook.DataSource = modelBook;
            lbxSelectBook.DataBind();
        }
    }

    /// <summary>
    /// 当用户选择ListBox中的选项后，向调用这个页面的页面传回书籍编号和书籍名称
    /// </summary>
    protected void lbxSelectBook_SelectedIndexChanged(object sender, EventArgs e)
    {
        int bookId=Convert.ToInt32(lbxSelectBook.SelectedItem.Value);
        string bookName = lbxSelectBook.SelectedItem.Text.ToString();
        string str = bookId + "|" + bookName;
        Response.Write("<script type='text/javascript'>window.returnValue='" + str + "'</script>");
        Response.Write("<script type='text/javascript'>window.close()</script>");
    }
}
