﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;
using System.Collections.Generic;

public partial class Controls_VolumeInfo : System.Web.UI.UserControl
{
    IBLL.IVolume volume = BLLFactory.BusinessLogic.CreateVolume();
   
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");
        if (!IsPostBack)
        {
            ViewState["BookId"] = Request.QueryString["BookId"];  
            bind();
        }
    }
    /// <summary>
    /// 绑定分类卷信息到GridView控件中，并赋值给分页控件
    /// </summary>
    public void bind()
    {
        cbxAll.Checked = false;

        int BookId = Convert.ToInt32(ViewState["BookId"]);
        Pager.RecordCount = common.GetVolumeColumnsByBookId(BookId); 
        Model.PagerParameter modelPagerParameter = new Model.PagerParameter(Pager.StartRecordIndex,Pager.EndRecordIndex,false);
        IList<Model.Volume> modelVolume = volume.GetVolumeByBookId(BookId,modelPagerParameter);
        gvVolumeInfo.DataSource = modelVolume;
        gvVolumeInfo.DataBind();
        //自定义信息显示
        Pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + Pager.RecordCount.ToString() + "</b></font>";
        Pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + Pager.PageCount.ToString() + "</b></font>";
        Pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + Pager.CurrentPageIndex.ToString() + "</b></font>";
    }

    /// <summary>
    /// 绑定书籍ID到"新增分类卷"按钮事件
    /// </summary>
    /// <returns>返回书籍ID</returns>
    public string GetRequest()
    {
        string bookId = "";
        if (Request["BookId"] != null)
        {
            return Request["BookId"].ToString();
        }
        return bookId;
    }

    /// <summary>
    /// 根据书籍编号查询书籍名称
    /// </summary>
    /// <param name="bookId">书籍编号</param>
    /// <returns>书籍名称</returns>
    public string GetBookName(int bookId)
    {
        string BookName = common.GetBookName(bookId);
        return BookName;
    }
    protected void Pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        Pager.CurrentPageIndex = e.NewPageIndex;
        bind();
    }
    protected void gvVolumeInfo_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
    }

    /// <summary>
    /// 删除章节操作
    /// </summary>
    protected void lbtnDelete_Command(object sender, CommandEventArgs e)
    {
        int VolumeId = Convert.ToInt32(e.CommandArgument);
        int IsOK = volume.RemoveVolume(VolumeId);
        if (IsOK != 0)
        {
          
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
        else
        {
            Response.Write("<script>alert('系统提示:'+\n' 分类卷删除失败!')</script>");
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
    }

    /// <summary>
    /// 全选按钮事件，点击全选按钮后，GridView中当前页面里的单选按钮选中状态都发生相应改变
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void cbxAll_CheckedChanged(object sender, EventArgs e)
    {
        if (((CheckBox)sender).Checked == true)
        {
            for (int i = 0; i < gvVolumeInfo.Rows.Count; i++)
            {
                ((CheckBox)gvVolumeInfo.Rows[i].FindControl("cbxID")).Checked = true;
            }
        }
        else
        {
            for (int i = 0; i < gvVolumeInfo.Rows.Count; i++)
            {
                ((CheckBox)gvVolumeInfo.Rows[i].FindControl("cbxID")).Checked = false;
            }
        }
    } 
    /// <summary>
    /// 删除多个章节操作
    /// </summary>
    protected void btnDeleteAll_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < this.gvVolumeInfo.Rows.Count; i++)
        {
            CheckBox cbx = (CheckBox)this.gvVolumeInfo.Rows[i].FindControl("cbxID");
            int id = int.Parse(cbx.Text);
            if (cbx.Checked)
            {
                volume.RemoveVolume(id);
            }
        }
        Pager.CurrentPageIndex = 0;
        bind();
    }
}
