﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Collections.Generic;
using DBUtility;
//该源码下载自www.51aspx.com(５１aｓｐｘ．cｏｍ)

public partial class Controls_CaregorySelect : System.Web.UI.UserControl
{
    /// <summary>
    /// 调用接口实现
    /// 调用IBLL.ICategoryManager接口
    /// </summary>
    IBLL.ICategoryManager categoryManager = BLLFactory.BusinessLogic.CreateCategoryManager();
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        if (!Page.IsPostBack)
        {
            //调用FatherBind()方法绑定父类兰下拉列表
            FatherBind();
            getBind(Convert.ToInt32(Request.QueryString["categoryId"]));
        }
    }

    /// <summary>
    /// 绑定下拉列表
    /// 调用App_Code里面的common类的DropDownListBind()方法绑定下拉列表
    /// (这是一个提供数据绑定的方法)
    /// </summary>
    protected void FatherBind()
    {
        //通过CategoryManagerId获得父类兰信息
        SqlParameter parm = new SqlParameter("@CategoryManagerId", SqlDbType.Int);
        parm.Value = int.Parse(Request["superiorId"]);
        //调用common类的DropDownListBind()方法绑定下拉列表
        //CategoryName显示下拉列表的内容
        common.DropDownListBind(ddlFather, "CategoryName", "CategoryManagerId", SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectCategoryById", parm);
    }

    /// <summary>
    /// 修改数据
    /// 通过声明Model.CategoryManger对象并获得要修改的信息,然后调用ModifyCategory()方法进行修改
    /// 修改完立即关闭页面
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        //分类编号
        int idd = Convert.ToInt32(Request["categoryId"]);
        //上级目录ID
        int id = Convert.ToInt32(Request["superiorId"]);
        //声明CategoryManger对象
        //获得要修改的文本信息
        Model.CategoryManager modelCategoryManager = new Model.CategoryManager(idd,id,txtName.Text, bool.Parse(RadioButtonList1.SelectedValue));
        //通过调用ModifyCategory()方法进行修改
        categoryManager.ModifyCategory(modelCategoryManager);
        //修改完立即关闭
        Response.Write("<script>window.close()</script>");
    }

    /// <summary>
    /// 通过分类编号查询信息
    /// </summary>
    /// <param name="id"></param>
    public void getBind(int id)
    {
        Model.CategoryManager modelcate = categoryManager.GetCategory(id);
        txtName.Text = modelcate.CategoryName;
    }
}
