﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.Data.SqlClient;
using DBUtility;

public partial class Controls_CategoryAdd : System.Web.UI.UserControl
{
    /// <summary>
    /// 调用接口实现
    /// 调用IBLL.ICategoryManager接口
    /// </summary>
    IBLL.ICategoryManager categoryManager = BLLFactory.BusinessLogic.CreateCategoryManager();
    protected void Page_Load(object sender, EventArgs e)
    {
        FatherBind();
    }

    /// <summary>
    /// 绑定下拉列表
    /// 调用App_Code里面的common类的DropDownListBind()方法绑定下拉列表
    /// (这是一个提供数据绑定的方法)
    /// </summary>
    protected void FatherBind()
    {
        //创建参数
        SqlParameter parm = new SqlParameter("@CategoryManagerId", SqlDbType.Int);
        //给参数赋值
        parm.Value = int.Parse(Request["superiorId"]);
        //调用common类的DropDownListBind()方法绑定下拉列表
        //CategoryName显示下拉列表的内容
        common.DropDownListBind(ddlFather, "CategoryName", "CategoryManagerId", SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectCategoryById", parm);
    }

    /// <summary>
    /// 添加数据
    /// 通过声明Model.CategoryManger对象获得要添加的文本,然后通过调用AddCategory()方法进行添加
    /// 添加完后并提示数据添加成功
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        //声明CategoryManger对象
        Model.CategoryManager modelCategoryManager = new Model.CategoryManager();
        //把要添加的文本传入Model
        modelCategoryManager.SuperiorId = int.Parse(Request["superiorId"]);
        modelCategoryManager.CategoryName = txtName.Text;
        modelCategoryManager.IsOpen = bool.Parse(RadioButtonList1.SelectedValue);
        //通过调用AddCategory()方法进行添加
        int linkId = categoryManager.AddCategory(modelCategoryManager);
        //当上级目录编号为1时执行以下代码
        if (Request["superiorId"].ToString() == "1")
        {
            if (linkId > 0)
            {
                    int j = common.InsertCategoryToTree(txtName.Text, linkId);
                    if (j > 0)
                    {
                        //插入数据提示添加成功
                        Response.Write("<script>alert('添加成功！！')</script>");
                    }
            }
        }
        else
        {
            if (linkId > 0)
            {
                int j = common.InsertCategoryToTree_Admin(txtName.Text, linkId);
                if (j > 0)
                {
                    //插入数据提示添加成功
                    Response.Write("<script>alert('添加成功！！')</script>");
                }
            }
        }
    }
}
