﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Model;
using DBUtility;

public partial class Controls_Client_BookListByCategory : System.Web.UI.UserControl
{
    IBLL.IBook book = BLLFactory.BusinessLogic.CreateBook();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request["categoryId"] != null)
        {
            ViewState["categoryId"] = Request["categoryId"].ToString();
            BookListBind();
        }
    }
    public void BookListBind()
    {
        if (ViewState["categoryId"] != null)
        {
            Pager.RecordCount = common.GetBookCountByCategory(Convert.ToInt32(ViewState["categoryId"]));
            PagerParameter pager = new PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
            IList<Model.Book> bookSource = book.GetBookListByCategoryId(Convert.ToInt32(ViewState["categoryId"]), pager);
            dlBookListCat.DataSource = bookSource;
            dlBookListCat.DataBind();
            Pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + Pager.RecordCount.ToString() + "</b></font>";
            Pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + Pager.PageCount.ToString() + "</b></font>";
            Pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + Pager.CurrentPageIndex.ToString() + "</b></font>";
        }
    }
    public string SubString(string s)
    {
        string str = s.Trim();
        if (str.Length > 50)
            return str.Substring(0, 50) + "……";
        else
            return str + "……";
    }
    protected void Pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        Pager.CurrentPageIndex = e.NewPageIndex;
        BookListBind();
    }
}
