﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DBUtility;

public partial class Controls_Client_CommentsList : System.Web.UI.UserControl
{
    IBLL.IComments com = BLLFactory.BusinessLogic.CreateComments();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request["bookId"] != null)
            {
                ViewState["bookId"] = Request["bookId"].ToString();
                CommentBind();
            }
        }
    }
    public void CommentBind()
    {

        if (ViewState["bookId"] != null)
        {
            Pager.RecordCount = com.GetCommentsCountByBookId(Convert.ToInt32(ViewState["bookId"]));
            Model.PagerParameter pager = new Model.PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
            IList<Model.Comments> comSource = com.GetCommentsByBookId(Convert.ToInt32(ViewState["bookId"]), pager);
            rptComments.DataSource = comSource;
            rptComments.DataBind();
            Pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + Pager.RecordCount.ToString() + "</b></font>";
            Pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + Pager.PageCount.ToString() + "</b></font>";
            Pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + Pager.CurrentPageIndex.ToString() + "</b></font>";
        }
    }
    public string IsTop(bool isTop)
    {
        if (isTop == true)
            return "[置顶]";
        else
            return "";
    }
    public string IsHighlights(bool isHighlight)
    {
        if (isHighlight == true)
            return "[精华]";
        else
            return "";
    }
    protected void Pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        Pager.CurrentPageIndex = e.NewPageIndex;
        CommentBind();
    }
    protected void btnSubmit_Click(object sender, ImageClickEventArgs e)
    {
        if (Session["UserName"] == null)
        {
            Response.Write("<script>alert('必须登录才能发表评论。');location='Login.aspx'</script>");
        }
        else
        {
            ViewState["UserName"] = Session["UserName"].ToString();
            if (ViewState["bookId"] != null)
            {
                string commentText = txtComment.Text.Trim();
                if (commentText.Length >= 200)
                {
                    commentText = commentText.Substring(0, 200);
                }
                Model.Comments comment = new Model.Comments(0, Convert.ToInt32(ViewState["bookId"]), txtTitle.Text, ViewState["UserName"].ToString(),
                                                          commentText, true, DateTime.Now, false, false);
                int i = com.AddComments(comment);
                if (i > 0)
                {
                    ProfileCommon p = Profile.GetProfile(ViewState["UserName"].ToString());
                    p.Score += common.GetCommentScore();
                    p.PostCount += 1;
                    p.Save();
                    CommentBind();
                    txtTitle.Text = "";
                    txtComment.Text = "";
                    Response.Write("<script>alert('发表成功！');location='BookInfo.aspx?bookId=" + ViewState["bookId"] + "'</script>");
                }
            }
        }
    }
}
