﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Controls_Client_NewAuthor : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            NewAuthorBind();
        }
    }
    public void NewAuthorBind()
    {
        rptNewAuthor.DataSource = NewAuthor();
        rptNewAuthor.DataBind();
    }
    public DataTable NewAuthor()
    {
        MembershipUserCollection mu = Membership.GetAllUsers();
        DataTable dt = new DataTable();
        dt.Columns.Add("PenName",Type.GetType("System.String"));
        dt.Columns.Add("ApplyTime",Type.GetType("System.String"));
        foreach (MembershipUser user in mu)
        {
            ProfileCommon p = Profile.GetProfile(user.UserName);
            if (p.ApplyAuthorTime != null && p.ApplyAuthorTime != "")
            {
                float applyTime = DateTimeConvert.GetSecond(p.ApplyAuthorTime);
                float nowTime = DateTimeConvert.GetSecond(DateTime.Now.ToString());
                float time=(nowTime - applyTime) / (3600 * 24);
                if (time <= 3)
                {
                    DataRow dr = dt.NewRow();
                    dr[0] = p.PenName;
                    dr[1] = p.ApplyAuthorTime;
                    dt.Rows.Add(dr);
                }
            }
        }
        dt.AcceptChanges();
        return dt;
    }
    public string GetShortDateString(string addTime)
    {
        string s = addTime.ToString();
        int t = s.LastIndexOf(':');
        return s.Substring(0,t);
    }
}
