﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using DBUtility;

public partial class Controls_Client_NewBook : System.Web.UI.UserControl
{
    IBLL.IBook book = BLLFactory.BusinessLogic.CreateBook();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            NewBookBind();
        }
    }
    public void NewBookBind()
    {
        IList<Model.Book> bookSource = book.GetTopBookList(10);
        rptNewBook.DataSource = bookSource;
        rptNewBook.DataBind();
    }
    public string Date(DateTime time)
    {
        string t = time.ToString();
        string year = DateTimeConvert.GetDate(t, "year");
        string month = DateTimeConvert.GetDate(t, "month");
        string day = DateTimeConvert.GetDate(t, "day");
        StringBuilder sb = new StringBuilder();
        sb.Append(year);
        sb.Append("-");
        sb.Append(month);
        sb.Append("-");
        sb.Append(day);
        return sb.ToString();
    }
}
