﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Model;
using DBUtility;

public partial class Controls_Client_SearchBook : System.Web.UI.UserControl
{
    IBLL.IBook book = BLLFactory.BusinessLogic.CreateBook();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BookBind();
        }
    }
    public void BookBind()
    {
        if (Request["tag"] != null&&Request["key"]!=null)
        {
            string tag = Request["tag"].ToString();
            string key = Request["key"].ToString();
            if (tag == "author")
            {
                Pager.RecordCount=common.GetBookCountByAuthor(key);
                PagerParameter pager=new PagerParameter(Pager.StartRecordIndex,Pager.EndRecordIndex,false);
                IList<Model.Book> book_authorSource=book.GetBookByAuthor(key,pager);
                dlBookListBySearch.DataSource = book_authorSource;
                dlBookListBySearch.DataBind();
                Pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + Pager.RecordCount.ToString() + "</b></font>";
                Pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + Pager.PageCount.ToString() + "</b></font>";
                Pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + Pager.CurrentPageIndex.ToString() + "</b></font>";
            }
            else if (tag == "bookName")
            {
                Pager.RecordCount = common.GetBookCountByBookName(key);
                PagerParameter pager = new PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
                IList<Model.Book> book_nameSource = book.GetBookByTitle(key, pager);
                dlBookListBySearch.DataSource = book_nameSource;
                dlBookListBySearch.DataBind();
                Pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + Pager.RecordCount.ToString() + "</b></font>";
                Pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + Pager.PageCount.ToString() + "</b></font>";
                Pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + Pager.CurrentPageIndex.ToString() + "</b></font>";
            }
        }
    }
    public string SubString(string s)
    {
        string str = s.Trim();
        if (str.Length > 50)
            return str.Substring(0, 50) + "……";
        else
            return str + "……";
    }
    protected void Pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        Pager.CurrentPageIndex = e.NewPageIndex;
        BookBind();
    }
}
