﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DBUtility;
using System.Collections.Generic;
using System.Text;
using System.IO;

public partial class Controls_DataCollection_UserCommonCollection : System.Web.UI.UserControl
{
    /// <summary>
    /// 定义接口实现
    /// </summary>
    IBLL.ICollectionCyclostyle collectionCyclostyle = BLLFactory.BusinessLogic.CreateCollectionCyclostyle();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            pager.RecordCount = Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetCollectionCyclostyle", null));
            getBind();
        }
    }

    /// <summary>
    /// 分页
    /// </summary>
    /// <param name="src"></param>
    /// <param name="e"></param>
    protected void pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        pager.CurrentPageIndex = e.NewPageIndex;
        getBind();
    }

    /// <summary>
    /// 绑定GridView
    /// </summary>
    public void getBind()
    {
        //获得数据库中所有数据
        pager.RecordCount = Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetCollectionCyclostyle", null));
        //实现分页
        Model.PagerParameter pagers = new Model.PagerParameter(pager.StartRecordIndex, pager.EndRecordIndex, false);
        IList<Model.CollectionCyclostyle> modelCollectionCyclostyle = collectionCyclostyle.GetCollectionCyclostyleList(pagers);
        gvBind.DataSource = modelCollectionCyclostyle;
        gvBind.DataBind();
        //自定义信息显示
        pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + pager.RecordCount.ToString() + "</b></font>";
        pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + pager.PageCount.ToString() + "</b></font>";
        pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + pager.CurrentPageIndex.ToString() + "</b></font>";
    }

    /// <summary>
    /// 删除数据
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lkbtnDelete_Command(object sender, CommandEventArgs e)
    {
        //获得id
        int id = Convert.ToInt32(e.CommandArgument);
        //通过id进行删除
        collectionCyclostyle.RemoveCollectionCyclostyle(id);
        getBind();
    }
    protected void lkbtnExcel_Command(object sender, CommandEventArgs e)
    {
        //重新绑定GridView
        getBind();
        //输出流格试
        Response.ContentType = "application/vnd.ms-Excel";
        //弹出提示框（提示打开，保存，取消）
        Response.AddHeader("Content-Disposition", "inline;filename=" + HttpUtility.UrlEncode("Excel.xls", Encoding.UTF8));
    }

    /// <summary>
    /// 鼠标移动事件
    /// 鼠标放在GridView相应的行上面变色,离开时变回原色
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void gvBind_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
    }
}
