﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Controls_DataCollection_UserEditBookTemplet : System.Web.UI.UserControl
{
    /// <summary>
    /// 定义接口实现
    /// </summary>
    IBLL.ICollectionBookCyclostyle collectionBookCyclostyle = BLLFactory.BusinessLogic.CreateCollectionBookCyclostyle();
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = -1;
        if (!Page.IsPostBack)
        {
            getBind(int.Parse(Request["collectionCyclostyleID"]));
        }
    }

    /// <summary>
    /// 编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        string str = this.txtReadBook.Value;
        int endIndex = str.IndexOf("|");
        string bookId = str.Substring(0, endIndex);
        //获得书籍模板编号
        int id = int.Parse(Request["collectionCyclostyleID"]);
        //声明Model.CollectionBookCyclostyle对象
        Model.CollectionBookCyclostyle modelCollectionBookCyclostyle = new Model.CollectionBookCyclostyle(id, ddlName.SelectedItem.Text,
            bookId, txtAddress.Text, int.Parse(txtID.Text), txtContentAddress.Text);
        //调用ModifyCollectionBookCyclostyle()方法进行编辑
        collectionBookCyclostyle.ModifyCollectionBookCyclostyle(modelCollectionBookCyclostyle);
    }

    /// <summary>
    /// 显示信息
    /// </summary>
    /// <param name="id">书籍模板编号</param>
    private void getBind(int id)
    {
        //声明Model.CollectionBookCyclostyle对象,通过ID进行查询
        Model.CollectionBookCyclostyle modelCollectionBookCyclostyle = collectionBookCyclostyle.GetCollectionBookCyclostyle(id);
        ddlName.Text = modelCollectionBookCyclostyle.CollectionCyclostyleName;
        txtReadBook.Value = modelCollectionBookCyclostyle.ReadBook;
        txtAddress.Text = modelCollectionBookCyclostyle.CollectionAddress;
        txtID.Text = Convert.ToString(modelCollectionBookCyclostyle.CollectionBookID);
        txtContentAddress.Text = modelCollectionBookCyclostyle.CollectionContentAddress;
    }
}
