﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Controls_DataCollection_UserEditCommonCollection : System.Web.UI.UserControl
{
    /// <summary>
    /// 定义接口实现
    /// </summary>
    IBLL.ICollectionCyclostyle collectionCyclostyle = BLLFactory.BusinessLogic.CreateCollectionCyclostyle();
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = -1;
        if (!Page.IsPostBack)
        {
            //通过ID查找
            getBind(int.Parse(Request["id"]));
        }
    }

    /// <summary>
    /// 编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        //获得编辑ID
        int id = int.Parse(Request["id"]);
        //声明Model.CollectionCyclostyle对象
        Model.CollectionCyclostyle modelCollectionCyclostyle = new Model.CollectionCyclostyle(id, txtName.Text, txtBigBound.Text, txtVolumeBound.Text,
        txtVolumeTitle.Text, txtChapter.Text, int.Parse(txtChapterID.Text), TextBox7.Text, txtContent.Text, TextBox9.Text, System.DateTime.Now.ToString());
        //调用ModifyCollectionCyclostyle()方法进行编辑
        collectionCyclostyle.ModifyCollectionCyclostyle(modelCollectionCyclostyle);
    }

    /// <summary>
    /// 显示信息
    /// </summary>
    /// <param name="id">普通采集编号</param>
    public void getBind(int id)
    {
        //声明Model.CollectionCyclostyle对象,通过普通采集编号进行查询
        Model.CollectionCyclostyle modelCollectionCyclostyle = collectionCyclostyle.GetCollectionCyclostyle(id);
        txtName.Text = modelCollectionCyclostyle.CyclostyleName;
        txtBigBound.Text = modelCollectionCyclostyle.FiltrateBigBound;
        txtVolumeBound.Text = modelCollectionCyclostyle.FiltrateVolumeBound;
        txtVolumeTitle.Text = modelCollectionCyclostyle.FiltrateVolumeTitle;
        txtChapter.Text = modelCollectionCyclostyle.FiltrateChapter;
        txtChapterID.Text = Convert.ToString(modelCollectionCyclostyle.FiltrateChapterID);
        TextBox7.Text = modelCollectionCyclostyle.FiltrateChapterTitle;
        txtContent.Text = modelCollectionCyclostyle.FiltrateContent;
        TextBox9.Text = modelCollectionCyclostyle.DelChapter;
    }
}
