﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Controls_Display : System.Web.UI.UserControl
{
    IBLL.IView view = BLLFactory.BusinessLogic.CreateView();
    

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["UserName"] != null)
            {
                ProfileCommon p = Profile.GetProfile(Session["UserName"].ToString());
                ViewState["role"] = common.GetAuthorityName(p.Rating);
                if (ViewState["role"].ToString() == "系统管理员")
                {
                    GetView();
                }
                else
                {
                    Response.Redirect("/TengfeiWeb/BookManager/Sorry.aspx");
                }
            }
            else
            {
                Response.Redirect("/TengfeiWeb/Clientele/SessionOut.aspx");
            }
        }
    }
    //更新显示参数
    protected void btnKeep_Click(object sender, EventArgs e)
    {
        Model.View modelView = new Model.View(1,

                                             txtVip.Text,
                                             txtRenovate.Text,
                                             int.Parse(txtAlways.Text),
                                             int.Parse(txtMonth.Text),
                                             int.Parse(txtWeek.Text),
                                             int.Parse(txtDady.Text),
                                             txtNewbook.Text,
                                             int.Parse(txtPop.Text),
                                             int.Parse(txtTaxis.Text),
                                             txtNew.Text,
                                             int.Parse(txtNewb.Text),
                                             txtSort.Text,
                                             txtAuthorship.Text,
                                             int.Parse(txtGroom.Text),
                                             txtLeague.Text,
                                             txtSpecial.Text,
                                             txtTownee.Text,
                                             txtEngage.Text,
                                             txtNewVouch.Text,
                                             txtNewAppear.Text,
                                             int.Parse(txtReadingGift.Text),
                                             txtFirstSoulCivil.Text,
                                             txtFirstSoulRow.Text,
                                             txtSortTransfer.Text,
                                             int.Parse(txtSortPopTaxis.Text),
                                             int.Parse(txtChiefReadingTaxis.Text),
                                             txtSoulCivilVouch.Text,
                                             txtNewSoulCivil.Text,
                                             txtSoulCivilPop.Text,
                                             txtSoulCivilRow.Text,
                                             int.Parse(txtCivilVouchTaxis.Text),
                                             int.Parse(txtIntegral.Text),
                                             txtCompositor.Text);
        view.ModifyView(modelView);
    }
    //查询显示参数
    public void GetView()
    {
        Model.View viewInfo = view.GetAllView();
        txtVip.Text = viewInfo.VipTable;
        txtRenovate.Text = viewInfo.PubliTable;
        txtAlways.Text = viewInfo.ChiefTable.ToString();
        txtMonth.Text = viewInfo.MonthTable.ToString();
        txtWeek.Text = viewInfo.WeekTable.ToString();
        txtDady.Text = viewInfo.DayTable.ToString();
        txtNewbook.Text = viewInfo.NewBookWarehouse;
        txtPop.Text = viewInfo.Pop.ToString();
        txtTaxis.Text = viewInfo.ChiefTaxis.ToString();
        txtNew.Text = viewInfo.NewReview;
        txtNewb.Text = viewInfo.NewBookTaxis.ToString();
        txtSort.Text = viewInfo.SortReviewTable;
        txtAuthorship.Text = viewInfo.AuthorshipReviewTable;
        txtGroom.Text = viewInfo.VouchTaxis.ToString();
        txtLeague.Text = viewInfo.DifferentAuthorLeague;
        txtSpecial.Text = viewInfo.NewAuthorLeague;
        txtTownee.Text = viewInfo.TowneeAuthor;
        txtEngage.Text = viewInfo.SpecialAuthor;
        txtNewVouch.Text = viewInfo.NewVouch;
        txtNewAppear.Text = viewInfo.NewAppear;
        txtReadingGift.Text = viewInfo.ReadingGift.ToString();
        txtFirstSoulCivil.Text = viewInfo.FirstSoulCivil;
        txtFirstSoulRow.Text = viewInfo.FirstSoulRow;
        txtSortTransfer.Text = viewInfo.SortTransfer;
        txtSortPopTaxis.Text = viewInfo.SortPopTaxis.ToString();
        txtChiefReadingTaxis.Text = viewInfo.ChiefReadingTaxis.ToString();
        txtSoulCivilVouch.Text = viewInfo.SoulCivilVouch;
        txtNewSoulCivil.Text = viewInfo.NewSoulCivil;
        txtSoulCivilPop.Text = viewInfo.SoulCivilPop;
        txtSoulCivilRow.Text = viewInfo.SoulCivilRow;
        txtCivilVouchTaxis.Text = viewInfo.CivilVouchTaxis.ToString();
        txtIntegral.Text = viewInfo.IntegralTaxis.ToString();
        txtCompositor.Text = viewInfo.IntegralTaxisRow;
    }
}
