﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.Profile;
using System.Data.Sql;
using System.Data.SqlClient;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DBUtility;
using BLL;

public partial class Controls_CreateUser : System.Web.UI.UserControl
{
    IBLL.IRedCategory cat = BLLFactory.BusinessLogic.CreateRedCategory();
    IBLL.IMemberGroup mbg = BLLFactory.BusinessLogic.CreateMemberGroup();
  
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            ProvinceBind();
            CityBind();
            AreaBind();
        }
    }
    public void ProvinceBind()
    {
        common.DropDownListBind(dropProvince, "province", "provinceID", SqlHelper.connectionString,
                                CommandType.StoredProcedure, "Tengfei_SelectProvince");
    }
    public void AreaBind()
    {
        SqlParameter parm = new SqlParameter("@CityId", SqlDbType.Int);
        parm.Value = 110100;
        common.DropDownListBind(dropArea, "area", "areaID", SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectAreaByCityId",parm);
    }
    public void CityBind()
    {
        SqlParameter parm = new SqlParameter("@ProvinceId", SqlDbType.Int);
        parm.Value = 110000;
        common.DropDownListBind(dropCity, "city", "cityID", SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectCityByProvinceId",parm);
    }
    protected void CreateUserWizard1_CreatedUser(object sender, EventArgs e)
    {
        //通过GetTextBox方法及参数ID来获取该ID下的控件
        TextBox UserName = GetTextBox("UserName");
        TextBox NickName = GetTextBox("txtUserNick");
        //通过GetDropdownlist方法及参数ID来获取该ID下的控件
        DropDownList Sex = GetDropdownlist("dropSex");
        DropDownList Year = GetDropdownlist("dropYear");
        DropDownList Month = GetDropdownlist("dropMonth");
        DropDownList Day = GetDropdownlist("dropDay");
        DropDownList Province = GetDropdownlist("dropProvince");
        DropDownList City = GetDropdownlist("dropCity");
        DropDownList Area = GetDropdownlist("dropArea");
        TextBox QQ = GetTextBox("txtQQ");
        //通过UserName来指定要更新的用户
        ProfileCommon p = Profile.GetProfile(UserName.Text);
        
        p.NickName = NickName.Text;      //昵称
        p.Sex = Sex.SelectedItem.Text;       //性别
        //出生日期
        p.Birthday = Year.SelectedValue + "-" + Month.SelectedValue+"-"+Day.SelectedValue;
        p.QQ = QQ.Text;                  //QQ号
        //地址
        p.Address = Province.SelectedValue + "," + City.SelectedValue + "," + Area.SelectedValue;
        //以下信息为默认初始化信息
        p.MemberGroup =35;            //隶属会员组
        p.Rating = 96;        //隶属等级
        p.Score = common.GetRegistScore();                 //积分
        p.DayVoteCount = mb(p.MemberGroup).DayRecTicket;           //日投票数
        p.DayAdCount = mb(p.MemberGroup).DayAdTicket;
        p.CollectBookCount = mb(p.MemberGroup).LibraryCount;      //可藏书数量
        p.IsLoked = false;            //是否锁定
        p.LoginCount = 1;             //登录次数
        p.PostCount = 0;              //发帖数
        p.IsAuthor = false;           //是否是作者
        //保存以上修改信息
        p.Save();
        Session["UserName"] = p.UserName;
    }
    public Model.MemberGroup mb(int id)
    {
        Model.MemberGroup memberGroup = mbg.GetMemberGroupById(id);
        return memberGroup;
    }
    //定义该方法来通过传入参数ID查找该ID下的控件
    public TextBox GetTextBox(string textboxName)
    {
        TextBox textbox= (TextBox)CreateUserWizard1.CreateUserStep.ContentTemplateContainer.FindControl(textboxName);
        return textbox;
    }
    //定义该方法来通过传入参数ID查找该ID下的控件
    public DropDownList GetDropdownlist(string dropdownlistName)
    {
        DropDownList dropdownlist = (DropDownList)CreateUserWizard1.CreateUserStep.ContentTemplateContainer.FindControl(dropdownlistName);
        return dropdownlist;
    }

    protected void dropProvince_SelectedIndexChanged(object sender, EventArgs e)
    {
        SqlParameter parm = new SqlParameter("@ProvinceId", SqlDbType.Int);
        parm.Value = int.Parse(dropProvince.SelectedValue);
        common.DropDownListBind(dropCity, "city", "cityID", SqlHelper.connectionString,
                                CommandType.StoredProcedure, "Tengfei_SelectCityByProvinceId", parm);
    }
    protected void dropCity_SelectedIndexChanged(object sender, EventArgs e)
    {
        SqlParameter parm = new SqlParameter("@CityId", SqlDbType.Int);
        parm.Value = int.Parse(dropCity.SelectedValue);
        common.DropDownListBind(dropArea, "area", "areaID", SqlHelper.connectionString,
                                CommandType.StoredProcedure, "Tengfei_SelectAreaByCityId", parm);
    }
}
