﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Controls_UserAddMemberGroup : System.Web.UI.UserControl
{
    IBLL.IMemberGroup memberGroup = BLLFactory.BusinessLogic.CreateMemberGroup();
    Model.MemberGroup modelMemberGroup = new Model.MemberGroup();
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");
        if (!IsPostBack)
        {
            RatingBind();
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        modelMemberGroup.MemberGroupName = this.txtMemberGroupName.Text;
        modelMemberGroup.DayRecTicket = int.Parse(this.txtDayRecTicket.Text);
        modelMemberGroup.DayAdTicket = int.Parse(this.txtDayAdTicket.Text);
        modelMemberGroup.LibraryCount = int.Parse(this.txtLibraryCount.Text);
        modelMemberGroup.PromoteScore = int.Parse(this.txtPromoteScore.Text);
        modelMemberGroup.Rating = int.Parse(this.txtRating.Text);
        int linkId=memberGroup.AddMemberGroup(modelMemberGroup);
        if (linkId > 0)
        {
            int i = common.InsetMemberGroupToTree(txtMemberGroupName.Text, linkId);
            if (i > 0)
            {
                Response.Write("<script>alert('新会员组成功添加！！')</script>");  
            }
        }
        else
        {
            Response.Write("<script>alert('新会员组添加失败！！')</script>");
        }
    }
    public void RatingBind()
    {
        txtRating.Text = memberGroup.GetMaxRatingInMemberGroup().ToString();
    }
    
}
