﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;


public partial class Controls_UserAddNewUser : System.Web.UI.UserControl
{
    IBLL.IMemberGroup memberGroup = BLLFactory.BusinessLogic.CreateMemberGroup();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            MemberGroupBind();
            ProvinceBind();
            CityBind();
            AreaBind();
        }
    }
    public void AreaBind()
    {
        SqlParameter parm = new SqlParameter("@CityId", SqlDbType.Int);
        parm.Value = 110100;
        common.DropDownListBind(dropArea, "area", "areaID", SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectAreaByCityId", parm);
    }
    public void CityBind()
    {
        SqlParameter parm = new SqlParameter("@ProvinceId", SqlDbType.Int);
        parm.Value = 110000;
        common.DropDownListBind(dropCity, "city", "cityID", SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectCityByProvinceId", parm);
    }
    public void ProvinceBind()
    {
        common.DropDownListBind(dropProvince, "province", "provinceID", SqlHelper.connectionString,
                                CommandType.StoredProcedure, "Tengfei_SelectProvince");
    }
    public void MemberGroupBind()
    {
        common.DropDownListBind(ddlMemberGroup, "MemberGroupName", "MemberGroupId", SqlHelper.connectionString,
                                CommandType.StoredProcedure, "Tengfei_SelectAllMemberGroup");
    }
    protected void dropProvince_SelectedIndexChanged(object sender, EventArgs e)
    {
        SqlParameter parm = new SqlParameter("@ProvinceId", SqlDbType.Int);
        parm.Value=int.Parse(dropProvince.SelectedValue);
        common.DropDownListBind(dropCity, "city", "cityID", SqlHelper.connectionString,
                                CommandType.StoredProcedure, "Tengfei_SelectCityByProvinceId", parm);
    }
    protected void dropCity_SelectedIndexChanged(object sender, EventArgs e)
    {
        SqlParameter parm = new SqlParameter("@CityId", SqlDbType.Int);
        parm.Value = int.Parse(dropCity.SelectedValue);
        common.DropDownListBind(dropArea, "area", "areaID", SqlHelper.connectionString,
                                CommandType.StoredProcedure, "Tengfei_SelectAreaByCityId", parm);
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        MembershipUser user = null;
        MembershipCreateStatus ms;
        user = Membership.CreateUser(txtUserName.Text,
                                   txtPassWord.Text,
                                   txtEmail.Text,
                                   txtQuestion.Text,
                                   txtAnswer.Text,
                                   true, out ms);
        if (ms == MembershipCreateStatus.Success)
        {
            Model.MemberGroup mb = mbgp(); 
            ProfileCommon p = Profile.GetProfile(txtUserName.Text);
            p.NickName = txtNickName.Text;
            p.Sex = rdbSex.SelectedItem.Text;
            p.MemberGroup = int.Parse(ddlMemberGroup.SelectedValue);
            p.Rating =int.Parse(ddlRating.SelectedValue);
            p.DayAdCount = mb.DayAdTicket;
            p.DayVoteCount = mb.DayRecTicket;
            p.CollectBookCount = mb.LibraryCount;
            p.QQ = txtQQ.Text;
            p.Birthday = dropYear.SelectedValue + "-" + dropMonth.SelectedValue + "-" + dropDay.SelectedValue;
            p.Address = dropProvince.SelectedValue + "," + dropCity.SelectedValue + "," + dropArea.SelectedValue;
            p.Score = int.Parse(txtScore.Text);
            p.IsLoked = bool.Parse(rdbLocked.SelectedValue);
            p.PostCount = int.Parse(txtPostCount.Text);
            p.IsAuthor = false;
            p.LoginCount = 0;
            p.Save();
            Response.Write("<script>alert('操作成功！');</script>");
        }
        else
        {
            switch (ms)
            {
                case MembershipCreateStatus.DuplicateUserName:
                    Message.Text = "该用户已存在，请另选其它用户名。";
                    break;
                case MembershipCreateStatus.InvalidPassword:
                    Message.Text = "密码格式不正确。长度不能小于6位数。";
                    break;
                case MembershipCreateStatus.DuplicateEmail:
                    Message.Text = "该电子邮件已存在，请重新填写。";
                    break;
                case MembershipCreateStatus.InvalidQuestion:
                    Message.Text = "密码提示问题格式不正确。";
                    break;
                case MembershipCreateStatus.InvalidAnswer:
                    Message.Text = "密码提示答案不正确。";
                    break;
            }
        }
        
                                   
    }
    public Model.MemberGroup mbgp()
    {
        Model.MemberGroup objmb = memberGroup.GetMemberGroupById(Convert.ToInt32(ddlMemberGroup.SelectedValue));
        return objmb;
    }
}
