﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;

public partial class Controls_UserEditMemberGroup : System.Web.UI.UserControl
{
    IBLL.IMemberGroup memberGroup = BLLFactory.BusinessLogic.CreateMemberGroup();
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");
        if (!IsPostBack)
        {
            ControlBind();
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request["id"] != null)
        {
            int id = Convert.ToInt32(Request["id"]);
            Model.MemberGroup modelMemberGroup = new Model.MemberGroup(id,
            this.txtMemberGroupName.Text, int.Parse(this.txtDayRecTicket.Text),
            int.Parse(this.txtDayAdTicket.Text), int.Parse(this.txtLibraryCount.Text),
            int.Parse(this.txtPromoteScore.Text), int.Parse(txtRating.Text));

            int i = memberGroup.ModifyMemberGroup(modelMemberGroup);
            if (i > 0)
            {
                Response.Write("<script>alert('修改成功！');</script>");
            }
            else
            {
                Response.Write("<script>alert('修改失败！');</script>");
            }
        }
    }
    public void ControlBind()
    {
        if (Request["id"] != null)
        {
            int id = Convert.ToInt32(Request["id"]);
            Model.MemberGroup objMemberGroup = memberGroup.GetMemberGroupById(id);
            txtMemberGroupName.Text = objMemberGroup.MemberGroupName;
            txtDayRecTicket.Text = objMemberGroup.DayRecTicket.ToString();
            txtDayAdTicket.Text = objMemberGroup.DayAdTicket.ToString();
            txtLibraryCount.Text = objMemberGroup.LibraryCount.ToString();
            txtPromoteScore.Text = objMemberGroup.PromoteScore.ToString();
            txtRating.Text = objMemberGroup.Rating.ToString();
        }
    }
}
